/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSampledRequestsResponse extends WafResponse implements
        ToCopyableBuilder<GetSampledRequestsResponse.Builder, GetSampledRequestsResponse> {
    private static final SdkField<List<SampledHTTPRequest>> SAMPLED_REQUESTS_FIELD = SdkField
            .<List<SampledHTTPRequest>> builder(MarshallingType.LIST)
            .memberName("SampledRequests")
            .getter(getter(GetSampledRequestsResponse::sampledRequests))
            .setter(setter(Builder::sampledRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampledRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SampledHTTPRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SampledHTTPRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> POPULATION_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PopulationSize").getter(getter(GetSampledRequestsResponse::populationSize))
            .setter(setter(Builder::populationSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PopulationSize").build()).build();

    private static final SdkField<TimeWindow> TIME_WINDOW_FIELD = SdkField.<TimeWindow> builder(MarshallingType.SDK_POJO)
            .memberName("TimeWindow").getter(getter(GetSampledRequestsResponse::timeWindow)).setter(setter(Builder::timeWindow))
            .constructor(TimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeWindow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLED_REQUESTS_FIELD,
            POPULATION_SIZE_FIELD, TIME_WINDOW_FIELD));

    private final List<SampledHTTPRequest> sampledRequests;

    private final Long populationSize;

    private final TimeWindow timeWindow;

    private GetSampledRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.sampledRequests = builder.sampledRequests;
        this.populationSize = builder.populationSize;
        this.timeWindow = builder.timeWindow;
    }

    /**
     * For responses, this returns true if the service returned a value for the SampledRequests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSampledRequests() {
        return sampledRequests != null && !(sampledRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains detailed information about each of the requests in the sample.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSampledRequests} method.
     * </p>
     * 
     * @return A complex type that contains detailed information about each of the requests in the sample.
     */
    public final List<SampledHTTPRequest> sampledRequests() {
        return sampledRequests;
    }

    /**
     * <p>
     * The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code>
     * requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every request
     * that your AWS resource received during the specified time range.
     * </p>
     * 
     * @return The total number of requests from which <code>GetSampledRequests</code> got a sample of
     *         <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the
     *         sample includes every request that your AWS resource received during the specified time range.
     */
    public final Long populationSize() {
        return populationSize;
    }

    /**
     * <p>
     * Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code>
     * request. However, if your AWS resource received more than 5,000 requests during the time range that you specified
     * in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000 requests. Times are in
     * Coordinated Universal Time (UTC) format.
     * </p>
     * 
     * @return Usually, <code>TimeWindow</code> is the time range that you specified in the
     *         <code>GetSampledRequests</code> request. However, if your AWS resource received more than 5,000 requests
     *         during the time range that you specified in the request, <code>GetSampledRequests</code> returns the time
     *         range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC) format.
     */
    public final TimeWindow timeWindow() {
        return timeWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSampledRequests() ? sampledRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(populationSize());
        hashCode = 31 * hashCode + Objects.hashCode(timeWindow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampledRequestsResponse)) {
            return false;
        }
        GetSampledRequestsResponse other = (GetSampledRequestsResponse) obj;
        return hasSampledRequests() == other.hasSampledRequests() && Objects.equals(sampledRequests(), other.sampledRequests())
                && Objects.equals(populationSize(), other.populationSize()) && Objects.equals(timeWindow(), other.timeWindow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSampledRequestsResponse")
                .add("SampledRequests", hasSampledRequests() ? sampledRequests() : null).add("PopulationSize", populationSize())
                .add("TimeWindow", timeWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SampledRequests":
            return Optional.ofNullable(clazz.cast(sampledRequests()));
        case "PopulationSize":
            return Optional.ofNullable(clazz.cast(populationSize()));
        case "TimeWindow":
            return Optional.ofNullable(clazz.cast(timeWindow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSampledRequestsResponse, T> g) {
        return obj -> g.apply((GetSampledRequestsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSampledRequestsResponse> {
        /**
         * <p>
         * A complex type that contains detailed information about each of the requests in the sample.
         * </p>
         * 
         * @param sampledRequests
         *        A complex type that contains detailed information about each of the requests in the sample.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampledRequests(Collection<SampledHTTPRequest> sampledRequests);

        /**
         * <p>
         * A complex type that contains detailed information about each of the requests in the sample.
         * </p>
         * 
         * @param sampledRequests
         *        A complex type that contains detailed information about each of the requests in the sample.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampledRequests(SampledHTTPRequest... sampledRequests);

        /**
         * <p>
         * A complex type that contains detailed information about each of the requests in the sample.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SampledHTTPRequest>.Builder} avoiding the
         * need to create one manually via {@link List<SampledHTTPRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SampledHTTPRequest>.Builder#build()} is called immediately
         * and its result is passed to {@link #sampledRequests(List<SampledHTTPRequest>)}.
         * 
         * @param sampledRequests
         *        a consumer that will call methods on {@link List<SampledHTTPRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampledRequests(List<SampledHTTPRequest>)
         */
        Builder sampledRequests(Consumer<SampledHTTPRequest.Builder>... sampledRequests);

        /**
         * <p>
         * The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code>
         * requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every
         * request that your AWS resource received during the specified time range.
         * </p>
         * 
         * @param populationSize
         *        The total number of requests from which <code>GetSampledRequests</code> got a sample of
         *        <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the
         *        sample includes every request that your AWS resource received during the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder populationSize(Long populationSize);

        /**
         * <p>
         * Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code>
         * request. However, if your AWS resource received more than 5,000 requests during the time range that you
         * specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000
         * requests. Times are in Coordinated Universal Time (UTC) format.
         * </p>
         * 
         * @param timeWindow
         *        Usually, <code>TimeWindow</code> is the time range that you specified in the
         *        <code>GetSampledRequests</code> request. However, if your AWS resource received more than 5,000
         *        requests during the time range that you specified in the request, <code>GetSampledRequests</code>
         *        returns the time range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC)
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeWindow(TimeWindow timeWindow);

        /**
         * <p>
         * Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code>
         * request. However, if your AWS resource received more than 5,000 requests during the time range that you
         * specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000
         * requests. Times are in Coordinated Universal Time (UTC) format.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeWindow.Builder} avoiding the need to create
         * one manually via {@link TimeWindow#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeWindow.Builder#build()} is called immediately and its result
         * is passed to {@link #timeWindow(TimeWindow)}.
         * 
         * @param timeWindow
         *        a consumer that will call methods on {@link TimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeWindow(TimeWindow)
         */
        default Builder timeWindow(Consumer<TimeWindow.Builder> timeWindow) {
            return timeWindow(TimeWindow.builder().applyMutation(timeWindow).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private List<SampledHTTPRequest> sampledRequests = DefaultSdkAutoConstructList.getInstance();

        private Long populationSize;

        private TimeWindow timeWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampledRequestsResponse model) {
            super(model);
            sampledRequests(model.sampledRequests);
            populationSize(model.populationSize);
            timeWindow(model.timeWindow);
        }

        public final List<SampledHTTPRequest.Builder> getSampledRequests() {
            List<SampledHTTPRequest.Builder> result = SampledHTTPRequestsCopier.copyToBuilder(this.sampledRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampledRequests(Collection<SampledHTTPRequest.BuilderImpl> sampledRequests) {
            this.sampledRequests = SampledHTTPRequestsCopier.copyFromBuilder(sampledRequests);
        }

        @Override
        @Transient
        public final Builder sampledRequests(Collection<SampledHTTPRequest> sampledRequests) {
            this.sampledRequests = SampledHTTPRequestsCopier.copy(sampledRequests);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sampledRequests(SampledHTTPRequest... sampledRequests) {
            sampledRequests(Arrays.asList(sampledRequests));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sampledRequests(Consumer<SampledHTTPRequest.Builder>... sampledRequests) {
            sampledRequests(Stream.of(sampledRequests).map(c -> SampledHTTPRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getPopulationSize() {
            return populationSize;
        }

        public final void setPopulationSize(Long populationSize) {
            this.populationSize = populationSize;
        }

        @Override
        @Transient
        public final Builder populationSize(Long populationSize) {
            this.populationSize = populationSize;
            return this;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return timeWindow != null ? timeWindow.toBuilder() : null;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        @Override
        @Transient
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        @Override
        public GetSampledRequestsResponse build() {
            return new GetSampledRequestsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
