/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRuleGroupRequest extends WafRequest implements
        ToCopyableBuilder<UpdateRuleGroupRequest.Builder, UpdateRuleGroupRequest> {
    private static final SdkField<String> RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupId").getter(getter(UpdateRuleGroupRequest::ruleGroupId)).setter(setter(Builder::ruleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupId").build()).build();

    private static final SdkField<List<RuleGroupUpdate>> UPDATES_FIELD = SdkField
            .<List<RuleGroupUpdate>> builder(MarshallingType.LIST)
            .memberName("Updates")
            .getter(getter(UpdateRuleGroupRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(UpdateRuleGroupRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ID_FIELD,
            UPDATES_FIELD, CHANGE_TOKEN_FIELD));

    private final String ruleGroupId;

    private final List<RuleGroupUpdate> updates;

    private final String changeToken;

    private UpdateRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.ruleGroupId = builder.ruleGroupId;
        this.updates = builder.updates;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to update. <code>RuleGroupId</code> is
     * returned by <a>CreateRuleGroup</a> and by <a>ListRuleGroups</a>.
     * </p>
     * 
     * @return The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to update. <code>RuleGroupId</code> is
     *         returned by <a>CreateRuleGroup</a> and by <a>ListRuleGroups</a>.
     */
    public final String ruleGroupId() {
        return ruleGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Updates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a <a>RuleGroup</a>.
     * </p>
     * <p>
     * You can only insert <code>REGULAR</code> rules into a rule group.
     * </p>
     * <p>
     * <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a
     * <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update
     * requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdates} method.
     * </p>
     * 
     * @return An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a
     *         <a>RuleGroup</a>.</p>
     *         <p>
     *         You can only insert <code>REGULAR</code> rules into a rule group.
     *         </p>
     *         <p>
     *         <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code>
     *         to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other
     *         update requests, <code>ActivatedRule|Action</code> is used instead of
     *         <code>ActivatedRule|OverrideAction</code>.
     */
    public final List<RuleGroupUpdate> updates() {
        return updates;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdates() ? updates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleGroupRequest)) {
            return false;
        }
        UpdateRuleGroupRequest other = (UpdateRuleGroupRequest) obj;
        return Objects.equals(ruleGroupId(), other.ruleGroupId()) && hasUpdates() == other.hasUpdates()
                && Objects.equals(updates(), other.updates()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRuleGroupRequest").add("RuleGroupId", ruleGroupId())
                .add("Updates", hasUpdates() ? updates() : null).add("ChangeToken", changeToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupId":
            return Optional.ofNullable(clazz.cast(ruleGroupId()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleGroupRequest, T> g) {
        return obj -> g.apply((UpdateRuleGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRuleGroupRequest> {
        /**
         * <p>
         * The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to update. <code>RuleGroupId</code> is
         * returned by <a>CreateRuleGroup</a> and by <a>ListRuleGroups</a>.
         * </p>
         * 
         * @param ruleGroupId
         *        The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to update. <code>RuleGroupId</code>
         *        is returned by <a>CreateRuleGroup</a> and by <a>ListRuleGroups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupId(String ruleGroupId);

        /**
         * <p>
         * An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a
         * <a>RuleGroup</a>.
         * </p>
         * <p>
         * You can only insert <code>REGULAR</code> rules into a rule group.
         * </p>
         * <p>
         * <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a
         * <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update
         * requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.
         * </p>
         * 
         * @param updates
         *        An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a
         *        <a>RuleGroup</a>.</p>
         *        <p>
         *        You can only insert <code>REGULAR</code> rules into a rule group.
         *        </p>
         *        <p>
         *        <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a
         *        <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use
         *        <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is
         *        used instead of <code>ActivatedRule|OverrideAction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<RuleGroupUpdate> updates);

        /**
         * <p>
         * An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a
         * <a>RuleGroup</a>.
         * </p>
         * <p>
         * You can only insert <code>REGULAR</code> rules into a rule group.
         * </p>
         * <p>
         * <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a
         * <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update
         * requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.
         * </p>
         * 
         * @param updates
         *        An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a
         *        <a>RuleGroup</a>.</p>
         *        <p>
         *        You can only insert <code>REGULAR</code> rules into a rule group.
         *        </p>
         *        <p>
         *        <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a
         *        <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use
         *        <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is
         *        used instead of <code>ActivatedRule|OverrideAction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(RuleGroupUpdate... updates);

        /**
         * <p>
         * An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a
         * <a>RuleGroup</a>.
         * </p>
         * <p>
         * You can only insert <code>REGULAR</code> rules into a rule group.
         * </p>
         * <p>
         * <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a
         * <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update
         * requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RuleGroupUpdate>.Builder} avoiding the need
         * to create one manually via {@link List<RuleGroupUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleGroupUpdate>.Builder#build()} is called immediately and
         * its result is passed to {@link #updates(List<RuleGroupUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on {@link List<RuleGroupUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(List<RuleGroupUpdate>)
         */
        Builder updates(Consumer<RuleGroupUpdate.Builder>... updates);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String ruleGroupId;

        private List<RuleGroupUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleGroupRequest model) {
            super(model);
            ruleGroupId(model.ruleGroupId);
            updates(model.updates);
            changeToken(model.changeToken);
        }

        public final String getRuleGroupId() {
            return ruleGroupId;
        }

        public final void setRuleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
        }

        @Override
        @Transient
        public final Builder ruleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        public final List<RuleGroupUpdate.Builder> getUpdates() {
            List<RuleGroupUpdate.Builder> result = RuleGroupUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<RuleGroupUpdate.BuilderImpl> updates) {
            this.updates = RuleGroupUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        @Transient
        public final Builder updates(Collection<RuleGroupUpdate> updates) {
            this.updates = RuleGroupUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(RuleGroupUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(Consumer<RuleGroupUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> RuleGroupUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        @Transient
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleGroupRequest build() {
            return new UpdateRuleGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
