/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * The <code>Id</code> and <code>Name</code> of an <code>XssMatchSet</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class XssMatchSetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<XssMatchSetSummary.Builder, XssMatchSetSummary> {
    private static final SdkField<String> XSS_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XssMatchSetId").getter(getter(XssMatchSetSummary::xssMatchSetId)).setter(setter(Builder::xssMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(XssMatchSetSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(XSS_MATCH_SET_ID_FIELD,
            NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String xssMatchSetId;

    private final String name;

    private XssMatchSetSummary(BuilderImpl builder) {
        this.xssMatchSetId = builder.xssMatchSetId;
        this.name = builder.name;
    }

    /**
     * <p>
     * A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about
     * a <code>XssMatchSet</code> (see <a>GetXssMatchSet</a>), update an <code>XssMatchSet</code> (see
     * <a>UpdateXssMatchSet</a>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a
     * <code>Rule</code> (see <a>UpdateRule</a>), and delete an <code>XssMatchSet</code> from AWS WAF (see
     * <a>DeleteXssMatchSet</a>).
     * </p>
     * <p>
     * <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.
     * </p>
     * 
     * @return A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get
     *         information about a <code>XssMatchSet</code> (see <a>GetXssMatchSet</a>), update an
     *         <code>XssMatchSet</code> (see <a>UpdateXssMatchSet</a>), insert an <code>XssMatchSet</code> into a
     *         <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete an
     *         <code>XssMatchSet</code> from AWS WAF (see <a>DeleteXssMatchSet</a>).</p>
     *         <p>
     *         <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.
     */
    public final String xssMatchSetId() {
        return xssMatchSetId;
    }

    /**
     * <p>
     * The name of the <code>XssMatchSet</code>, if any, specified by <code>Id</code>.
     * </p>
     * 
     * @return The name of the <code>XssMatchSet</code>, if any, specified by <code>Id</code>.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(xssMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchSetSummary)) {
            return false;
        }
        XssMatchSetSummary other = (XssMatchSetSummary) obj;
        return Objects.equals(xssMatchSetId(), other.xssMatchSetId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("XssMatchSetSummary").add("XssMatchSetId", xssMatchSetId()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "XssMatchSetId":
            return Optional.ofNullable(clazz.cast(xssMatchSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XssMatchSetSummary, T> g) {
        return obj -> g.apply((XssMatchSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, XssMatchSetSummary> {
        /**
         * <p>
         * A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information
         * about a <code>XssMatchSet</code> (see <a>GetXssMatchSet</a>), update an <code>XssMatchSet</code> (see
         * <a>UpdateXssMatchSet</a>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a
         * <code>Rule</code> (see <a>UpdateRule</a>), and delete an <code>XssMatchSet</code> from AWS WAF (see
         * <a>DeleteXssMatchSet</a>).
         * </p>
         * <p>
         * <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.
         * </p>
         * 
         * @param xssMatchSetId
         *        A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get
         *        information about a <code>XssMatchSet</code> (see <a>GetXssMatchSet</a>), update an
         *        <code>XssMatchSet</code> (see <a>UpdateXssMatchSet</a>), insert an <code>XssMatchSet</code> into a
         *        <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete an
         *        <code>XssMatchSet</code> from AWS WAF (see <a>DeleteXssMatchSet</a>).</p>
         *        <p>
         *        <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xssMatchSetId(String xssMatchSetId);

        /**
         * <p>
         * The name of the <code>XssMatchSet</code>, if any, specified by <code>Id</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>XssMatchSet</code>, if any, specified by <code>Id</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String xssMatchSetId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchSetSummary model) {
            xssMatchSetId(model.xssMatchSetId);
            name(model.name);
        }

        public final String getXssMatchSetId() {
            return xssMatchSetId;
        }

        public final void setXssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
        }

        @Override
        @Transient
        public final Builder xssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public XssMatchSetSummary build() {
            return new XssMatchSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
