/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * The <code>Id</code> and <code>Name</code> of a <code>SizeConstraintSet</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SizeConstraintSetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SizeConstraintSetSummary.Builder, SizeConstraintSetSummary> {
    private static final SdkField<String> SIZE_CONSTRAINT_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SizeConstraintSetId").getter(getter(SizeConstraintSetSummary::sizeConstraintSetId))
            .setter(setter(Builder::sizeConstraintSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraintSetId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SizeConstraintSetSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_CONSTRAINT_SET_ID_FIELD,
            NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sizeConstraintSetId;

    private final String name;

    private SizeConstraintSetSummary(BuilderImpl builder) {
        this.sizeConstraintSetId = builder.sizeConstraintSetId;
        this.name = builder.name;
    }

    /**
     * <p>
     * A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get
     * information about a <code>SizeConstraintSet</code> (see <a>GetSizeConstraintSet</a>), update a
     * <code>SizeConstraintSet</code> (see <a>UpdateSizeConstraintSet</a>), insert a <code>SizeConstraintSet</code> into
     * a <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
     * <code>SizeConstraintSet</code> from AWS WAF (see <a>DeleteSizeConstraintSet</a>).
     * </p>
     * <p>
     * <code>SizeConstraintSetId</code> is returned by <a>CreateSizeConstraintSet</a> and by
     * <a>ListSizeConstraintSets</a>.
     * </p>
     * 
     * @return A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get
     *         information about a <code>SizeConstraintSet</code> (see <a>GetSizeConstraintSet</a>), update a
     *         <code>SizeConstraintSet</code> (see <a>UpdateSizeConstraintSet</a>), insert a
     *         <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see
     *         <a>UpdateRule</a>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see
     *         <a>DeleteSizeConstraintSet</a>).</p>
     *         <p>
     *         <code>SizeConstraintSetId</code> is returned by <a>CreateSizeConstraintSet</a> and by
     *         <a>ListSizeConstraintSets</a>.
     */
    public final String sizeConstraintSetId() {
        return sizeConstraintSetId;
    }

    /**
     * <p>
     * The name of the <code>SizeConstraintSet</code>, if any.
     * </p>
     * 
     * @return The name of the <code>SizeConstraintSet</code>, if any.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeConstraintSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SizeConstraintSetSummary)) {
            return false;
        }
        SizeConstraintSetSummary other = (SizeConstraintSetSummary) obj;
        return Objects.equals(sizeConstraintSetId(), other.sizeConstraintSetId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SizeConstraintSetSummary").add("SizeConstraintSetId", sizeConstraintSetId()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeConstraintSetId":
            return Optional.ofNullable(clazz.cast(sizeConstraintSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SizeConstraintSetSummary, T> g) {
        return obj -> g.apply((SizeConstraintSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SizeConstraintSetSummary> {
        /**
         * <p>
         * A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get
         * information about a <code>SizeConstraintSet</code> (see <a>GetSizeConstraintSet</a>), update a
         * <code>SizeConstraintSet</code> (see <a>UpdateSizeConstraintSet</a>), insert a <code>SizeConstraintSet</code>
         * into a <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
         * <code>SizeConstraintSet</code> from AWS WAF (see <a>DeleteSizeConstraintSet</a>).
         * </p>
         * <p>
         * <code>SizeConstraintSetId</code> is returned by <a>CreateSizeConstraintSet</a> and by
         * <a>ListSizeConstraintSets</a>.
         * </p>
         * 
         * @param sizeConstraintSetId
         *        A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to
         *        get information about a <code>SizeConstraintSet</code> (see <a>GetSizeConstraintSet</a>), update a
         *        <code>SizeConstraintSet</code> (see <a>UpdateSizeConstraintSet</a>), insert a
         *        <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see
         *        <a>UpdateRule</a>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see
         *        <a>DeleteSizeConstraintSet</a>).</p>
         *        <p>
         *        <code>SizeConstraintSetId</code> is returned by <a>CreateSizeConstraintSet</a> and by
         *        <a>ListSizeConstraintSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeConstraintSetId(String sizeConstraintSetId);

        /**
         * <p>
         * The name of the <code>SizeConstraintSet</code>, if any.
         * </p>
         * 
         * @param name
         *        The name of the <code>SizeConstraintSet</code>, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String sizeConstraintSetId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SizeConstraintSetSummary model) {
            sizeConstraintSetId(model.sizeConstraintSetId);
            name(model.name);
        }

        public final String getSizeConstraintSetId() {
            return sizeConstraintSetId;
        }

        public final void setSizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
        }

        @Override
        public final Builder sizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SizeConstraintSetSummary build() {
            return new SizeConstraintSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
