/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Contains the identifier and the name or description of the <a>WebACL</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebACLSummary implements SdkPojo, Serializable, ToCopyableBuilder<WebACLSummary.Builder, WebACLSummary> {
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLId").getter(getter(WebACLSummary::webACLId)).setter(setter(Builder::webACLId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(WebACLSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ID_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String webACLId;

    private final String name;

    private WebACLSummary(BuilderImpl builder) {
        this.webACLId = builder.webACLId;
        this.name = builder.name;
    }

    /**
     * <p>
     * A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a
     * <code>WebACL</code> (see <a>GetWebACL</a>), update a <code>WebACL</code> (see <a>UpdateWebACL</a>), and delete a
     * <code>WebACL</code> from AWS WAF (see <a>DeleteWebACL</a>).
     * </p>
     * <p>
     * <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
     * </p>
     * 
     * @return A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a
     *         <code>WebACL</code> (see <a>GetWebACL</a>), update a <code>WebACL</code> (see <a>UpdateWebACL</a>), and
     *         delete a <code>WebACL</code> from AWS WAF (see <a>DeleteWebACL</a>).</p>
     *         <p>
     *         <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
     */
    public final String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * A friendly name or description of the <a>WebACL</a>. You can't change the name of a <code>WebACL</code> after you
     * create it.
     * </p>
     * 
     * @return A friendly name or description of the <a>WebACL</a>. You can't change the name of a <code>WebACL</code>
     *         after you create it.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLSummary)) {
            return false;
        }
        WebACLSummary other = (WebACLSummary) obj;
        return Objects.equals(webACLId(), other.webACLId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebACLSummary").add("WebACLId", webACLId()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACLId":
            return Optional.ofNullable(clazz.cast(webACLId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebACLSummary, T> g) {
        return obj -> g.apply((WebACLSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebACLSummary> {
        /**
         * <p>
         * A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a
         * <code>WebACL</code> (see <a>GetWebACL</a>), update a <code>WebACL</code> (see <a>UpdateWebACL</a>), and
         * delete a <code>WebACL</code> from AWS WAF (see <a>DeleteWebACL</a>).
         * </p>
         * <p>
         * <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
         * </p>
         * 
         * @param webACLId
         *        A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about
         *        a <code>WebACL</code> (see <a>GetWebACL</a>), update a <code>WebACL</code> (see <a>UpdateWebACL</a>),
         *        and delete a <code>WebACL</code> from AWS WAF (see <a>DeleteWebACL</a>).</p>
         *        <p>
         *        <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * A friendly name or description of the <a>WebACL</a>. You can't change the name of a <code>WebACL</code> after
         * you create it.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the <a>WebACL</a>. You can't change the name of a
         *        <code>WebACL</code> after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String webACLId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLSummary model) {
            webACLId(model.webACLId);
            name(model.name);
        }

        public final String getWebACLId() {
            return webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public WebACLSummary build() {
            return new WebACLSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
