/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGeoMatchSetResponse extends WafResponse implements
        ToCopyableBuilder<CreateGeoMatchSetResponse.Builder, CreateGeoMatchSetResponse> {
    private static final SdkField<GeoMatchSet> GEO_MATCH_SET_FIELD = SdkField.<GeoMatchSet> builder(MarshallingType.SDK_POJO)
            .memberName("GeoMatchSet").getter(getter(CreateGeoMatchSetResponse::geoMatchSet))
            .setter(setter(Builder::geoMatchSet)).constructor(GeoMatchSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchSet").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(CreateGeoMatchSetResponse::changeToken))
            .setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEO_MATCH_SET_FIELD,
            CHANGE_TOKEN_FIELD));

    private final GeoMatchSet geoMatchSet;

    private final String changeToken;

    private CreateGeoMatchSetResponse(BuilderImpl builder) {
        super(builder);
        this.geoMatchSet = builder.geoMatchSet;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * The <a>GeoMatchSet</a> returned in the <code>CreateGeoMatchSet</code> response. The <code>GeoMatchSet</code>
     * contains no <code>GeoMatchConstraints</code>.
     * </p>
     * 
     * @return The <a>GeoMatchSet</a> returned in the <code>CreateGeoMatchSet</code> response. The
     *         <code>GeoMatchSet</code> contains no <code>GeoMatchConstraints</code>.
     */
    public final GeoMatchSet geoMatchSet() {
        return geoMatchSet;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateGeoMatchSet</code> request. You can also use
     * this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateGeoMatchSet</code> request. You can
     *         also use this value to query the status of the request. For more information, see
     *         <a>GetChangeTokenStatus</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(geoMatchSet());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGeoMatchSetResponse)) {
            return false;
        }
        CreateGeoMatchSetResponse other = (CreateGeoMatchSetResponse) obj;
        return Objects.equals(geoMatchSet(), other.geoMatchSet()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGeoMatchSetResponse").add("GeoMatchSet", geoMatchSet()).add("ChangeToken", changeToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoMatchSet":
            return Optional.ofNullable(clazz.cast(geoMatchSet()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGeoMatchSetResponse, T> g) {
        return obj -> g.apply((CreateGeoMatchSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGeoMatchSetResponse> {
        /**
         * <p>
         * The <a>GeoMatchSet</a> returned in the <code>CreateGeoMatchSet</code> response. The <code>GeoMatchSet</code>
         * contains no <code>GeoMatchConstraints</code>.
         * </p>
         * 
         * @param geoMatchSet
         *        The <a>GeoMatchSet</a> returned in the <code>CreateGeoMatchSet</code> response. The
         *        <code>GeoMatchSet</code> contains no <code>GeoMatchConstraints</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchSet(GeoMatchSet geoMatchSet);

        /**
         * <p>
         * The <a>GeoMatchSet</a> returned in the <code>CreateGeoMatchSet</code> response. The <code>GeoMatchSet</code>
         * contains no <code>GeoMatchConstraints</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link GeoMatchSet.Builder} avoiding the need to create
         * one manually via {@link GeoMatchSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link GeoMatchSet.Builder#build()} is called immediately and its result
         * is passed to {@link #geoMatchSet(GeoMatchSet)}.
         * 
         * @param geoMatchSet
         *        a consumer that will call methods on {@link GeoMatchSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoMatchSet(GeoMatchSet)
         */
        default Builder geoMatchSet(Consumer<GeoMatchSet.Builder> geoMatchSet) {
            return geoMatchSet(GeoMatchSet.builder().applyMutation(geoMatchSet).build());
        }

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateGeoMatchSet</code> request. You can also
         * use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateGeoMatchSet</code> request. You
         *        can also use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private GeoMatchSet geoMatchSet;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGeoMatchSetResponse model) {
            super(model);
            geoMatchSet(model.geoMatchSet);
            changeToken(model.changeToken);
        }

        public final GeoMatchSet.Builder getGeoMatchSet() {
            return geoMatchSet != null ? geoMatchSet.toBuilder() : null;
        }

        public final void setGeoMatchSet(GeoMatchSet.BuilderImpl geoMatchSet) {
            this.geoMatchSet = geoMatchSet != null ? geoMatchSet.build() : null;
        }

        @Override
        @Transient
        public final Builder geoMatchSet(GeoMatchSet geoMatchSet) {
            this.geoMatchSet = geoMatchSet;
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        @Transient
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        @Override
        public CreateGeoMatchSetResponse build() {
            return new CreateGeoMatchSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
