/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSizeConstraintSetResponse extends WafResponse implements
        ToCopyableBuilder<GetSizeConstraintSetResponse.Builder, GetSizeConstraintSetResponse> {
    private static final SdkField<SizeConstraintSet> SIZE_CONSTRAINT_SET_FIELD = SdkField
            .<SizeConstraintSet> builder(MarshallingType.SDK_POJO).memberName("SizeConstraintSet")
            .getter(getter(GetSizeConstraintSetResponse::sizeConstraintSet)).setter(setter(Builder::sizeConstraintSet))
            .constructor(SizeConstraintSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraintSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_CONSTRAINT_SET_FIELD));

    private final SizeConstraintSet sizeConstraintSet;

    private GetSizeConstraintSetResponse(BuilderImpl builder) {
        super(builder);
        this.sizeConstraintSet = builder.sizeConstraintSet;
    }

    /**
     * <p>
     * Information about the <a>SizeConstraintSet</a> that you specified in the <code>GetSizeConstraintSet</code>
     * request. For more information, see the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>SizeConstraintSet</a>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SizeConstraints</code>: Contains an array of <a>SizeConstraint</a> objects. Each
     * <code>SizeConstraint</code> object contains <a>FieldToMatch</a>, <code>TextTransformation</code>,
     * <code>ComparisonOperator</code>, and <code>Size</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the <a>SizeConstraintSet</a> that you specified in the
     *         <code>GetSizeConstraintSet</code> request. For more information, see the following topics:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>SizeConstraintSet</a>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and
     *         <code>Name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SizeConstraints</code>: Contains an array of <a>SizeConstraint</a> objects. Each
     *         <code>SizeConstraint</code> object contains <a>FieldToMatch</a>, <code>TextTransformation</code>,
     *         <code>ComparisonOperator</code>, and <code>Size</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     *         </p>
     *         </li>
     */
    public final SizeConstraintSet sizeConstraintSet() {
        return sizeConstraintSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sizeConstraintSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSizeConstraintSetResponse)) {
            return false;
        }
        GetSizeConstraintSetResponse other = (GetSizeConstraintSetResponse) obj;
        return Objects.equals(sizeConstraintSet(), other.sizeConstraintSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSizeConstraintSetResponse").add("SizeConstraintSet", sizeConstraintSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeConstraintSet":
            return Optional.ofNullable(clazz.cast(sizeConstraintSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSizeConstraintSetResponse, T> g) {
        return obj -> g.apply((GetSizeConstraintSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSizeConstraintSetResponse> {
        /**
         * <p>
         * Information about the <a>SizeConstraintSet</a> that you specified in the <code>GetSizeConstraintSet</code>
         * request. For more information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>SizeConstraintSet</a>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeConstraints</code>: Contains an array of <a>SizeConstraint</a> objects. Each
         * <code>SizeConstraint</code> object contains <a>FieldToMatch</a>, <code>TextTransformation</code>,
         * <code>ComparisonOperator</code>, and <code>Size</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param sizeConstraintSet
         *        Information about the <a>SizeConstraintSet</a> that you specified in the
         *        <code>GetSizeConstraintSet</code> request. For more information, see the following topics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>SizeConstraintSet</a>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and
         *        <code>Name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SizeConstraints</code>: Contains an array of <a>SizeConstraint</a> objects. Each
         *        <code>SizeConstraint</code> object contains <a>FieldToMatch</a>, <code>TextTransformation</code>,
         *        <code>ComparisonOperator</code>, and <code>Size</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeConstraintSet(SizeConstraintSet sizeConstraintSet);

        /**
         * <p>
         * Information about the <a>SizeConstraintSet</a> that you specified in the <code>GetSizeConstraintSet</code>
         * request. For more information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>SizeConstraintSet</a>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeConstraints</code>: Contains an array of <a>SizeConstraint</a> objects. Each
         * <code>SizeConstraint</code> object contains <a>FieldToMatch</a>, <code>TextTransformation</code>,
         * <code>ComparisonOperator</code>, and <code>Size</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link SizeConstraintSet.Builder} avoiding the need to
         * create one manually via {@link SizeConstraintSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link SizeConstraintSet.Builder#build()} is called immediately and its
         * result is passed to {@link #sizeConstraintSet(SizeConstraintSet)}.
         * 
         * @param sizeConstraintSet
         *        a consumer that will call methods on {@link SizeConstraintSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizeConstraintSet(SizeConstraintSet)
         */
        default Builder sizeConstraintSet(Consumer<SizeConstraintSet.Builder> sizeConstraintSet) {
            return sizeConstraintSet(SizeConstraintSet.builder().applyMutation(sizeConstraintSet).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private SizeConstraintSet sizeConstraintSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSizeConstraintSetResponse model) {
            super(model);
            sizeConstraintSet(model.sizeConstraintSet);
        }

        public final SizeConstraintSet.Builder getSizeConstraintSet() {
            return sizeConstraintSet != null ? sizeConstraintSet.toBuilder() : null;
        }

        public final void setSizeConstraintSet(SizeConstraintSet.BuilderImpl sizeConstraintSet) {
            this.sizeConstraintSet = sizeConstraintSet != null ? sizeConstraintSet.build() : null;
        }

        @Override
        @Transient
        public final Builder sizeConstraintSet(SizeConstraintSet sizeConstraintSet) {
            this.sizeConstraintSet = sizeConstraintSet;
            return this;
        }

        @Override
        public GetSizeConstraintSetResponse build() {
            return new GetSizeConstraintSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
