/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegexMatchSetsResponse extends WafResponse implements
        ToCopyableBuilder<ListRegexMatchSetsResponse.Builder, ListRegexMatchSetsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListRegexMatchSetsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<RegexMatchSetSummary>> REGEX_MATCH_SETS_FIELD = SdkField
            .<List<RegexMatchSetSummary>> builder(MarshallingType.LIST)
            .memberName("RegexMatchSets")
            .getter(getter(ListRegexMatchSetsResponse::regexMatchSets))
            .setter(setter(Builder::regexMatchSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegexMatchSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegexMatchSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            REGEX_MATCH_SETS_FIELD));

    private final String nextMarker;

    private final List<RegexMatchSetSummary> regexMatchSets;

    private ListRegexMatchSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.regexMatchSets = builder.regexMatchSets;
    }

    /**
     * <p>
     * If you have more <code>RegexMatchSet</code> objects than the number that you specified for <code>Limit</code> in
     * the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexMatchSet</code>
     * objects, submit another <code>ListRegexMatchSets</code> request, and specify the <code>NextMarker</code> value
     * from the response in the <code>NextMarker</code> value in the next request.
     * </p>
     * 
     * @return If you have more <code>RegexMatchSet</code> objects than the number that you specified for
     *         <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
     *         <code>RegexMatchSet</code> objects, submit another <code>ListRegexMatchSets</code> request, and specify
     *         the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next
     *         request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegexMatchSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegexMatchSets() {
        return regexMatchSets != null && !(regexMatchSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>RegexMatchSetSummary</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegexMatchSets} method.
     * </p>
     * 
     * @return An array of <a>RegexMatchSetSummary</a> objects.
     */
    public final List<RegexMatchSetSummary> regexMatchSets() {
        return regexMatchSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegexMatchSets() ? regexMatchSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegexMatchSetsResponse)) {
            return false;
        }
        ListRegexMatchSetsResponse other = (ListRegexMatchSetsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasRegexMatchSets() == other.hasRegexMatchSets()
                && Objects.equals(regexMatchSets(), other.regexMatchSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRegexMatchSetsResponse").add("NextMarker", nextMarker())
                .add("RegexMatchSets", hasRegexMatchSets() ? regexMatchSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "RegexMatchSets":
            return Optional.ofNullable(clazz.cast(regexMatchSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRegexMatchSetsResponse, T> g) {
        return obj -> g.apply((ListRegexMatchSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRegexMatchSetsResponse> {
        /**
         * <p>
         * If you have more <code>RegexMatchSet</code> objects than the number that you specified for <code>Limit</code>
         * in the request, the response includes a <code>NextMarker</code> value. To list more
         * <code>RegexMatchSet</code> objects, submit another <code>ListRegexMatchSets</code> request, and specify the
         * <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.
         * </p>
         * 
         * @param nextMarker
         *        If you have more <code>RegexMatchSet</code> objects than the number that you specified for
         *        <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more
         *        <code>RegexMatchSet</code> objects, submit another <code>ListRegexMatchSets</code> request, and
         *        specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of <a>RegexMatchSetSummary</a> objects.
         * </p>
         * 
         * @param regexMatchSets
         *        An array of <a>RegexMatchSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchSets(Collection<RegexMatchSetSummary> regexMatchSets);

        /**
         * <p>
         * An array of <a>RegexMatchSetSummary</a> objects.
         * </p>
         * 
         * @param regexMatchSets
         *        An array of <a>RegexMatchSetSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchSets(RegexMatchSetSummary... regexMatchSets);

        /**
         * <p>
         * An array of <a>RegexMatchSetSummary</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RegexMatchSetSummary>.Builder} avoiding the
         * need to create one manually via {@link List<RegexMatchSetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegexMatchSetSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #regexMatchSets(List<RegexMatchSetSummary>)}.
         * 
         * @param regexMatchSets
         *        a consumer that will call methods on {@link List<RegexMatchSetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexMatchSets(List<RegexMatchSetSummary>)
         */
        Builder regexMatchSets(Consumer<RegexMatchSetSummary.Builder>... regexMatchSets);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<RegexMatchSetSummary> regexMatchSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegexMatchSetsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            regexMatchSets(model.regexMatchSets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        @Transient
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<RegexMatchSetSummary.Builder> getRegexMatchSets() {
            List<RegexMatchSetSummary.Builder> result = RegexMatchSetSummariesCopier.copyToBuilder(this.regexMatchSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexMatchSets(Collection<RegexMatchSetSummary.BuilderImpl> regexMatchSets) {
            this.regexMatchSets = RegexMatchSetSummariesCopier.copyFromBuilder(regexMatchSets);
        }

        @Override
        @Transient
        public final Builder regexMatchSets(Collection<RegexMatchSetSummary> regexMatchSets) {
            this.regexMatchSets = RegexMatchSetSummariesCopier.copy(regexMatchSets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regexMatchSets(RegexMatchSetSummary... regexMatchSets) {
            regexMatchSets(Arrays.asList(regexMatchSets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regexMatchSets(Consumer<RegexMatchSetSummary.Builder>... regexMatchSets) {
            regexMatchSets(Stream.of(regexMatchSets).map(c -> RegexMatchSetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRegexMatchSetsResponse build() {
            return new ListRegexMatchSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
