/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Returned by <a>ListRegexPatternSets</a>. Each <code>RegexPatternSetSummary</code> object includes the
 * <code>Name</code> and <code>RegexPatternSetId</code> for one <a>RegexPatternSet</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegexPatternSetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RegexPatternSetSummary.Builder, RegexPatternSetSummary> {
    private static final SdkField<String> REGEX_PATTERN_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegexPatternSetId").getter(getter(RegexPatternSetSummary::regexPatternSetId))
            .setter(setter(Builder::regexPatternSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RegexPatternSetSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_PATTERN_SET_ID_FIELD,
            NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regexPatternSetId;

    private final String name;

    private RegexPatternSetSummary(BuilderImpl builder) {
        this.regexPatternSetId = builder.regexPatternSetId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to
     * get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a
     * <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code> from
     * AWS WAF.
     * </p>
     * <p>
     * <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by <a>ListRegexPatternSets</a>.
     * </p>
     * 
     * @return The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use
     *         <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a
     *         <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>,
     *         and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
     *         <p>
     *         <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
     *         <a>ListRegexPatternSets</a>.
     */
    public final String regexPatternSetId() {
        return regexPatternSetId;
    }

    /**
     * <p>
     * A friendly name or description of the <a>RegexPatternSet</a>. You can't change <code>Name</code> after you create
     * a <code>RegexPatternSet</code>.
     * </p>
     * 
     * @return A friendly name or description of the <a>RegexPatternSet</a>. You can't change <code>Name</code> after
     *         you create a <code>RegexPatternSet</code>.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regexPatternSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPatternSetSummary)) {
            return false;
        }
        RegexPatternSetSummary other = (RegexPatternSetSummary) obj;
        return Objects.equals(regexPatternSetId(), other.regexPatternSetId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegexPatternSetSummary").add("RegexPatternSetId", regexPatternSetId()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexPatternSetId":
            return Optional.ofNullable(clazz.cast(regexPatternSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexPatternSetSummary, T> g) {
        return obj -> g.apply((RegexPatternSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegexPatternSetSummary> {
        /**
         * <p>
         * The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code>
         * to get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a
         * <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code>
         * from AWS WAF.
         * </p>
         * <p>
         * <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
         * <a>ListRegexPatternSets</a>.
         * </p>
         * 
         * @param regexPatternSetId
         *        The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use
         *        <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a
         *        <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>,
         *        and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
         *        <p>
         *        <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
         *        <a>ListRegexPatternSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexPatternSetId(String regexPatternSetId);

        /**
         * <p>
         * A friendly name or description of the <a>RegexPatternSet</a>. You can't change <code>Name</code> after you
         * create a <code>RegexPatternSet</code>.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the <a>RegexPatternSet</a>. You can't change <code>Name</code> after
         *        you create a <code>RegexPatternSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String regexPatternSetId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(RegexPatternSetSummary model) {
            regexPatternSetId(model.regexPatternSetId);
            name(model.name);
        }

        public final String getRegexPatternSetId() {
            return regexPatternSetId;
        }

        public final void setRegexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
        }

        @Override
        @Transient
        public final Builder regexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public RegexPatternSetSummary build() {
            return new RegexPatternSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
