/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRegexPatternSetRequest extends WafRequest implements
        ToCopyableBuilder<UpdateRegexPatternSetRequest.Builder, UpdateRegexPatternSetRequest> {
    private static final SdkField<String> REGEX_PATTERN_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegexPatternSetId").getter(getter(UpdateRegexPatternSetRequest::regexPatternSetId))
            .setter(setter(Builder::regexPatternSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternSetId").build()).build();

    private static final SdkField<List<RegexPatternSetUpdate>> UPDATES_FIELD = SdkField
            .<List<RegexPatternSetUpdate>> builder(MarshallingType.LIST)
            .memberName("Updates")
            .getter(getter(UpdateRegexPatternSetRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegexPatternSetUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegexPatternSetUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(UpdateRegexPatternSetRequest::changeToken))
            .setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_PATTERN_SET_ID_FIELD,
            UPDATES_FIELD, CHANGE_TOKEN_FIELD));

    private final String regexPatternSetId;

    private final List<RegexPatternSetUpdate> updates;

    private final String changeToken;

    private UpdateRegexPatternSetRequest(BuilderImpl builder) {
        super(builder);
        this.regexPatternSetId = builder.regexPatternSetId;
        this.updates = builder.updates;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to update.
     * <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by <a>ListRegexPatternSets</a>.
     * </p>
     * 
     * @return The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to update.
     *         <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
     *         <a>ListRegexPatternSets</a>.
     */
    public final String regexPatternSetId() {
        return regexPatternSetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Updates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a
     * <a>RegexPatternSet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdates} method.
     * </p>
     * 
     * @return An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a
     *         <a>RegexPatternSet</a>.
     */
    public final List<RegexPatternSetUpdate> updates() {
        return updates;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(regexPatternSetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdates() ? updates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRegexPatternSetRequest)) {
            return false;
        }
        UpdateRegexPatternSetRequest other = (UpdateRegexPatternSetRequest) obj;
        return Objects.equals(regexPatternSetId(), other.regexPatternSetId()) && hasUpdates() == other.hasUpdates()
                && Objects.equals(updates(), other.updates()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRegexPatternSetRequest").add("RegexPatternSetId", regexPatternSetId())
                .add("Updates", hasUpdates() ? updates() : null).add("ChangeToken", changeToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexPatternSetId":
            return Optional.ofNullable(clazz.cast(regexPatternSetId()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRegexPatternSetRequest, T> g) {
        return obj -> g.apply((UpdateRegexPatternSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRegexPatternSetRequest> {
        /**
         * <p>
         * The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to update.
         * <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
         * <a>ListRegexPatternSets</a>.
         * </p>
         * 
         * @param regexPatternSetId
         *        The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to update.
         *        <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
         *        <a>ListRegexPatternSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexPatternSetId(String regexPatternSetId);

        /**
         * <p>
         * An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a
         * <a>RegexPatternSet</a>.
         * </p>
         * 
         * @param updates
         *        An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a
         *        <a>RegexPatternSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<RegexPatternSetUpdate> updates);

        /**
         * <p>
         * An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a
         * <a>RegexPatternSet</a>.
         * </p>
         * 
         * @param updates
         *        An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a
         *        <a>RegexPatternSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(RegexPatternSetUpdate... updates);

        /**
         * <p>
         * An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a
         * <a>RegexPatternSet</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RegexPatternSetUpdate>.Builder} avoiding
         * the need to create one manually via {@link List<RegexPatternSetUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegexPatternSetUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #updates(List<RegexPatternSetUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on {@link List<RegexPatternSetUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(List<RegexPatternSetUpdate>)
         */
        Builder updates(Consumer<RegexPatternSetUpdate.Builder>... updates);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String regexPatternSetId;

        private List<RegexPatternSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRegexPatternSetRequest model) {
            super(model);
            regexPatternSetId(model.regexPatternSetId);
            updates(model.updates);
            changeToken(model.changeToken);
        }

        public final String getRegexPatternSetId() {
            return regexPatternSetId;
        }

        public final void setRegexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
        }

        @Override
        @Transient
        public final Builder regexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
            return this;
        }

        public final List<RegexPatternSetUpdate.Builder> getUpdates() {
            List<RegexPatternSetUpdate.Builder> result = RegexPatternSetUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<RegexPatternSetUpdate.BuilderImpl> updates) {
            this.updates = RegexPatternSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        @Transient
        public final Builder updates(Collection<RegexPatternSetUpdate> updates) {
            this.updates = RegexPatternSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(RegexPatternSetUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(Consumer<RegexPatternSetUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> RegexPatternSetUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        @Transient
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRegexPatternSetRequest build() {
            return new UpdateRegexPatternSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
