/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWebAclRequest extends WafRequest implements
        ToCopyableBuilder<UpdateWebAclRequest.Builder, UpdateWebAclRequest> {
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLId").getter(getter(UpdateWebAclRequest::webACLId)).setter(setter(Builder::webACLId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(UpdateWebAclRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final SdkField<List<WebACLUpdate>> UPDATES_FIELD = SdkField
            .<List<WebACLUpdate>> builder(MarshallingType.LIST)
            .memberName("Updates")
            .getter(getter(UpdateWebAclRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WebACLUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(WebACLUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<WafAction> DEFAULT_ACTION_FIELD = SdkField.<WafAction> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultAction").getter(getter(UpdateWebAclRequest::defaultAction))
            .setter(setter(Builder::defaultAction)).constructor(WafAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ID_FIELD,
            CHANGE_TOKEN_FIELD, UPDATES_FIELD, DEFAULT_ACTION_FIELD));

    private final String webACLId;

    private final String changeToken;

    private final List<WebACLUpdate> updates;

    private final WafAction defaultAction;

    private UpdateWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
        this.defaultAction = builder.defaultAction;
    }

    /**
     * <p>
     * The <code>WebACLId</code> of the <a>WebACL</a> that you want to update. <code>WebACLId</code> is returned by
     * <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
     * </p>
     * 
     * @return The <code>WebACLId</code> of the <a>WebACL</a> that you want to update. <code>WebACLId</code> is returned
     *         by <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
     */
    public final String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Updates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of updates to make to the <a>WebACL</a>.
     * </p>
     * <p>
     * An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a <a>WebACL</a>. For
     * more information, see the applicable data types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>WebACLUpdate</a>: Contains <code>Action</code> and <code>ActivatedRule</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ActivatedRule</a>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>,
     * <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when updating
     * or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use
     * <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used
     * instead of <code>ActivatedRule|OverrideAction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>WafAction</a>: Contains <code>Type</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdates} method.
     * </p>
     * 
     * @return An array of updates to make to the <a>WebACL</a>.</p>
     *         <p>
     *         An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a
     *         <a>WebACL</a>. For more information, see the applicable data types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>WebACLUpdate</a>: Contains <code>Action</code> and <code>ActivatedRule</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>ActivatedRule</a>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>,
     *         <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when
     *         updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use
     *         <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is
     *         used instead of <code>ActivatedRule|OverrideAction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>WafAction</a>: Contains <code>Type</code>
     *         </p>
     *         </li>
     */
    public final List<WebACLUpdate> updates() {
        return updates;
    }

    /**
     * <p>
     * A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default action if a request doesn't
     * match the criteria in any of the rules in a web ACL.
     * </p>
     * 
     * @return A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default action if a request
     *         doesn't match the criteria in any of the rules in a web ACL.
     */
    public final WafAction defaultAction() {
        return defaultAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdates() ? updates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAclRequest)) {
            return false;
        }
        UpdateWebAclRequest other = (UpdateWebAclRequest) obj;
        return Objects.equals(webACLId(), other.webACLId()) && Objects.equals(changeToken(), other.changeToken())
                && hasUpdates() == other.hasUpdates() && Objects.equals(updates(), other.updates())
                && Objects.equals(defaultAction(), other.defaultAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWebAclRequest").add("WebACLId", webACLId()).add("ChangeToken", changeToken())
                .add("Updates", hasUpdates() ? updates() : null).add("DefaultAction", defaultAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACLId":
            return Optional.ofNullable(clazz.cast(webACLId()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        case "DefaultAction":
            return Optional.ofNullable(clazz.cast(defaultAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAclRequest, T> g) {
        return obj -> g.apply((UpdateWebAclRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWebAclRequest> {
        /**
         * <p>
         * The <code>WebACLId</code> of the <a>WebACL</a> that you want to update. <code>WebACLId</code> is returned by
         * <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
         * </p>
         * 
         * @param webACLId
         *        The <code>WebACLId</code> of the <a>WebACL</a> that you want to update. <code>WebACLId</code> is
         *        returned by <a>CreateWebACL</a> and by <a>ListWebACLs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        /**
         * <p>
         * An array of updates to make to the <a>WebACL</a>.
         * </p>
         * <p>
         * An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a <a>WebACL</a>.
         * For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>WebACLUpdate</a>: Contains <code>Action</code> and <code>ActivatedRule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ActivatedRule</a>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>,
         * <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when
         * updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use
         * <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used
         * instead of <code>ActivatedRule|OverrideAction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>WafAction</a>: Contains <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param updates
         *        An array of updates to make to the <a>WebACL</a>.</p>
         *        <p>
         *        An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a
         *        <a>WebACL</a>. For more information, see the applicable data types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>WebACLUpdate</a>: Contains <code>Action</code> and <code>ActivatedRule</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ActivatedRule</a>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>, <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only
         *        when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not
         *        use <code>ActivatedRule|Action</code>. For all other update requests,
         *        <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>WafAction</a>: Contains <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<WebACLUpdate> updates);

        /**
         * <p>
         * An array of updates to make to the <a>WebACL</a>.
         * </p>
         * <p>
         * An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a <a>WebACL</a>.
         * For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>WebACLUpdate</a>: Contains <code>Action</code> and <code>ActivatedRule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ActivatedRule</a>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>,
         * <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when
         * updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use
         * <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used
         * instead of <code>ActivatedRule|OverrideAction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>WafAction</a>: Contains <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param updates
         *        An array of updates to make to the <a>WebACL</a>.</p>
         *        <p>
         *        An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a
         *        <a>WebACL</a>. For more information, see the applicable data types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>WebACLUpdate</a>: Contains <code>Action</code> and <code>ActivatedRule</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>ActivatedRule</a>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>, <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only
         *        when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not
         *        use <code>ActivatedRule|Action</code>. For all other update requests,
         *        <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>WafAction</a>: Contains <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(WebACLUpdate... updates);

        /**
         * <p>
         * An array of updates to make to the <a>WebACL</a>.
         * </p>
         * <p>
         * An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a <a>WebACL</a>.
         * For more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>WebACLUpdate</a>: Contains <code>Action</code> and <code>ActivatedRule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>ActivatedRule</a>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>,
         * <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when
         * updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use
         * <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used
         * instead of <code>ActivatedRule|OverrideAction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>WafAction</a>: Contains <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<WebACLUpdate>.Builder} avoiding the need to
         * create one manually via {@link List<WebACLUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WebACLUpdate>.Builder#build()} is called immediately and its
         * result is passed to {@link #updates(List<WebACLUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on {@link List<WebACLUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(List<WebACLUpdate>)
         */
        Builder updates(Consumer<WebACLUpdate.Builder>... updates);

        /**
         * <p>
         * A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default action if a request
         * doesn't match the criteria in any of the rules in a web ACL.
         * </p>
         * 
         * @param defaultAction
         *        A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default action if a
         *        request doesn't match the criteria in any of the rules in a web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAction(WafAction defaultAction);

        /**
         * <p>
         * A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default action if a request
         * doesn't match the criteria in any of the rules in a web ACL.
         * </p>
         * This is a convenience that creates an instance of the {@link WafAction.Builder} avoiding the need to create
         * one manually via {@link WafAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link WafAction.Builder#build()} is called immediately and its result
         * is passed to {@link #defaultAction(WafAction)}.
         * 
         * @param defaultAction
         *        a consumer that will call methods on {@link WafAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAction(WafAction)
         */
        default Builder defaultAction(Consumer<WafAction.Builder> defaultAction) {
            return defaultAction(WafAction.builder().applyMutation(defaultAction).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String webACLId;

        private String changeToken;

        private List<WebACLUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private WafAction defaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAclRequest model) {
            super(model);
            webACLId(model.webACLId);
            changeToken(model.changeToken);
            updates(model.updates);
            defaultAction(model.defaultAction);
        }

        public final String getWebACLId() {
            return webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        @Transient
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        @Transient
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final List<WebACLUpdate.Builder> getUpdates() {
            List<WebACLUpdate.Builder> result = WebACLUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<WebACLUpdate.BuilderImpl> updates) {
            this.updates = WebACLUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        @Transient
        public final Builder updates(Collection<WebACLUpdate> updates) {
            this.updates = WebACLUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(WebACLUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder updates(Consumer<WebACLUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> WebACLUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final WafAction.Builder getDefaultAction() {
            return defaultAction != null ? defaultAction.toBuilder() : null;
        }

        public final void setDefaultAction(WafAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultAction(WafAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebAclRequest build() {
            return new UpdateWebAclRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
