/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Specifies the part of a web request that you want to inspect for cross-site scripting attacks and indicates whether
 * you want to add the specification to an <a>XssMatchSet</a> or delete it from an <code>XssMatchSet</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class XssMatchSetUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<XssMatchSetUpdate.Builder, XssMatchSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(XssMatchSetUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<XssMatchTuple> XSS_MATCH_TUPLE_FIELD = SdkField
            .<XssMatchTuple> builder(MarshallingType.SDK_POJO).memberName("XssMatchTuple")
            .getter(getter(XssMatchSetUpdate::xssMatchTuple)).setter(setter(Builder::xssMatchTuple))
            .constructor(XssMatchTuple::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XssMatchTuple").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            XSS_MATCH_TUPLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final XssMatchTuple xssMatchTuple;

    private XssMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.xssMatchTuple = builder.xssMatchTuple;
    }

    /**
     * <p>
     * Specify <code>INSERT</code> to add an <a>XssMatchSetUpdate</a> to an <a>XssMatchSet</a>. Use <code>DELETE</code>
     * to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specify <code>INSERT</code> to add an <a>XssMatchSetUpdate</a> to an <a>XssMatchSet</a>. Use
     *         <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * Specify <code>INSERT</code> to add an <a>XssMatchSetUpdate</a> to an <a>XssMatchSet</a>. Use <code>DELETE</code>
     * to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specify <code>INSERT</code> to add an <a>XssMatchSetUpdate</a> to an <a>XssMatchSet</a>. Use
     *         <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if you
     * want AWS WAF to inspect a header, the name of the header.
     * </p>
     * 
     * @return Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks
     *         and, if you want AWS WAF to inspect a header, the name of the header.
     */
    public final XssMatchTuple xssMatchTuple() {
        return xssMatchTuple;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(xssMatchTuple());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchSetUpdate)) {
            return false;
        }
        XssMatchSetUpdate other = (XssMatchSetUpdate) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(xssMatchTuple(), other.xssMatchTuple());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("XssMatchSetUpdate").add("Action", actionAsString()).add("XssMatchTuple", xssMatchTuple())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "XssMatchTuple":
            return Optional.ofNullable(clazz.cast(xssMatchTuple()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XssMatchSetUpdate, T> g) {
        return obj -> g.apply((XssMatchSetUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, XssMatchSetUpdate> {
        /**
         * <p>
         * Specify <code>INSERT</code> to add an <a>XssMatchSetUpdate</a> to an <a>XssMatchSet</a>. Use
         * <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.
         * </p>
         * 
         * @param action
         *        Specify <code>INSERT</code> to add an <a>XssMatchSetUpdate</a> to an <a>XssMatchSet</a>. Use
         *        <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specify <code>INSERT</code> to add an <a>XssMatchSetUpdate</a> to an <a>XssMatchSet</a>. Use
         * <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.
         * </p>
         * 
         * @param action
         *        Specify <code>INSERT</code> to add an <a>XssMatchSetUpdate</a> to an <a>XssMatchSet</a>. Use
         *        <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if
         * you want AWS WAF to inspect a header, the name of the header.
         * </p>
         * 
         * @param xssMatchTuple
         *        Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks
         *        and, if you want AWS WAF to inspect a header, the name of the header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xssMatchTuple(XssMatchTuple xssMatchTuple);

        /**
         * <p>
         * Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if
         * you want AWS WAF to inspect a header, the name of the header.
         * </p>
         * This is a convenience that creates an instance of the {@link XssMatchTuple.Builder} avoiding the need to
         * create one manually via {@link XssMatchTuple#builder()}.
         *
         * When the {@link Consumer} completes, {@link XssMatchTuple.Builder#build()} is called immediately and its
         * result is passed to {@link #xssMatchTuple(XssMatchTuple)}.
         * 
         * @param xssMatchTuple
         *        a consumer that will call methods on {@link XssMatchTuple.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xssMatchTuple(XssMatchTuple)
         */
        default Builder xssMatchTuple(Consumer<XssMatchTuple.Builder> xssMatchTuple) {
            return xssMatchTuple(XssMatchTuple.builder().applyMutation(xssMatchTuple).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private XssMatchTuple xssMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchSetUpdate model) {
            action(model.action);
            xssMatchTuple(model.xssMatchTuple);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        @Transient
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final XssMatchTuple.Builder getXssMatchTuple() {
            return xssMatchTuple != null ? xssMatchTuple.toBuilder() : null;
        }

        public final void setXssMatchTuple(XssMatchTuple.BuilderImpl xssMatchTuple) {
            this.xssMatchTuple = xssMatchTuple != null ? xssMatchTuple.build() : null;
        }

        @Override
        @Transient
        public final Builder xssMatchTuple(XssMatchTuple xssMatchTuple) {
            this.xssMatchTuple = xssMatchTuple;
            return this;
        }

        @Override
        public XssMatchSetUpdate build() {
            return new XssMatchSetUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
