/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.waf.DefaultWafBaseClientBuilder;
import software.amazon.awssdk.services.waf.DefaultWafClient;
import software.amazon.awssdk.services.waf.WafClient;
import software.amazon.awssdk.services.waf.WafClientBuilder;
import software.amazon.awssdk.services.waf.WafServiceClientConfiguration;
import software.amazon.awssdk.services.waf.endpoints.WafEndpointProvider;

@SdkInternalApi
final class DefaultWafClientBuilder
extends DefaultWafBaseClientBuilder<WafClientBuilder, WafClient>
implements WafClientBuilder {
    DefaultWafClientBuilder() {
    }

    @Override
    public DefaultWafClientBuilder endpointProvider(WafEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WafClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWafClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        WafServiceClientConfiguration serviceClientConfiguration = WafServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultWafClient(serviceClientConfiguration, clientConfiguration);
    }
}

