/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListActivatedRulesInRuleGroupRequest extends WafRequest implements
        ToCopyableBuilder<ListActivatedRulesInRuleGroupRequest.Builder, ListActivatedRulesInRuleGroupRequest> {
    private static final SdkField<String> RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupId").getter(getter(ListActivatedRulesInRuleGroupRequest::ruleGroupId))
            .setter(setter(Builder::ruleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupId").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListActivatedRulesInRuleGroupRequest::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListActivatedRulesInRuleGroupRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_ID_FIELD,
            NEXT_MARKER_FIELD, LIMIT_FIELD));

    private final String ruleGroupId;

    private final String nextMarker;

    private final Integer limit;

    private ListActivatedRulesInRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.ruleGroupId = builder.ruleGroupId;
        this.nextMarker = builder.nextMarker;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The <code>RuleGroupId</code> of the <a>RuleGroup</a> for which you want to get a list of <a>ActivatedRule</a>
     * objects.
     * </p>
     * 
     * @return The <code>RuleGroupId</code> of the <a>RuleGroup</a> for which you want to get a list of
     *         <a>ActivatedRule</a> objects.
     */
    public final String ruleGroupId() {
        return ruleGroupId;
    }

    /**
     * <p>
     * If you specify a value for <code>Limit</code> and you have more <code>ActivatedRules</code> than the value of
     * <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list
     * another group of <code>ActivatedRules</code>. For the second and subsequent
     * <code>ListActivatedRulesInRuleGroup</code> requests, specify the value of <code>NextMarker</code> from the
     * previous response to get information about another batch of <code>ActivatedRules</code>.
     * </p>
     * 
     * @return If you specify a value for <code>Limit</code> and you have more <code>ActivatedRules</code> than the
     *         value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows
     *         you to list another group of <code>ActivatedRules</code>. For the second and subsequent
     *         <code>ListActivatedRulesInRuleGroup</code> requests, specify the value of <code>NextMarker</code> from
     *         the previous response to get information about another batch of <code>ActivatedRules</code>.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * Specifies the number of <code>ActivatedRules</code> that you want AWS WAF to return for this request. If you have
     * more <code>ActivatedRules</code> than the number that you specify for <code>Limit</code>, the response includes a
     * <code>NextMarker</code> value that you can use to get another batch of <code>ActivatedRules</code>.
     * </p>
     * 
     * @return Specifies the number of <code>ActivatedRules</code> that you want AWS WAF to return for this request. If
     *         you have more <code>ActivatedRules</code> than the number that you specify for <code>Limit</code>, the
     *         response includes a <code>NextMarker</code> value that you can use to get another batch of
     *         <code>ActivatedRules</code>.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActivatedRulesInRuleGroupRequest)) {
            return false;
        }
        ListActivatedRulesInRuleGroupRequest other = (ListActivatedRulesInRuleGroupRequest) obj;
        return Objects.equals(ruleGroupId(), other.ruleGroupId()) && Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListActivatedRulesInRuleGroupRequest").add("RuleGroupId", ruleGroupId())
                .add("NextMarker", nextMarker()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupId":
            return Optional.ofNullable(clazz.cast(ruleGroupId()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListActivatedRulesInRuleGroupRequest, T> g) {
        return obj -> g.apply((ListActivatedRulesInRuleGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListActivatedRulesInRuleGroupRequest> {
        /**
         * <p>
         * The <code>RuleGroupId</code> of the <a>RuleGroup</a> for which you want to get a list of <a>ActivatedRule</a>
         * objects.
         * </p>
         * 
         * @param ruleGroupId
         *        The <code>RuleGroupId</code> of the <a>RuleGroup</a> for which you want to get a list of
         *        <a>ActivatedRule</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupId(String ruleGroupId);

        /**
         * <p>
         * If you specify a value for <code>Limit</code> and you have more <code>ActivatedRules</code> than the value of
         * <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list
         * another group of <code>ActivatedRules</code>. For the second and subsequent
         * <code>ListActivatedRulesInRuleGroup</code> requests, specify the value of <code>NextMarker</code> from the
         * previous response to get information about another batch of <code>ActivatedRules</code>.
         * </p>
         * 
         * @param nextMarker
         *        If you specify a value for <code>Limit</code> and you have more <code>ActivatedRules</code> than the
         *        value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that
         *        allows you to list another group of <code>ActivatedRules</code>. For the second and subsequent
         *        <code>ListActivatedRulesInRuleGroup</code> requests, specify the value of <code>NextMarker</code> from
         *        the previous response to get information about another batch of <code>ActivatedRules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * Specifies the number of <code>ActivatedRules</code> that you want AWS WAF to return for this request. If you
         * have more <code>ActivatedRules</code> than the number that you specify for <code>Limit</code>, the response
         * includes a <code>NextMarker</code> value that you can use to get another batch of <code>ActivatedRules</code>
         * .
         * </p>
         * 
         * @param limit
         *        Specifies the number of <code>ActivatedRules</code> that you want AWS WAF to return for this request.
         *        If you have more <code>ActivatedRules</code> than the number that you specify for <code>Limit</code>,
         *        the response includes a <code>NextMarker</code> value that you can use to get another batch of
         *        <code>ActivatedRules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String ruleGroupId;

        private String nextMarker;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActivatedRulesInRuleGroupRequest model) {
            super(model);
            ruleGroupId(model.ruleGroupId);
            nextMarker(model.nextMarker);
            limit(model.limit);
        }

        public final String getRuleGroupId() {
            return ruleGroupId;
        }

        public final void setRuleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
        }

        @Override
        public final Builder ruleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListActivatedRulesInRuleGroupRequest build() {
            return new ListActivatedRulesInRuleGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
