/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebACLUpdate implements SdkPojo, Serializable, ToCopyableBuilder<WebACLUpdate.Builder, WebACLUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(WebACLUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<ActivatedRule> ACTIVATED_RULE_FIELD = SdkField
            .<ActivatedRule> builder(MarshallingType.SDK_POJO).memberName("ActivatedRule")
            .getter(getter(WebACLUpdate::activatedRule)).setter(setter(Builder::activatedRule))
            .constructor(ActivatedRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivatedRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            ACTIVATED_RULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final ActivatedRule activatedRule;

    private WebACLUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.activatedRule = builder.activatedRule;
    }

    /**
     * <p>
     * Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a
     *         <code>WebACL</code>.
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a
     *         <code>WebACL</code>.
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The <code>ActivatedRule</code> object in an <a>UpdateWebACL</a> request specifies a <code>Rule</code> that you
     * want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that
     * you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>
     * , or <code>COUNT</code>).
     * </p>
     * 
     * @return The <code>ActivatedRule</code> object in an <a>UpdateWebACL</a> request specifies a <code>Rule</code>
     *         that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and
     *         the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (
     *         <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).
     */
    public final ActivatedRule activatedRule() {
        return activatedRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(activatedRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLUpdate)) {
            return false;
        }
        WebACLUpdate other = (WebACLUpdate) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(activatedRule(), other.activatedRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebACLUpdate").add("Action", actionAsString()).add("ActivatedRule", activatedRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "ActivatedRule":
            return Optional.ofNullable(clazz.cast(activatedRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebACLUpdate, T> g) {
        return obj -> g.apply((WebACLUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebACLUpdate> {
        /**
         * <p>
         * Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>
         * .
         * </p>
         * 
         * @param action
         *        Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a
         *        <code>WebACL</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>
         * .
         * </p>
         * 
         * @param action
         *        Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a
         *        <code>WebACL</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * The <code>ActivatedRule</code> object in an <a>UpdateWebACL</a> request specifies a <code>Rule</code> that
         * you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the
         * action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>,
         * <code>BLOCK</code>, or <code>COUNT</code>).
         * </p>
         * 
         * @param activatedRule
         *        The <code>ActivatedRule</code> object in an <a>UpdateWebACL</a> request specifies a <code>Rule</code>
         *        that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>,
         *        and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (
         *        <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activatedRule(ActivatedRule activatedRule);

        /**
         * <p>
         * The <code>ActivatedRule</code> object in an <a>UpdateWebACL</a> request specifies a <code>Rule</code> that
         * you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the
         * action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>,
         * <code>BLOCK</code>, or <code>COUNT</code>).
         * </p>
         * This is a convenience method that creates an instance of the {@link ActivatedRule.Builder} avoiding the need
         * to create one manually via {@link ActivatedRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivatedRule.Builder#build()} is called immediately and its
         * result is passed to {@link #activatedRule(ActivatedRule)}.
         * 
         * @param activatedRule
         *        a consumer that will call methods on {@link ActivatedRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activatedRule(ActivatedRule)
         */
        default Builder activatedRule(Consumer<ActivatedRule.Builder> activatedRule) {
            return activatedRule(ActivatedRule.builder().applyMutation(activatedRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private ActivatedRule activatedRule;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLUpdate model) {
            action(model.action);
            activatedRule(model.activatedRule);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final ActivatedRule.Builder getActivatedRule() {
            return activatedRule != null ? activatedRule.toBuilder() : null;
        }

        public final void setActivatedRule(ActivatedRule.BuilderImpl activatedRule) {
            this.activatedRule = activatedRule != null ? activatedRule.build() : null;
        }

        @Override
        public final Builder activatedRule(ActivatedRule activatedRule) {
            this.activatedRule = activatedRule;
            return this;
        }

        @Override
        public WebACLUpdate build() {
            return new WebACLUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
