/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Specifies the <a>ByteMatchSet</a>, <a>IPSet</a>, <a>SqlInjectionMatchSet</a>, <a>XssMatchSet</a>,
 * <a>RegexMatchSet</a>, <a>GeoMatchSet</a>, and <a>SizeConstraintSet</a> objects that you want to add to a
 * <code>Rule</code> and, for each object, indicates whether you want to negate the settings, for example, requests that
 * do NOT originate from the IP address 192.0.2.44.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Predicate implements SdkPojo, Serializable, ToCopyableBuilder<Predicate.Builder, Predicate> {
    private static final SdkField<Boolean> NEGATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Negated").getter(getter(Predicate::negated)).setter(setter(Builder::negated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negated").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Predicate::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DATA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DataId")
            .getter(getter(Predicate::dataId)).setter(setter(Builder::dataId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEGATED_FIELD, TYPE_FIELD,
            DATA_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean negated;

    private final String type;

    private final String dataId;

    private Predicate(BuilderImpl builder) {
        this.negated = builder.negated;
        this.type = builder.type;
        this.dataId = builder.dataId;
    }

    /**
     * <p>
     * Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests based on
     * the settings in the specified <a>ByteMatchSet</a>, <a>IPSet</a>, <a>SqlInjectionMatchSet</a>, <a>XssMatchSet</a>,
     * <a>RegexMatchSet</a>, <a>GeoMatchSet</a>, or <a>SizeConstraintSet</a>. For example, if an <code>IPSet</code>
     * includes the IP address <code>192.0.2.44</code>, AWS WAF will allow or block requests based on that IP address.
     * </p>
     * <p>
     * Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on the
     * negation of the settings in the <a>ByteMatchSet</a>, <a>IPSet</a>, <a>SqlInjectionMatchSet</a>,
     * <a>XssMatchSet</a>, <a>RegexMatchSet</a>, <a>GeoMatchSet</a>, or <a>SizeConstraintSet</a>. For example, if an
     * <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow, block, or count requests
     * based on all IP addresses <i>except</i> <code>192.0.2.44</code>.
     * </p>
     * 
     * @return Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests
     *         based on the settings in the specified <a>ByteMatchSet</a>, <a>IPSet</a>, <a>SqlInjectionMatchSet</a>,
     *         <a>XssMatchSet</a>, <a>RegexMatchSet</a>, <a>GeoMatchSet</a>, or <a>SizeConstraintSet</a>. For example,
     *         if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow or block
     *         requests based on that IP address.</p>
     *         <p>
     *         Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on
     *         the negation of the settings in the <a>ByteMatchSet</a>, <a>IPSet</a>, <a>SqlInjectionMatchSet</a>,
     *         <a>XssMatchSet</a>, <a>RegexMatchSet</a>, <a>GeoMatchSet</a>, or <a>SizeConstraintSet</a>. For example,
     *         if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow, block, or
     *         count requests based on all IP addresses <i>except</i> <code>192.0.2.44</code>.
     */
    public final Boolean negated() {
        return negated;
    }

    /**
     * <p>
     * The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PredicateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.
     * @see PredicateType
     */
    public final PredicateType type() {
        return PredicateType.fromValue(type);
    }

    /**
     * <p>
     * The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PredicateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.
     * @see PredicateType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A unique identifier for a predicate in a <code>Rule</code>, such as <code>ByteMatchSetId</code> or
     * <code>IPSetId</code>. The ID is returned by the corresponding <code>Create</code> or <code>List</code> command.
     * </p>
     * 
     * @return A unique identifier for a predicate in a <code>Rule</code>, such as <code>ByteMatchSetId</code> or
     *         <code>IPSetId</code>. The ID is returned by the corresponding <code>Create</code> or <code>List</code>
     *         command.
     */
    public final String dataId() {
        return dataId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(negated());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate) obj;
        return Objects.equals(negated(), other.negated()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(dataId(), other.dataId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Predicate").add("Negated", negated()).add("Type", typeAsString()).add("DataId", dataId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Negated":
            return Optional.ofNullable(clazz.cast(negated()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DataId":
            return Optional.ofNullable(clazz.cast(dataId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Predicate, T> g) {
        return obj -> g.apply((Predicate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Predicate> {
        /**
         * <p>
         * Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests based
         * on the settings in the specified <a>ByteMatchSet</a>, <a>IPSet</a>, <a>SqlInjectionMatchSet</a>,
         * <a>XssMatchSet</a>, <a>RegexMatchSet</a>, <a>GeoMatchSet</a>, or <a>SizeConstraintSet</a>. For example, if an
         * <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow or block requests
         * based on that IP address.
         * </p>
         * <p>
         * Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on the
         * negation of the settings in the <a>ByteMatchSet</a>, <a>IPSet</a>, <a>SqlInjectionMatchSet</a>,
         * <a>XssMatchSet</a>, <a>RegexMatchSet</a>, <a>GeoMatchSet</a>, or <a>SizeConstraintSet</a>. For example, if an
         * <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow, block, or count
         * requests based on all IP addresses <i>except</i> <code>192.0.2.44</code>.
         * </p>
         * 
         * @param negated
         *        Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests
         *        based on the settings in the specified <a>ByteMatchSet</a>, <a>IPSet</a>, <a>SqlInjectionMatchSet</a>,
         *        <a>XssMatchSet</a>, <a>RegexMatchSet</a>, <a>GeoMatchSet</a>, or <a>SizeConstraintSet</a>. For
         *        example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow
         *        or block requests based on that IP address.</p>
         *        <p>
         *        Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on
         *        the negation of the settings in the <a>ByteMatchSet</a>, <a>IPSet</a>, <a>SqlInjectionMatchSet</a>,
         *        <a>XssMatchSet</a>, <a>RegexMatchSet</a>, <a>GeoMatchSet</a>, or <a>SizeConstraintSet</a>. For
         *        example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow,
         *        block, or count requests based on all IP addresses <i>except</i> <code>192.0.2.44</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negated(Boolean negated);

        /**
         * <p>
         * The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.
         * </p>
         * 
         * @param type
         *        The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.
         * @see PredicateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PredicateType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.
         * </p>
         * 
         * @param type
         *        The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.
         * @see PredicateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PredicateType
         */
        Builder type(PredicateType type);

        /**
         * <p>
         * A unique identifier for a predicate in a <code>Rule</code>, such as <code>ByteMatchSetId</code> or
         * <code>IPSetId</code>. The ID is returned by the corresponding <code>Create</code> or <code>List</code>
         * command.
         * </p>
         * 
         * @param dataId
         *        A unique identifier for a predicate in a <code>Rule</code>, such as <code>ByteMatchSetId</code> or
         *        <code>IPSetId</code>. The ID is returned by the corresponding <code>Create</code> or <code>List</code>
         *        command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataId(String dataId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean negated;

        private String type;

        private String dataId;

        private BuilderImpl() {
        }

        private BuilderImpl(Predicate model) {
            negated(model.negated);
            type(model.type);
            dataId(model.dataId);
        }

        public final Boolean getNegated() {
            return negated;
        }

        public final void setNegated(Boolean negated) {
            this.negated = negated;
        }

        @Override
        public final Builder negated(Boolean negated) {
            this.negated = negated;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PredicateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDataId() {
            return dataId;
        }

        public final void setDataId(String dataId) {
            this.dataId = dataId;
        }

        @Override
        public final Builder dataId(String dataId) {
            this.dataId = dataId;
            return this;
        }

        @Override
        public Predicate build() {
            return new Predicate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
