/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateByteMatchSetResponse extends WafResponse implements
        ToCopyableBuilder<CreateByteMatchSetResponse.Builder, CreateByteMatchSetResponse> {
    private static final SdkField<ByteMatchSet> BYTE_MATCH_SET_FIELD = SdkField.<ByteMatchSet> builder(MarshallingType.SDK_POJO)
            .memberName("ByteMatchSet").getter(getter(CreateByteMatchSetResponse::byteMatchSet))
            .setter(setter(Builder::byteMatchSet)).constructor(ByteMatchSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchSet").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(CreateByteMatchSetResponse::changeToken))
            .setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_MATCH_SET_FIELD,
            CHANGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ByteMatchSet byteMatchSet;

    private final String changeToken;

    private CreateByteMatchSetResponse(BuilderImpl builder) {
        super(builder);
        this.byteMatchSet = builder.byteMatchSet;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * A <a>ByteMatchSet</a> that contains no <code>ByteMatchTuple</code> objects.
     * </p>
     * 
     * @return A <a>ByteMatchSet</a> that contains no <code>ByteMatchTuple</code> objects.
     */
    public final ByteMatchSet byteMatchSet() {
        return byteMatchSet;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateByteMatchSet</code> request. You can also
     * use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateByteMatchSet</code> request. You can
     *         also use this value to query the status of the request. For more information, see
     *         <a>GetChangeTokenStatus</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byteMatchSet());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateByteMatchSetResponse)) {
            return false;
        }
        CreateByteMatchSetResponse other = (CreateByteMatchSetResponse) obj;
        return Objects.equals(byteMatchSet(), other.byteMatchSet()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateByteMatchSetResponse").add("ByteMatchSet", byteMatchSet())
                .add("ChangeToken", changeToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByteMatchSet":
            return Optional.ofNullable(clazz.cast(byteMatchSet()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ByteMatchSet", BYTE_MATCH_SET_FIELD);
        map.put("ChangeToken", CHANGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateByteMatchSetResponse, T> g) {
        return obj -> g.apply((CreateByteMatchSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateByteMatchSetResponse> {
        /**
         * <p>
         * A <a>ByteMatchSet</a> that contains no <code>ByteMatchTuple</code> objects.
         * </p>
         * 
         * @param byteMatchSet
         *        A <a>ByteMatchSet</a> that contains no <code>ByteMatchTuple</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchSet(ByteMatchSet byteMatchSet);

        /**
         * <p>
         * A <a>ByteMatchSet</a> that contains no <code>ByteMatchTuple</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link ByteMatchSet.Builder} avoiding the need
         * to create one manually via {@link ByteMatchSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ByteMatchSet.Builder#build()} is called immediately and its
         * result is passed to {@link #byteMatchSet(ByteMatchSet)}.
         * 
         * @param byteMatchSet
         *        a consumer that will call methods on {@link ByteMatchSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byteMatchSet(ByteMatchSet)
         */
        default Builder byteMatchSet(Consumer<ByteMatchSet.Builder> byteMatchSet) {
            return byteMatchSet(ByteMatchSet.builder().applyMutation(byteMatchSet).build());
        }

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateByteMatchSet</code> request. You can
         * also use this value to query the status of the request. For more information, see
         * <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateByteMatchSet</code> request. You
         *        can also use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private ByteMatchSet byteMatchSet;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateByteMatchSetResponse model) {
            super(model);
            byteMatchSet(model.byteMatchSet);
            changeToken(model.changeToken);
        }

        public final ByteMatchSet.Builder getByteMatchSet() {
            return byteMatchSet != null ? byteMatchSet.toBuilder() : null;
        }

        public final void setByteMatchSet(ByteMatchSet.BuilderImpl byteMatchSet) {
            this.byteMatchSet = byteMatchSet != null ? byteMatchSet.build() : null;
        }

        @Override
        public final Builder byteMatchSet(ByteMatchSet byteMatchSet) {
            this.byteMatchSet = byteMatchSet;
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        @Override
        public CreateByteMatchSetResponse build() {
            return new CreateByteMatchSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
