/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a <code>CreateSqlInjectionMatchSet</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSqlInjectionMatchSetResponse extends WafResponse implements
        ToCopyableBuilder<CreateSqlInjectionMatchSetResponse.Builder, CreateSqlInjectionMatchSetResponse> {
    private static final SdkField<SqlInjectionMatchSet> SQL_INJECTION_MATCH_SET_FIELD = SdkField
            .<SqlInjectionMatchSet> builder(MarshallingType.SDK_POJO).memberName("SqlInjectionMatchSet")
            .getter(getter(CreateSqlInjectionMatchSetResponse::sqlInjectionMatchSet))
            .setter(setter(Builder::sqlInjectionMatchSet)).constructor(SqlInjectionMatchSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchSet").build())
            .build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(CreateSqlInjectionMatchSetResponse::changeToken))
            .setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_INJECTION_MATCH_SET_FIELD,
            CHANGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SqlInjectionMatchSet sqlInjectionMatchSet;

    private final String changeToken;

    private CreateSqlInjectionMatchSetResponse(BuilderImpl builder) {
        super(builder);
        this.sqlInjectionMatchSet = builder.sqlInjectionMatchSet;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * A <a>SqlInjectionMatchSet</a>.
     * </p>
     * 
     * @return A <a>SqlInjectionMatchSet</a>.
     */
    public final SqlInjectionMatchSet sqlInjectionMatchSet() {
        return sqlInjectionMatchSet;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateSqlInjectionMatchSet</code> request. You can
     * also use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateSqlInjectionMatchSet</code> request.
     *         You can also use this value to query the status of the request. For more information, see
     *         <a>GetChangeTokenStatus</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sqlInjectionMatchSet());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSqlInjectionMatchSetResponse)) {
            return false;
        }
        CreateSqlInjectionMatchSetResponse other = (CreateSqlInjectionMatchSetResponse) obj;
        return Objects.equals(sqlInjectionMatchSet(), other.sqlInjectionMatchSet())
                && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSqlInjectionMatchSetResponse").add("SqlInjectionMatchSet", sqlInjectionMatchSet())
                .add("ChangeToken", changeToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SqlInjectionMatchSet":
            return Optional.ofNullable(clazz.cast(sqlInjectionMatchSet()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SqlInjectionMatchSet", SQL_INJECTION_MATCH_SET_FIELD);
        map.put("ChangeToken", CHANGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSqlInjectionMatchSetResponse, T> g) {
        return obj -> g.apply((CreateSqlInjectionMatchSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSqlInjectionMatchSetResponse> {
        /**
         * <p>
         * A <a>SqlInjectionMatchSet</a>.
         * </p>
         * 
         * @param sqlInjectionMatchSet
         *        A <a>SqlInjectionMatchSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlInjectionMatchSet(SqlInjectionMatchSet sqlInjectionMatchSet);

        /**
         * <p>
         * A <a>SqlInjectionMatchSet</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqlInjectionMatchSet.Builder} avoiding
         * the need to create one manually via {@link SqlInjectionMatchSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqlInjectionMatchSet.Builder#build()} is called immediately and
         * its result is passed to {@link #sqlInjectionMatchSet(SqlInjectionMatchSet)}.
         * 
         * @param sqlInjectionMatchSet
         *        a consumer that will call methods on {@link SqlInjectionMatchSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlInjectionMatchSet(SqlInjectionMatchSet)
         */
        default Builder sqlInjectionMatchSet(Consumer<SqlInjectionMatchSet.Builder> sqlInjectionMatchSet) {
            return sqlInjectionMatchSet(SqlInjectionMatchSet.builder().applyMutation(sqlInjectionMatchSet).build());
        }

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateSqlInjectionMatchSet</code> request. You
         * can also use this value to query the status of the request. For more information, see
         * <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateSqlInjectionMatchSet</code>
         *        request. You can also use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private SqlInjectionMatchSet sqlInjectionMatchSet;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSqlInjectionMatchSetResponse model) {
            super(model);
            sqlInjectionMatchSet(model.sqlInjectionMatchSet);
            changeToken(model.changeToken);
        }

        public final SqlInjectionMatchSet.Builder getSqlInjectionMatchSet() {
            return sqlInjectionMatchSet != null ? sqlInjectionMatchSet.toBuilder() : null;
        }

        public final void setSqlInjectionMatchSet(SqlInjectionMatchSet.BuilderImpl sqlInjectionMatchSet) {
            this.sqlInjectionMatchSet = sqlInjectionMatchSet != null ? sqlInjectionMatchSet.build() : null;
        }

        @Override
        public final Builder sqlInjectionMatchSet(SqlInjectionMatchSet sqlInjectionMatchSet) {
            this.sqlInjectionMatchSet = sqlInjectionMatchSet;
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        @Override
        public CreateSqlInjectionMatchSetResponse build() {
            return new CreateSqlInjectionMatchSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
