/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWebAclForResourceResponse extends WafResponse implements
        ToCopyableBuilder<GetWebAclForResourceResponse.Builder, GetWebAclForResourceResponse> {
    private static final SdkField<WebACLSummary> WEB_ACL_SUMMARY_FIELD = SdkField
            .<WebACLSummary> builder(MarshallingType.SDK_POJO).memberName("WebACLSummary")
            .getter(getter(GetWebAclForResourceResponse::webACLSummary)).setter(setter(Builder::webACLSummary))
            .constructor(WebACLSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WebACLSummary webACLSummary;

    private GetWebAclForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.webACLSummary = builder.webACLSummary;
    }

    /**
     * <p>
     * Information about the web ACL that you specified in the <code>GetWebACLForResource</code> request. If there is no
     * associated resource, a null WebACLSummary is returned.
     * </p>
     * 
     * @return Information about the web ACL that you specified in the <code>GetWebACLForResource</code> request. If
     *         there is no associated resource, a null WebACLSummary is returned.
     */
    public final WebACLSummary webACLSummary() {
        return webACLSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACLSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebAclForResourceResponse)) {
            return false;
        }
        GetWebAclForResourceResponse other = (GetWebAclForResourceResponse) obj;
        return Objects.equals(webACLSummary(), other.webACLSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWebAclForResourceResponse").add("WebACLSummary", webACLSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACLSummary":
            return Optional.ofNullable(clazz.cast(webACLSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebACLSummary", WEB_ACL_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWebAclForResourceResponse, T> g) {
        return obj -> g.apply((GetWebAclForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWebAclForResourceResponse> {
        /**
         * <p>
         * Information about the web ACL that you specified in the <code>GetWebACLForResource</code> request. If there
         * is no associated resource, a null WebACLSummary is returned.
         * </p>
         * 
         * @param webACLSummary
         *        Information about the web ACL that you specified in the <code>GetWebACLForResource</code> request. If
         *        there is no associated resource, a null WebACLSummary is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLSummary(WebACLSummary webACLSummary);

        /**
         * <p>
         * Information about the web ACL that you specified in the <code>GetWebACLForResource</code> request. If there
         * is no associated resource, a null WebACLSummary is returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebACLSummary.Builder} avoiding the need
         * to create one manually via {@link WebACLSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebACLSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #webACLSummary(WebACLSummary)}.
         * 
         * @param webACLSummary
         *        a consumer that will call methods on {@link WebACLSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webACLSummary(WebACLSummary)
         */
        default Builder webACLSummary(Consumer<WebACLSummary.Builder> webACLSummary) {
            return webACLSummary(WebACLSummary.builder().applyMutation(webACLSummary).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private WebACLSummary webACLSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebAclForResourceResponse model) {
            super(model);
            webACLSummary(model.webACLSummary);
        }

        public final WebACLSummary.Builder getWebACLSummary() {
            return webACLSummary != null ? webACLSummary.toBuilder() : null;
        }

        public final void setWebACLSummary(WebACLSummary.BuilderImpl webACLSummary) {
            this.webACLSummary = webACLSummary != null ? webACLSummary.build() : null;
        }

        @Override
        public final Builder webACLSummary(WebACLSummary webACLSummary) {
            this.webACLSummary = webACLSummary;
            return this;
        }

        @Override
        public GetWebAclForResourceResponse build() {
            return new GetWebAclForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
