/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWebAcLsResponse extends WafResponse implements
        ToCopyableBuilder<ListWebAcLsResponse.Builder, ListWebAcLsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListWebAcLsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<WebACLSummary>> WEB_AC_LS_FIELD = SdkField
            .<List<WebACLSummary>> builder(MarshallingType.LIST)
            .memberName("WebACLs")
            .getter(getter(ListWebAcLsResponse::webACLs))
            .setter(setter(Builder::webACLs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WebACLSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WebACLSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            WEB_AC_LS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextMarker;

    private final List<WebACLSummary> webACLs;

    private ListWebAcLsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.webACLs = builder.webACLs;
    }

    /**
     * <p>
     * If you have more <code>WebACL</code> objects than the number that you specified for <code>Limit</code> in the
     * request, the response includes a <code>NextMarker</code> value. To list more <code>WebACL</code> objects, submit
     * another <code>ListWebACLs</code> request, and specify the <code>NextMarker</code> value from the response in the
     * <code>NextMarker</code> value in the next request.
     * </p>
     * 
     * @return If you have more <code>WebACL</code> objects than the number that you specified for <code>Limit</code> in
     *         the request, the response includes a <code>NextMarker</code> value. To list more <code>WebACL</code>
     *         objects, submit another <code>ListWebACLs</code> request, and specify the <code>NextMarker</code> value
     *         from the response in the <code>NextMarker</code> value in the next request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the WebACLs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWebACLs() {
        return webACLs != null && !(webACLs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>WebACLSummary</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWebACLs} method.
     * </p>
     * 
     * @return An array of <a>WebACLSummary</a> objects.
     */
    public final List<WebACLSummary> webACLs() {
        return webACLs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasWebACLs() ? webACLs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebAcLsResponse)) {
            return false;
        }
        ListWebAcLsResponse other = (ListWebAcLsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasWebACLs() == other.hasWebACLs()
                && Objects.equals(webACLs(), other.webACLs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWebAcLsResponse").add("NextMarker", nextMarker())
                .add("WebACLs", hasWebACLs() ? webACLs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "WebACLs":
            return Optional.ofNullable(clazz.cast(webACLs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("WebACLs", WEB_AC_LS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWebAcLsResponse, T> g) {
        return obj -> g.apply((ListWebAcLsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWebAcLsResponse> {
        /**
         * <p>
         * If you have more <code>WebACL</code> objects than the number that you specified for <code>Limit</code> in the
         * request, the response includes a <code>NextMarker</code> value. To list more <code>WebACL</code> objects,
         * submit another <code>ListWebACLs</code> request, and specify the <code>NextMarker</code> value from the
         * response in the <code>NextMarker</code> value in the next request.
         * </p>
         * 
         * @param nextMarker
         *        If you have more <code>WebACL</code> objects than the number that you specified for <code>Limit</code>
         *        in the request, the response includes a <code>NextMarker</code> value. To list more
         *        <code>WebACL</code> objects, submit another <code>ListWebACLs</code> request, and specify the
         *        <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of <a>WebACLSummary</a> objects.
         * </p>
         * 
         * @param webACLs
         *        An array of <a>WebACLSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLs(Collection<WebACLSummary> webACLs);

        /**
         * <p>
         * An array of <a>WebACLSummary</a> objects.
         * </p>
         * 
         * @param webACLs
         *        An array of <a>WebACLSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLs(WebACLSummary... webACLs);

        /**
         * <p>
         * An array of <a>WebACLSummary</a> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.waf.model.WebACLSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.waf.model.WebACLSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.waf.model.WebACLSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #webACLs(List<WebACLSummary>)}.
         * 
         * @param webACLs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.waf.model.WebACLSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webACLs(java.util.Collection<WebACLSummary>)
         */
        Builder webACLs(Consumer<WebACLSummary.Builder>... webACLs);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<WebACLSummary> webACLs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebAcLsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            webACLs(model.webACLs);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<WebACLSummary.Builder> getWebACLs() {
            List<WebACLSummary.Builder> result = WebACLSummariesCopier.copyToBuilder(this.webACLs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebACLs(Collection<WebACLSummary.BuilderImpl> webACLs) {
            this.webACLs = WebACLSummariesCopier.copyFromBuilder(webACLs);
        }

        @Override
        public final Builder webACLs(Collection<WebACLSummary> webACLs) {
            this.webACLs = WebACLSummariesCopier.copy(webACLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webACLs(WebACLSummary... webACLs) {
            webACLs(Arrays.asList(webACLs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webACLs(Consumer<WebACLSummary.Builder>... webACLs) {
            webACLs(Stream.of(webACLs).map(c -> WebACLSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWebAcLsResponse build() {
            return new ListWebAcLsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
