/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWebAclMigrationStackRequest extends WafRequest implements
        ToCopyableBuilder<CreateWebAclMigrationStackRequest.Builder, CreateWebAclMigrationStackRequest> {
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLId").getter(getter(CreateWebAclMigrationStackRequest::webACLId)).setter(setter(Builder::webACLId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(CreateWebAclMigrationStackRequest::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<Boolean> IGNORE_UNSUPPORTED_TYPE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IgnoreUnsupportedType").getter(getter(CreateWebAclMigrationStackRequest::ignoreUnsupportedType))
            .setter(setter(Builder::ignoreUnsupportedType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreUnsupportedType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ID_FIELD,
            S3_BUCKET_NAME_FIELD, IGNORE_UNSUPPORTED_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String webACLId;

    private final String s3BucketName;

    private final Boolean ignoreUnsupportedType;

    private CreateWebAclMigrationStackRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.s3BucketName = builder.s3BucketName;
        this.ignoreUnsupportedType = builder.ignoreUnsupportedType;
    }

    /**
     * <p>
     * The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.
     * </p>
     * 
     * @return The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.
     */
    public final String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket to store the CloudFormation template in. The S3 bucket must be configured as
     * follows for the migration:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The bucket name must start with <code>aws-waf-migration-</code>. For example,
     * <code>aws-waf-migration-my-web-acl</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The bucket must be in the Region where you are deploying the template. For example, for a web ACL in us-west-2,
     * you must use an Amazon S3 bucket in us-west-2 and you must deploy the template stack to us-west-2.
     * </p>
     * </li>
     * <li>
     * <p>
     * The bucket policies must permit the migration process to write data. For listings of the bucket policies, see the
     * Examples section.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the Amazon S3 bucket to store the CloudFormation template in. The S3 bucket must be
     *         configured as follows for the migration: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The bucket name must start with <code>aws-waf-migration-</code>. For example,
     *         <code>aws-waf-migration-my-web-acl</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The bucket must be in the Region where you are deploying the template. For example, for a web ACL in
     *         us-west-2, you must use an Amazon S3 bucket in us-west-2 and you must deploy the template stack to
     *         us-west-2.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The bucket policies must permit the migration process to write data. For listings of the bucket policies,
     *         see the Examples section.
     *         </p>
     *         </li>
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * Indicates whether to exclude entities that can't be migrated or to stop the migration. Set this to true to ignore
     * unsupported entities in the web ACL during the migration. Otherwise, if AWS WAF encounters unsupported entities,
     * it stops the process and throws an exception.
     * </p>
     * 
     * @return Indicates whether to exclude entities that can't be migrated or to stop the migration. Set this to true
     *         to ignore unsupported entities in the web ACL during the migration. Otherwise, if AWS WAF encounters
     *         unsupported entities, it stops the process and throws an exception.
     */
    public final Boolean ignoreUnsupportedType() {
        return ignoreUnsupportedType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreUnsupportedType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebAclMigrationStackRequest)) {
            return false;
        }
        CreateWebAclMigrationStackRequest other = (CreateWebAclMigrationStackRequest) obj;
        return Objects.equals(webACLId(), other.webACLId()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(ignoreUnsupportedType(), other.ignoreUnsupportedType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWebAclMigrationStackRequest").add("WebACLId", webACLId())
                .add("S3BucketName", s3BucketName()).add("IgnoreUnsupportedType", ignoreUnsupportedType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACLId":
            return Optional.ofNullable(clazz.cast(webACLId()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "IgnoreUnsupportedType":
            return Optional.ofNullable(clazz.cast(ignoreUnsupportedType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebACLId", WEB_ACL_ID_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("IgnoreUnsupportedType", IGNORE_UNSUPPORTED_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWebAclMigrationStackRequest, T> g) {
        return obj -> g.apply((CreateWebAclMigrationStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWebAclMigrationStackRequest> {
        /**
         * <p>
         * The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.
         * </p>
         * 
         * @param webACLId
         *        The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * The name of the Amazon S3 bucket to store the CloudFormation template in. The S3 bucket must be configured as
         * follows for the migration:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The bucket name must start with <code>aws-waf-migration-</code>. For example,
         * <code>aws-waf-migration-my-web-acl</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The bucket must be in the Region where you are deploying the template. For example, for a web ACL in
         * us-west-2, you must use an Amazon S3 bucket in us-west-2 and you must deploy the template stack to us-west-2.
         * </p>
         * </li>
         * <li>
         * <p>
         * The bucket policies must permit the migration process to write data. For listings of the bucket policies, see
         * the Examples section.
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3BucketName
         *        The name of the Amazon S3 bucket to store the CloudFormation template in. The S3 bucket must be
         *        configured as follows for the migration: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The bucket name must start with <code>aws-waf-migration-</code>. For example,
         *        <code>aws-waf-migration-my-web-acl</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The bucket must be in the Region where you are deploying the template. For example, for a web ACL in
         *        us-west-2, you must use an Amazon S3 bucket in us-west-2 and you must deploy the template stack to
         *        us-west-2.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The bucket policies must permit the migration process to write data. For listings of the bucket
         *        policies, see the Examples section.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * Indicates whether to exclude entities that can't be migrated or to stop the migration. Set this to true to
         * ignore unsupported entities in the web ACL during the migration. Otherwise, if AWS WAF encounters unsupported
         * entities, it stops the process and throws an exception.
         * </p>
         * 
         * @param ignoreUnsupportedType
         *        Indicates whether to exclude entities that can't be migrated or to stop the migration. Set this to
         *        true to ignore unsupported entities in the web ACL during the migration. Otherwise, if AWS WAF
         *        encounters unsupported entities, it stops the process and throws an exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreUnsupportedType(Boolean ignoreUnsupportedType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String webACLId;

        private String s3BucketName;

        private Boolean ignoreUnsupportedType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebAclMigrationStackRequest model) {
            super(model);
            webACLId(model.webACLId);
            s3BucketName(model.s3BucketName);
            ignoreUnsupportedType(model.ignoreUnsupportedType);
        }

        public final String getWebACLId() {
            return webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final Boolean getIgnoreUnsupportedType() {
            return ignoreUnsupportedType;
        }

        public final void setIgnoreUnsupportedType(Boolean ignoreUnsupportedType) {
            this.ignoreUnsupportedType = ignoreUnsupportedType;
        }

        @Override
        public final Builder ignoreUnsupportedType(Boolean ignoreUnsupportedType) {
            this.ignoreUnsupportedType = ignoreUnsupportedType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWebAclMigrationStackRequest build() {
            return new CreateWebAclMigrationStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
