/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChangeTokenStatusResponse extends WafResponse implements
        ToCopyableBuilder<GetChangeTokenStatusResponse.Builder, GetChangeTokenStatusResponse> {
    private static final SdkField<String> CHANGE_TOKEN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeTokenStatus").getter(getter(GetChangeTokenStatusResponse::changeTokenStatusAsString))
            .setter(setter(Builder::changeTokenStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeTokenStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_TOKEN_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String changeTokenStatus;

    private GetChangeTokenStatusResponse(BuilderImpl builder) {
        super(builder);
        this.changeTokenStatus = builder.changeTokenStatus;
    }

    /**
     * <p>
     * The status of the change token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeTokenStatus}
     * will return {@link ChangeTokenStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #changeTokenStatusAsString}.
     * </p>
     * 
     * @return The status of the change token.
     * @see ChangeTokenStatus
     */
    public final ChangeTokenStatus changeTokenStatus() {
        return ChangeTokenStatus.fromValue(changeTokenStatus);
    }

    /**
     * <p>
     * The status of the change token.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeTokenStatus}
     * will return {@link ChangeTokenStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #changeTokenStatusAsString}.
     * </p>
     * 
     * @return The status of the change token.
     * @see ChangeTokenStatus
     */
    public final String changeTokenStatusAsString() {
        return changeTokenStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changeTokenStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChangeTokenStatusResponse)) {
            return false;
        }
        GetChangeTokenStatusResponse other = (GetChangeTokenStatusResponse) obj;
        return Objects.equals(changeTokenStatusAsString(), other.changeTokenStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChangeTokenStatusResponse").add("ChangeTokenStatus", changeTokenStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeTokenStatus":
            return Optional.ofNullable(clazz.cast(changeTokenStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChangeTokenStatus", CHANGE_TOKEN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetChangeTokenStatusResponse, T> g) {
        return obj -> g.apply((GetChangeTokenStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetChangeTokenStatusResponse> {
        /**
         * <p>
         * The status of the change token.
         * </p>
         * 
         * @param changeTokenStatus
         *        The status of the change token.
         * @see ChangeTokenStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeTokenStatus
         */
        Builder changeTokenStatus(String changeTokenStatus);

        /**
         * <p>
         * The status of the change token.
         * </p>
         * 
         * @param changeTokenStatus
         *        The status of the change token.
         * @see ChangeTokenStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeTokenStatus
         */
        Builder changeTokenStatus(ChangeTokenStatus changeTokenStatus);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String changeTokenStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChangeTokenStatusResponse model) {
            super(model);
            changeTokenStatus(model.changeTokenStatus);
        }

        public final String getChangeTokenStatus() {
            return changeTokenStatus;
        }

        public final void setChangeTokenStatus(String changeTokenStatus) {
            this.changeTokenStatus = changeTokenStatus;
        }

        @Override
        public final Builder changeTokenStatus(String changeTokenStatus) {
            this.changeTokenStatus = changeTokenStatus;
            return this;
        }

        @Override
        public final Builder changeTokenStatus(ChangeTokenStatus changeTokenStatus) {
            this.changeTokenStatus(changeTokenStatus == null ? null : changeTokenStatus.toString());
            return this;
        }

        @Override
        public GetChangeTokenStatusResponse build() {
            return new GetChangeTokenStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
