/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForResourceResponse extends WafResponse implements
        ToCopyableBuilder<ListTagsForResourceResponse.Builder, ListTagsForResourceResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListTagsForResourceResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<TagInfoForResource> TAG_INFO_FOR_RESOURCE_FIELD = SdkField
            .<TagInfoForResource> builder(MarshallingType.SDK_POJO).memberName("TagInfoForResource")
            .getter(getter(ListTagsForResourceResponse::tagInfoForResource)).setter(setter(Builder::tagInfoForResource))
            .constructor(TagInfoForResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagInfoForResource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            TAG_INFO_FOR_RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextMarker;

    private final TagInfoForResource tagInfoForResource;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.tagInfoForResource = builder.tagInfoForResource;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final TagInfoForResource tagInfoForResource() {
        return tagInfoForResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(tagInfoForResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(tagInfoForResource(), other.tagInfoForResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForResourceResponse").add("NextMarker", nextMarker())
                .add("TagInfoForResource", tagInfoForResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "TagInfoForResource":
            return Optional.ofNullable(clazz.cast(tagInfoForResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("TagInfoForResource", TAG_INFO_FOR_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceResponse, T> g) {
        return obj -> g.apply((ListTagsForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForResourceResponse> {
        /**
         * <p/>
         * 
         * @param nextMarker
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p/>
         * 
         * @param tagInfoForResource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagInfoForResource(TagInfoForResource tagInfoForResource);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link TagInfoForResource.Builder} avoiding the
         * need to create one manually via {@link TagInfoForResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagInfoForResource.Builder#build()} is called immediately and its
         * result is passed to {@link #tagInfoForResource(TagInfoForResource)}.
         * 
         * @param tagInfoForResource
         *        a consumer that will call methods on {@link TagInfoForResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagInfoForResource(TagInfoForResource)
         */
        default Builder tagInfoForResource(Consumer<TagInfoForResource.Builder> tagInfoForResource) {
            return tagInfoForResource(TagInfoForResource.builder().applyMutation(tagInfoForResource).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private TagInfoForResource tagInfoForResource;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            tagInfoForResource(model.tagInfoForResource);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final TagInfoForResource.Builder getTagInfoForResource() {
            return tagInfoForResource != null ? tagInfoForResource.toBuilder() : null;
        }

        public final void setTagInfoForResource(TagInfoForResource.BuilderImpl tagInfoForResource) {
            this.tagInfoForResource = tagInfoForResource != null ? tagInfoForResource.build() : null;
        }

        @Override
        public final Builder tagInfoForResource(TagInfoForResource tagInfoForResource) {
            this.tagInfoForResource = tagInfoForResource;
            return this;
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
