/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * In a <a>GetRegexMatchSet</a> request, <code>RegexMatchSet</code> is a complex type that contains the
 * <code>RegexMatchSetId</code> and <code>Name</code> of a <code>RegexMatchSet</code>, and the values that you specified
 * when you updated the <code>RegexMatchSet</code>.
 * </p>
 * <p>
 * The values are contained in a <code>RegexMatchTuple</code> object, which specify the parts of web requests that you
 * want AWS WAF to inspect and the values that you want AWS WAF to search for. If a <code>RegexMatchSet</code> contains
 * more than one <code>RegexMatchTuple</code> object, a request needs to match the settings in only one
 * <code>ByteMatchTuple</code> to be considered a match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegexMatchSet implements SdkPojo, Serializable, ToCopyableBuilder<RegexMatchSet.Builder, RegexMatchSet> {
    private static final SdkField<String> REGEX_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegexMatchSetId").getter(getter(RegexMatchSet::regexMatchSetId))
            .setter(setter(Builder::regexMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RegexMatchSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<RegexMatchTuple>> REGEX_MATCH_TUPLES_FIELD = SdkField
            .<List<RegexMatchTuple>> builder(MarshallingType.LIST)
            .memberName("RegexMatchTuples")
            .getter(getter(RegexMatchSet::regexMatchTuples))
            .setter(setter(Builder::regexMatchTuples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchTuples").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegexMatchTuple> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegexMatchTuple::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_MATCH_SET_ID_FIELD,
            NAME_FIELD, REGEX_MATCH_TUPLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String regexMatchSetId;

    private final String name;

    private final List<RegexMatchTuple> regexMatchTuples;

    private RegexMatchSet(BuilderImpl builder) {
        this.regexMatchSetId = builder.regexMatchSetId;
        this.name = builder.name;
        this.regexMatchTuples = builder.regexMatchTuples;
    }

    /**
     * <p>
     * The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get
     * information about a <code>RegexMatchSet</code> (see <a>GetRegexMatchSet</a>), update a <code>RegexMatchSet</code>
     * (see <a>UpdateRegexMatchSet</a>), insert a <code>RegexMatchSet</code> into a <code>Rule</code> or delete one from
     * a <code>Rule</code> (see <a>UpdateRule</a>), and delete a <code>RegexMatchSet</code> from AWS WAF (see
     * <a>DeleteRegexMatchSet</a>).
     * </p>
     * <p>
     * <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
     * </p>
     * 
     * @return The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code>
     *         to get information about a <code>RegexMatchSet</code> (see <a>GetRegexMatchSet</a>), update a
     *         <code>RegexMatchSet</code> (see <a>UpdateRegexMatchSet</a>), insert a <code>RegexMatchSet</code> into a
     *         <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
     *         <code>RegexMatchSet</code> from AWS WAF (see <a>DeleteRegexMatchSet</a>).</p>
     *         <p>
     *         <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
     */
    public final String regexMatchSetId() {
        return regexMatchSetId;
    }

    /**
     * <p>
     * A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after you create a
     * <code>RegexMatchSet</code>.
     * </p>
     * 
     * @return A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after you
     *         create a <code>RegexMatchSet</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegexMatchTuples property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegexMatchTuples() {
        return regexMatchTuples != null && !(regexMatchTuples instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains an array of <a>RegexMatchTuple</a> objects. Each <code>RegexMatchTuple</code> object contains:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the
     * <code>User-Agent</code> header.
     * </p>
     * </li>
     * <li>
     * <p>
     * The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see
     * <a>RegexPatternSet</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for
     * the specified string.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegexMatchTuples} method.
     * </p>
     * 
     * @return Contains an array of <a>RegexMatchTuple</a> objects. Each <code>RegexMatchTuple</code> object contains:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the
     *         <code>User-Agent</code> header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more
     *         information, see <a>RegexPatternSet</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting
     *         it for the specified string.
     *         </p>
     *         </li>
     */
    public final List<RegexMatchTuple> regexMatchTuples() {
        return regexMatchTuples;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regexMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegexMatchTuples() ? regexMatchTuples() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexMatchSet)) {
            return false;
        }
        RegexMatchSet other = (RegexMatchSet) obj;
        return Objects.equals(regexMatchSetId(), other.regexMatchSetId()) && Objects.equals(name(), other.name())
                && hasRegexMatchTuples() == other.hasRegexMatchTuples()
                && Objects.equals(regexMatchTuples(), other.regexMatchTuples());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegexMatchSet").add("RegexMatchSetId", regexMatchSetId()).add("Name", name())
                .add("RegexMatchTuples", hasRegexMatchTuples() ? regexMatchTuples() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexMatchSetId":
            return Optional.ofNullable(clazz.cast(regexMatchSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RegexMatchTuples":
            return Optional.ofNullable(clazz.cast(regexMatchTuples()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegexMatchSetId", REGEX_MATCH_SET_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RegexMatchTuples", REGEX_MATCH_TUPLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegexMatchSet, T> g) {
        return obj -> g.apply((RegexMatchSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegexMatchSet> {
        /**
         * <p>
         * The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to
         * get information about a <code>RegexMatchSet</code> (see <a>GetRegexMatchSet</a>), update a
         * <code>RegexMatchSet</code> (see <a>UpdateRegexMatchSet</a>), insert a <code>RegexMatchSet</code> into a
         * <code>Rule</code> or delete one from a <code>Rule</code> (see <a>UpdateRule</a>), and delete a
         * <code>RegexMatchSet</code> from AWS WAF (see <a>DeleteRegexMatchSet</a>).
         * </p>
         * <p>
         * <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
         * </p>
         * 
         * @param regexMatchSetId
         *        The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use
         *        <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code> (see
         *        <a>GetRegexMatchSet</a>), update a <code>RegexMatchSet</code> (see <a>UpdateRegexMatchSet</a>), insert
         *        a <code>RegexMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see
         *        <a>UpdateRule</a>), and delete a <code>RegexMatchSet</code> from AWS WAF (see
         *        <a>DeleteRegexMatchSet</a>).</p>
         *        <p>
         *        <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by
         *        <a>ListRegexMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchSetId(String regexMatchSetId);

        /**
         * <p>
         * A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after you
         * create a <code>RegexMatchSet</code>.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after
         *        you create a <code>RegexMatchSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains an array of <a>RegexMatchTuple</a> objects. Each <code>RegexMatchTuple</code> object contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the
         * <code>User-Agent</code> header.
         * </p>
         * </li>
         * <li>
         * <p>
         * The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information,
         * see <a>RegexPatternSet</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it
         * for the specified string.
         * </p>
         * </li>
         * </ul>
         * 
         * @param regexMatchTuples
         *        Contains an array of <a>RegexMatchTuple</a> objects. Each <code>RegexMatchTuple</code> object
         *        contains: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the
         *        <code>User-Agent</code> header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more
         *        information, see <a>RegexPatternSet</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Whether to perform any conversions on the request, such as converting it to lowercase, before
         *        inspecting it for the specified string.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchTuples(Collection<RegexMatchTuple> regexMatchTuples);

        /**
         * <p>
         * Contains an array of <a>RegexMatchTuple</a> objects. Each <code>RegexMatchTuple</code> object contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the
         * <code>User-Agent</code> header.
         * </p>
         * </li>
         * <li>
         * <p>
         * The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information,
         * see <a>RegexPatternSet</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it
         * for the specified string.
         * </p>
         * </li>
         * </ul>
         * 
         * @param regexMatchTuples
         *        Contains an array of <a>RegexMatchTuple</a> objects. Each <code>RegexMatchTuple</code> object
         *        contains: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the
         *        <code>User-Agent</code> header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more
         *        information, see <a>RegexPatternSet</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Whether to perform any conversions on the request, such as converting it to lowercase, before
         *        inspecting it for the specified string.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchTuples(RegexMatchTuple... regexMatchTuples);

        /**
         * <p>
         * Contains an array of <a>RegexMatchTuple</a> objects. Each <code>RegexMatchTuple</code> object contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the
         * <code>User-Agent</code> header.
         * </p>
         * </li>
         * <li>
         * <p>
         * The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information,
         * see <a>RegexPatternSet</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it
         * for the specified string.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.waf.model.RegexMatchTuple.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.waf.model.RegexMatchTuple#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.waf.model.RegexMatchTuple.Builder#build()} is called immediately and
         * its result is passed to {@link #regexMatchTuples(List<RegexMatchTuple>)}.
         * 
         * @param regexMatchTuples
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.waf.model.RegexMatchTuple.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexMatchTuples(java.util.Collection<RegexMatchTuple>)
         */
        Builder regexMatchTuples(Consumer<RegexMatchTuple.Builder>... regexMatchTuples);
    }

    static final class BuilderImpl implements Builder {
        private String regexMatchSetId;

        private String name;

        private List<RegexMatchTuple> regexMatchTuples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegexMatchSet model) {
            regexMatchSetId(model.regexMatchSetId);
            name(model.name);
            regexMatchTuples(model.regexMatchTuples);
        }

        public final String getRegexMatchSetId() {
            return regexMatchSetId;
        }

        public final void setRegexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
        }

        @Override
        public final Builder regexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<RegexMatchTuple.Builder> getRegexMatchTuples() {
            List<RegexMatchTuple.Builder> result = RegexMatchTuplesCopier.copyToBuilder(this.regexMatchTuples);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexMatchTuples(Collection<RegexMatchTuple.BuilderImpl> regexMatchTuples) {
            this.regexMatchTuples = RegexMatchTuplesCopier.copyFromBuilder(regexMatchTuples);
        }

        @Override
        public final Builder regexMatchTuples(Collection<RegexMatchTuple> regexMatchTuples) {
            this.regexMatchTuples = RegexMatchTuplesCopier.copy(regexMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexMatchTuples(RegexMatchTuple... regexMatchTuples) {
            regexMatchTuples(Arrays.asList(regexMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexMatchTuples(Consumer<RegexMatchTuple.Builder>... regexMatchTuples) {
            regexMatchTuples(Stream.of(regexMatchTuples).map(c -> RegexMatchTuple.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegexMatchSet build() {
            return new RegexMatchSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
