/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RegexMatchSetUpdatesCopier {
    static List<RegexMatchSetUpdate> copy(Collection<? extends RegexMatchSetUpdate> regexMatchSetUpdatesParam) {
        List<RegexMatchSetUpdate> list;
        if (regexMatchSetUpdatesParam == null || regexMatchSetUpdatesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RegexMatchSetUpdate> modifiableList = new ArrayList<>(regexMatchSetUpdatesParam.size());
            regexMatchSetUpdatesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RegexMatchSetUpdate> copyFromBuilder(Collection<? extends RegexMatchSetUpdate.Builder> regexMatchSetUpdatesParam) {
        List<RegexMatchSetUpdate> list;
        if (regexMatchSetUpdatesParam == null || regexMatchSetUpdatesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RegexMatchSetUpdate> modifiableList = new ArrayList<>(regexMatchSetUpdatesParam.size());
            regexMatchSetUpdatesParam.forEach(entry -> {
                RegexMatchSetUpdate member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RegexMatchSetUpdate.Builder> copyToBuilder(Collection<? extends RegexMatchSetUpdate> regexMatchSetUpdatesParam) {
        List<RegexMatchSetUpdate.Builder> list;
        if (regexMatchSetUpdatesParam == null || regexMatchSetUpdatesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RegexMatchSetUpdate.Builder> modifiableList = new ArrayList<>(regexMatchSetUpdatesParam.size());
            regexMatchSetUpdatesParam.forEach(entry -> {
                RegexMatchSetUpdate.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
