/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Specifies a <code>Predicate</code> (such as an <code>IPSet</code>) and indicates whether you want to add it to a
 * <code>Rule</code> or delete it from a <code>Rule</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleUpdate implements SdkPojo, Serializable, ToCopyableBuilder<RuleUpdate.Builder, RuleUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(RuleUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.<Predicate> builder(MarshallingType.SDK_POJO)
            .memberName("Predicate").getter(getter(RuleUpdate::predicate)).setter(setter(Builder::predicate))
            .constructor(Predicate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predicate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACTION_FIELD, PREDICATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final Predicate predicate;

    private RuleUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.predicate = builder.predicate;
    }

    /**
     * <p>
     * Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use <code>DELETE</code> to
     * remove a <code>Predicate</code> from a <code>Rule</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use
     *         <code>DELETE</code> to remove a <code>Predicate</code> from a <code>Rule</code>.
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use <code>DELETE</code> to
     * remove a <code>Predicate</code> from a <code>Rule</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use
     *         <code>DELETE</code> to remove a <code>Predicate</code> from a <code>Rule</code>.
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The ID of the <code>Predicate</code> (such as an <code>IPSet</code>) that you want to add to a <code>Rule</code>.
     * </p>
     * 
     * @return The ID of the <code>Predicate</code> (such as an <code>IPSet</code>) that you want to add to a
     *         <code>Rule</code>.
     */
    public final Predicate predicate() {
        return predicate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(predicate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleUpdate)) {
            return false;
        }
        RuleUpdate other = (RuleUpdate) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(predicate(), other.predicate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleUpdate").add("Action", actionAsString()).add("Predicate", predicate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Predicate":
            return Optional.ofNullable(clazz.cast(predicate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("Predicate", PREDICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleUpdate, T> g) {
        return obj -> g.apply((RuleUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleUpdate> {
        /**
         * <p>
         * Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use <code>DELETE</code>
         * to remove a <code>Predicate</code> from a <code>Rule</code>.
         * </p>
         * 
         * @param action
         *        Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use
         *        <code>DELETE</code> to remove a <code>Predicate</code> from a <code>Rule</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use <code>DELETE</code>
         * to remove a <code>Predicate</code> from a <code>Rule</code>.
         * </p>
         * 
         * @param action
         *        Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use
         *        <code>DELETE</code> to remove a <code>Predicate</code> from a <code>Rule</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * The ID of the <code>Predicate</code> (such as an <code>IPSet</code>) that you want to add to a
         * <code>Rule</code>.
         * </p>
         * 
         * @param predicate
         *        The ID of the <code>Predicate</code> (such as an <code>IPSet</code>) that you want to add to a
         *        <code>Rule</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicate(Predicate predicate);

        /**
         * <p>
         * The ID of the <code>Predicate</code> (such as an <code>IPSet</code>) that you want to add to a
         * <code>Rule</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Predicate.Builder} avoiding the need to
         * create one manually via {@link Predicate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Predicate.Builder#build()} is called immediately and its result
         * is passed to {@link #predicate(Predicate)}.
         * 
         * @param predicate
         *        a consumer that will call methods on {@link Predicate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predicate(Predicate)
         */
        default Builder predicate(Consumer<Predicate.Builder> predicate) {
            return predicate(Predicate.builder().applyMutation(predicate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private Predicate predicate;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleUpdate model) {
            action(model.action);
            predicate(model.predicate);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Predicate.Builder getPredicate() {
            return predicate != null ? predicate.toBuilder() : null;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        @Override
        public RuleUpdate build() {
            return new RuleUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
