/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIpSetRequest extends WafRequest implements
        ToCopyableBuilder<UpdateIpSetRequest.Builder, UpdateIpSetRequest> {
    private static final SdkField<String> IP_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IPSetId").getter(getter(UpdateIpSetRequest::ipSetId)).setter(setter(Builder::ipSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetId").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(UpdateIpSetRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final SdkField<List<IPSetUpdate>> UPDATES_FIELD = SdkField
            .<List<IPSetUpdate>> builder(MarshallingType.LIST)
            .memberName("Updates")
            .getter(getter(UpdateIpSetRequest::updates))
            .setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IPSetUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPSetUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_ID_FIELD,
            CHANGE_TOKEN_FIELD, UPDATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ipSetId;

    private final String changeToken;

    private final List<IPSetUpdate> updates;

    private UpdateIpSetRequest(BuilderImpl builder) {
        super(builder);
        this.ipSetId = builder.ipSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    /**
     * <p>
     * The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned by
     * <a>CreateIPSet</a> and by <a>ListIPSets</a>.
     * </p>
     * 
     * @return The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned by
     *         <a>CreateIPSet</a> and by <a>ListIPSets</a>.
     */
    public final String ipSetId() {
        return ipSetId;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Updates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdates() {
        return updates != null && !(updates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>. For
     * more information, see the applicable data types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can insert a maximum of 1000 addresses in a single request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdates} method.
     * </p>
     * 
     * @return An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>.
     *         For more information, see the applicable data types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can insert a maximum of 1000 addresses in a single request.
     */
    public final List<IPSetUpdate> updates() {
        return updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdates() ? updates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIpSetRequest)) {
            return false;
        }
        UpdateIpSetRequest other = (UpdateIpSetRequest) obj;
        return Objects.equals(ipSetId(), other.ipSetId()) && Objects.equals(changeToken(), other.changeToken())
                && hasUpdates() == other.hasUpdates() && Objects.equals(updates(), other.updates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIpSetRequest").add("IPSetId", ipSetId()).add("ChangeToken", changeToken())
                .add("Updates", hasUpdates() ? updates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPSetId":
            return Optional.ofNullable(clazz.cast(ipSetId()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IPSetId", IP_SET_ID_FIELD);
        map.put("ChangeToken", CHANGE_TOKEN_FIELD);
        map.put("Updates", UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIpSetRequest, T> g) {
        return obj -> g.apply((UpdateIpSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIpSetRequest> {
        /**
         * <p>
         * The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned by
         * <a>CreateIPSet</a> and by <a>ListIPSets</a>.
         * </p>
         * 
         * @param ipSetId
         *        The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned
         *        by <a>CreateIPSet</a> and by <a>ListIPSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSetId(String ipSetId);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        /**
         * <p>
         * An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>. For
         * more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can insert a maximum of 1000 addresses in a single request.
         * </p>
         * 
         * @param updates
         *        An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an
         *        <a>IPSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can insert a maximum of 1000 addresses in a single request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Collection<IPSetUpdate> updates);

        /**
         * <p>
         * An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>. For
         * more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can insert a maximum of 1000 addresses in a single request.
         * </p>
         * 
         * @param updates
         *        An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an
         *        <a>IPSet</a>. For more information, see the applicable data types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can insert a maximum of 1000 addresses in a single request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(IPSetUpdate... updates);

        /**
         * <p>
         * An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>. For
         * more information, see the applicable data types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can insert a maximum of 1000 addresses in a single request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.waf.model.IPSetUpdate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.waf.model.IPSetUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.waf.model.IPSetUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #updates(List<IPSetUpdate>)}.
         * 
         * @param updates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.waf.model.IPSetUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updates(java.util.Collection<IPSetUpdate>)
         */
        Builder updates(Consumer<IPSetUpdate.Builder>... updates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String ipSetId;

        private String changeToken;

        private List<IPSetUpdate> updates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIpSetRequest model) {
            super(model);
            ipSetId(model.ipSetId);
            changeToken(model.changeToken);
            updates(model.updates);
        }

        public final String getIpSetId() {
            return ipSetId;
        }

        public final void setIpSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final List<IPSetUpdate.Builder> getUpdates() {
            List<IPSetUpdate.Builder> result = IPSetUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<IPSetUpdate.BuilderImpl> updates) {
            this.updates = IPSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public final Builder updates(Collection<IPSetUpdate> updates) {
            this.updates = IPSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(IPSetUpdate... updates) {
            updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<IPSetUpdate.Builder>... updates) {
            updates(Stream.of(updates).map(c -> IPSetUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIpSetRequest build() {
            return new UpdateIpSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
