/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * In an <a>UpdateByteMatchSet</a> request, <code>ByteMatchSetUpdate</code> specifies whether to insert or delete a
 * <a>ByteMatchTuple</a> and includes the settings for the <code>ByteMatchTuple</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ByteMatchSetUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ByteMatchSetUpdate.Builder, ByteMatchSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(ByteMatchSetUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<ByteMatchTuple> BYTE_MATCH_TUPLE_FIELD = SdkField
            .<ByteMatchTuple> builder(MarshallingType.SDK_POJO).memberName("ByteMatchTuple")
            .getter(getter(ByteMatchSetUpdate::byteMatchTuple)).setter(setter(Builder::byteMatchTuple))
            .constructor(ByteMatchTuple::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchTuple").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            BYTE_MATCH_TUPLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final ByteMatchTuple byteMatchTuple;

    private ByteMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.byteMatchTuple = builder.byteMatchTuple;
    }

    /**
     * <p>
     * Specifies whether to insert or delete a <a>ByteMatchTuple</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to insert or delete a <a>ByteMatchTuple</a>.
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies whether to insert or delete a <a>ByteMatchTuple</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies whether to insert or delete a <a>ByteMatchTuple</a>.
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Information about the part of a web request that you want AWS WAF to inspect and the value that you want AWS WAF
     * to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the
     * <code>ByteMatchTuple</code> values must exactly match the values in the <code>ByteMatchTuple</code> that you want
     * to delete from the <code>ByteMatchSet</code>.
     * </p>
     * 
     * @return Information about the part of a web request that you want AWS WAF to inspect and the value that you want
     *         AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the
     *         <code>ByteMatchTuple</code> values must exactly match the values in the <code>ByteMatchTuple</code> that
     *         you want to delete from the <code>ByteMatchSet</code>.
     */
    public final ByteMatchTuple byteMatchTuple() {
        return byteMatchTuple;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byteMatchTuple());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSetUpdate)) {
            return false;
        }
        ByteMatchSetUpdate other = (ByteMatchSetUpdate) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(byteMatchTuple(), other.byteMatchTuple());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ByteMatchSetUpdate").add("Action", actionAsString()).add("ByteMatchTuple", byteMatchTuple())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "ByteMatchTuple":
            return Optional.ofNullable(clazz.cast(byteMatchTuple()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("ByteMatchTuple", BYTE_MATCH_TUPLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ByteMatchSetUpdate, T> g) {
        return obj -> g.apply((ByteMatchSetUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ByteMatchSetUpdate> {
        /**
         * <p>
         * Specifies whether to insert or delete a <a>ByteMatchTuple</a>.
         * </p>
         * 
         * @param action
         *        Specifies whether to insert or delete a <a>ByteMatchTuple</a>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies whether to insert or delete a <a>ByteMatchTuple</a>.
         * </p>
         * 
         * @param action
         *        Specifies whether to insert or delete a <a>ByteMatchTuple</a>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Information about the part of a web request that you want AWS WAF to inspect and the value that you want AWS
         * WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the
         * <code>ByteMatchTuple</code> values must exactly match the values in the <code>ByteMatchTuple</code> that you
         * want to delete from the <code>ByteMatchSet</code>.
         * </p>
         * 
         * @param byteMatchTuple
         *        Information about the part of a web request that you want AWS WAF to inspect and the value that you
         *        want AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>,
         *        the <code>ByteMatchTuple</code> values must exactly match the values in the
         *        <code>ByteMatchTuple</code> that you want to delete from the <code>ByteMatchSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchTuple(ByteMatchTuple byteMatchTuple);

        /**
         * <p>
         * Information about the part of a web request that you want AWS WAF to inspect and the value that you want AWS
         * WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the
         * <code>ByteMatchTuple</code> values must exactly match the values in the <code>ByteMatchTuple</code> that you
         * want to delete from the <code>ByteMatchSet</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ByteMatchTuple.Builder} avoiding the need
         * to create one manually via {@link ByteMatchTuple#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ByteMatchTuple.Builder#build()} is called immediately and its
         * result is passed to {@link #byteMatchTuple(ByteMatchTuple)}.
         * 
         * @param byteMatchTuple
         *        a consumer that will call methods on {@link ByteMatchTuple.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byteMatchTuple(ByteMatchTuple)
         */
        default Builder byteMatchTuple(Consumer<ByteMatchTuple.Builder> byteMatchTuple) {
            return byteMatchTuple(ByteMatchTuple.builder().applyMutation(byteMatchTuple).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private ByteMatchTuple byteMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSetUpdate model) {
            action(model.action);
            byteMatchTuple(model.byteMatchTuple);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final ByteMatchTuple.Builder getByteMatchTuple() {
            return byteMatchTuple != null ? byteMatchTuple.toBuilder() : null;
        }

        public final void setByteMatchTuple(ByteMatchTuple.BuilderImpl byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple != null ? byteMatchTuple.build() : null;
        }

        @Override
        public final Builder byteMatchTuple(ByteMatchTuple byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple;
            return this;
        }

        @Override
        public ByteMatchSetUpdate build() {
            return new ByteMatchSetUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
