/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRegexMatchSetRequest extends WafRequest implements
        ToCopyableBuilder<DeleteRegexMatchSetRequest.Builder, DeleteRegexMatchSetRequest> {
    private static final SdkField<String> REGEX_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegexMatchSetId").getter(getter(DeleteRegexMatchSetRequest::regexMatchSetId))
            .setter(setter(Builder::regexMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchSetId").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeToken").getter(getter(DeleteRegexMatchSetRequest::changeToken))
            .setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_MATCH_SET_ID_FIELD,
            CHANGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String regexMatchSetId;

    private final String changeToken;

    private DeleteRegexMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.regexMatchSetId = builder.regexMatchSetId;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to delete.
     * <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
     * </p>
     * 
     * @return The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to delete.
     *         <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
     */
    public final String regexMatchSetId() {
        return regexMatchSetId;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public final String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(regexMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRegexMatchSetRequest)) {
            return false;
        }
        DeleteRegexMatchSetRequest other = (DeleteRegexMatchSetRequest) obj;
        return Objects.equals(regexMatchSetId(), other.regexMatchSetId()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRegexMatchSetRequest").add("RegexMatchSetId", regexMatchSetId())
                .add("ChangeToken", changeToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexMatchSetId":
            return Optional.ofNullable(clazz.cast(regexMatchSetId()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegexMatchSetId", REGEX_MATCH_SET_ID_FIELD);
        map.put("ChangeToken", CHANGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRegexMatchSetRequest, T> g) {
        return obj -> g.apply((DeleteRegexMatchSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRegexMatchSetRequest> {
        /**
         * <p>
         * The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to delete.
         * <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
         * </p>
         * 
         * @param regexMatchSetId
         *        The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to delete.
         *        <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by
         *        <a>ListRegexMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchSetId(String regexMatchSetId);

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String regexMatchSetId;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRegexMatchSetRequest model) {
            super(model);
            regexMatchSetId(model.regexMatchSetId);
            changeToken(model.changeToken);
        }

        public final String getRegexMatchSetId() {
            return regexMatchSetId;
        }

        public final void setRegexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
        }

        @Override
        public final Builder regexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
            return this;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRegexMatchSetRequest build() {
            return new DeleteRegexMatchSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
