/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRegexPatternSetRequest extends WafRequest implements
        ToCopyableBuilder<GetRegexPatternSetRequest.Builder, GetRegexPatternSetRequest> {
    private static final SdkField<String> REGEX_PATTERN_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegexPatternSetId").getter(getter(GetRegexPatternSetRequest::regexPatternSetId))
            .setter(setter(Builder::regexPatternSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_PATTERN_SET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String regexPatternSetId;

    private GetRegexPatternSetRequest(BuilderImpl builder) {
        super(builder);
        this.regexPatternSetId = builder.regexPatternSetId;
    }

    /**
     * <p>
     * The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to get.
     * <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by <a>ListRegexPatternSets</a>.
     * </p>
     * 
     * @return The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to get.
     *         <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
     *         <a>ListRegexPatternSets</a>.
     */
    public final String regexPatternSetId() {
        return regexPatternSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(regexPatternSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegexPatternSetRequest)) {
            return false;
        }
        GetRegexPatternSetRequest other = (GetRegexPatternSetRequest) obj;
        return Objects.equals(regexPatternSetId(), other.regexPatternSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRegexPatternSetRequest").add("RegexPatternSetId", regexPatternSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexPatternSetId":
            return Optional.ofNullable(clazz.cast(regexPatternSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegexPatternSetId", REGEX_PATTERN_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRegexPatternSetRequest, T> g) {
        return obj -> g.apply((GetRegexPatternSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetRegexPatternSetRequest> {
        /**
         * <p>
         * The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to get.
         * <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
         * <a>ListRegexPatternSets</a>.
         * </p>
         * 
         * @param regexPatternSetId
         *        The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to get.
         *        <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
         *        <a>ListRegexPatternSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexPatternSetId(String regexPatternSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String regexPatternSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegexPatternSetRequest model) {
            super(model);
            regexPatternSetId(model.regexPatternSetId);
        }

        public final String getRegexPatternSetId() {
            return regexPatternSetId;
        }

        public final void setRegexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
        }

        @Override
        public final Builder regexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRegexPatternSetRequest build() {
            return new GetRegexPatternSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
