/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Specifies the IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR format) that
 * web requests originate from.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IPSetDescriptor implements SdkPojo, Serializable, ToCopyableBuilder<IPSetDescriptor.Builder, IPSetDescriptor> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(IPSetDescriptor::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(IPSetDescriptor::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String value;

    private IPSetDescriptor(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * Specify <code>IPV4</code> or <code>IPV6</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IPSetDescriptorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specify <code>IPV4</code> or <code>IPV6</code>.
     * @see IPSetDescriptorType
     */
    public final IPSetDescriptorType type() {
        return IPSetDescriptorType.fromValue(type);
    }

    /**
     * <p>
     * Specify <code>IPV4</code> or <code>IPV6</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IPSetDescriptorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specify <code>IPV4</code> or <code>IPV6</code>.
     * @see IPSetDescriptorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specify an IPv4 address by using CIDR notation. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify
     * <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to
     * 192.0.2.255, specify <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * <p>
     * Specify an IPv6 address by using CIDR notation. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To configure AWS WAF to allow, block, or count requests that originated from the IP address
     * 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure AWS WAF to allow, block, or count requests that originated from IP addresses
     * 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
     * <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify an IPv4 address by using CIDR notation. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44,
     *         specify <code>192.0.2.44/32</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0
     *         to 192.0.2.255, specify <code>192.0.2.0/24</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about CIDR notation, see the Wikipedia entry <a
     *         href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     *         </p>
     *         <p>
     *         Specify an IPv6 address by using CIDR notation. For example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To configure AWS WAF to allow, block, or count requests that originated from the IP address
     *         1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure AWS WAF to allow, block, or count requests that originated from IP addresses
     *         1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
     *         <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     *         </p>
     *         </li>
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetDescriptor)) {
            return false;
        }
        IPSetDescriptor other = (IPSetDescriptor) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IPSetDescriptor").add("Type", typeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IPSetDescriptor, T> g) {
        return obj -> g.apply((IPSetDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IPSetDescriptor> {
        /**
         * <p>
         * Specify <code>IPV4</code> or <code>IPV6</code>.
         * </p>
         * 
         * @param type
         *        Specify <code>IPV4</code> or <code>IPV6</code>.
         * @see IPSetDescriptorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPSetDescriptorType
         */
        Builder type(String type);

        /**
         * <p>
         * Specify <code>IPV4</code> or <code>IPV6</code>.
         * </p>
         * 
         * @param type
         *        Specify <code>IPV4</code> or <code>IPV6</code>.
         * @see IPSetDescriptorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPSetDescriptorType
         */
        Builder type(IPSetDescriptorType type);

        /**
         * <p>
         * Specify an IPv4 address by using CIDR notation. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44,
         * specify <code>192.0.2.44/32</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to
         * 192.0.2.255, specify <code>192.0.2.0/24</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a
         * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
         * </p>
         * <p>
         * Specify an IPv6 address by using CIDR notation. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from the IP address
         * 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from IP addresses
         * 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
         * <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param value
         *        Specify an IPv4 address by using CIDR notation. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from the IP address
         *        192.0.2.44, specify <code>192.0.2.44/32</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from IP addresses from
         *        192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about CIDR notation, see the Wikipedia entry <a
         *        href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain
         *        Routing</a>.
         *        </p>
         *        <p>
         *        Specify an IPv6 address by using CIDR notation. For example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from the IP address
         *        1111:0000:0000:0000:0000:0000:0000:0111, specify
         *        <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from IP addresses
         *        1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
         *        <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetDescriptor model) {
            type(model.type);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IPSetDescriptorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public IPSetDescriptor build() {
            return new IPSetDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
