/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoMatchSetUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoMatchSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(GeoMatchSetUpdate.getter(GeoMatchSetUpdate::actionAsString)).setter(GeoMatchSetUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<GeoMatchConstraint> GEO_MATCH_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeoMatchConstraint").getter(GeoMatchSetUpdate.getter(GeoMatchSetUpdate::geoMatchConstraint)).setter(GeoMatchSetUpdate.setter(Builder::geoMatchConstraint)).constructor(GeoMatchConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchConstraint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, GEO_MATCH_CONSTRAINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeoMatchSetUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final GeoMatchConstraint geoMatchConstraint;

    private GeoMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.geoMatchConstraint = builder.geoMatchConstraint;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final GeoMatchConstraint geoMatchConstraint() {
        return this.geoMatchConstraint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchConstraint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchSetUpdate)) {
            return false;
        }
        GeoMatchSetUpdate other = (GeoMatchSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.geoMatchConstraint(), other.geoMatchConstraint());
    }

    public final String toString() {
        return ToString.builder((String)"GeoMatchSetUpdate").add("Action", (Object)this.actionAsString()).add("GeoMatchConstraint", (Object)this.geoMatchConstraint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "GeoMatchConstraint": {
                return Optional.ofNullable(clazz.cast(this.geoMatchConstraint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("GeoMatchConstraint", GEO_MATCH_CONSTRAINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchSetUpdate, T> g) {
        return obj -> g.apply((GeoMatchSetUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private GeoMatchConstraint geoMatchConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchSetUpdate model) {
            this.action(model.action);
            this.geoMatchConstraint(model.geoMatchConstraint);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final GeoMatchConstraint.Builder getGeoMatchConstraint() {
            return this.geoMatchConstraint != null ? this.geoMatchConstraint.toBuilder() : null;
        }

        public final void setGeoMatchConstraint(GeoMatchConstraint.BuilderImpl geoMatchConstraint) {
            this.geoMatchConstraint = geoMatchConstraint != null ? geoMatchConstraint.build() : null;
        }

        @Override
        public final Builder geoMatchConstraint(GeoMatchConstraint geoMatchConstraint) {
            this.geoMatchConstraint = geoMatchConstraint;
            return this;
        }

        public GeoMatchSetUpdate build() {
            return new GeoMatchSetUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder geoMatchConstraint(GeoMatchConstraint var1);

        default public Builder geoMatchConstraint(Consumer<GeoMatchConstraint.Builder> geoMatchConstraint) {
            return this.geoMatchConstraint((GeoMatchConstraint)((GeoMatchConstraint.Builder)GeoMatchConstraint.builder().applyMutation(geoMatchConstraint)).build());
        }
    }
}

