/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRegexMatchSetResponse extends WafResponse implements
        ToCopyableBuilder<GetRegexMatchSetResponse.Builder, GetRegexMatchSetResponse> {
    private static final SdkField<RegexMatchSet> REGEX_MATCH_SET_FIELD = SdkField
            .<RegexMatchSet> builder(MarshallingType.SDK_POJO).memberName("RegexMatchSet")
            .getter(getter(GetRegexMatchSetResponse::regexMatchSet)).setter(setter(Builder::regexMatchSet))
            .constructor(RegexMatchSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_MATCH_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RegexMatchSet regexMatchSet;

    private GetRegexMatchSetResponse(BuilderImpl builder) {
        super(builder);
        this.regexMatchSet = builder.regexMatchSet;
    }

    /**
     * <p>
     * Information about the <a>RegexMatchSet</a> that you specified in the <code>GetRegexMatchSet</code> request. For
     * more information, see <a>RegexMatchTuple</a>.
     * </p>
     * 
     * @return Information about the <a>RegexMatchSet</a> that you specified in the <code>GetRegexMatchSet</code>
     *         request. For more information, see <a>RegexMatchTuple</a>.
     */
    public final RegexMatchSet regexMatchSet() {
        return regexMatchSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(regexMatchSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegexMatchSetResponse)) {
            return false;
        }
        GetRegexMatchSetResponse other = (GetRegexMatchSetResponse) obj;
        return Objects.equals(regexMatchSet(), other.regexMatchSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRegexMatchSetResponse").add("RegexMatchSet", regexMatchSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexMatchSet":
            return Optional.ofNullable(clazz.cast(regexMatchSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegexMatchSet", REGEX_MATCH_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRegexMatchSetResponse, T> g) {
        return obj -> g.apply((GetRegexMatchSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRegexMatchSetResponse> {
        /**
         * <p>
         * Information about the <a>RegexMatchSet</a> that you specified in the <code>GetRegexMatchSet</code> request.
         * For more information, see <a>RegexMatchTuple</a>.
         * </p>
         * 
         * @param regexMatchSet
         *        Information about the <a>RegexMatchSet</a> that you specified in the <code>GetRegexMatchSet</code>
         *        request. For more information, see <a>RegexMatchTuple</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchSet(RegexMatchSet regexMatchSet);

        /**
         * <p>
         * Information about the <a>RegexMatchSet</a> that you specified in the <code>GetRegexMatchSet</code> request.
         * For more information, see <a>RegexMatchTuple</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegexMatchSet.Builder} avoiding the need
         * to create one manually via {@link RegexMatchSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegexMatchSet.Builder#build()} is called immediately and its
         * result is passed to {@link #regexMatchSet(RegexMatchSet)}.
         * 
         * @param regexMatchSet
         *        a consumer that will call methods on {@link RegexMatchSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexMatchSet(RegexMatchSet)
         */
        default Builder regexMatchSet(Consumer<RegexMatchSet.Builder> regexMatchSet) {
            return regexMatchSet(RegexMatchSet.builder().applyMutation(regexMatchSet).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private RegexMatchSet regexMatchSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegexMatchSetResponse model) {
            super(model);
            regexMatchSet(model.regexMatchSet);
        }

        public final RegexMatchSet.Builder getRegexMatchSet() {
            return regexMatchSet != null ? regexMatchSet.toBuilder() : null;
        }

        public final void setRegexMatchSet(RegexMatchSet.BuilderImpl regexMatchSet) {
            this.regexMatchSet = regexMatchSet != null ? regexMatchSet.build() : null;
        }

        @Override
        public final Builder regexMatchSet(RegexMatchSet regexMatchSet) {
            this.regexMatchSet = regexMatchSet;
            return this;
        }

        @Override
        public GetRegexMatchSetResponse build() {
            return new GetRegexMatchSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
