/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRegexPatternSetResponse extends WafResponse implements
        ToCopyableBuilder<GetRegexPatternSetResponse.Builder, GetRegexPatternSetResponse> {
    private static final SdkField<RegexPatternSet> REGEX_PATTERN_SET_FIELD = SdkField
            .<RegexPatternSet> builder(MarshallingType.SDK_POJO).memberName("RegexPatternSet")
            .getter(getter(GetRegexPatternSetResponse::regexPatternSet)).setter(setter(Builder::regexPatternSet))
            .constructor(RegexPatternSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexPatternSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_PATTERN_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RegexPatternSet regexPatternSet;

    private GetRegexPatternSetResponse(BuilderImpl builder) {
        super(builder);
        this.regexPatternSet = builder.regexPatternSet;
    }

    /**
     * <p>
     * Information about the <a>RegexPatternSet</a> that you specified in the <code>GetRegexPatternSet</code> request,
     * including the identifier of the pattern set and the regular expression patterns you want AWS WAF to search for.
     * </p>
     * 
     * @return Information about the <a>RegexPatternSet</a> that you specified in the <code>GetRegexPatternSet</code>
     *         request, including the identifier of the pattern set and the regular expression patterns you want AWS WAF
     *         to search for.
     */
    public final RegexPatternSet regexPatternSet() {
        return regexPatternSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(regexPatternSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegexPatternSetResponse)) {
            return false;
        }
        GetRegexPatternSetResponse other = (GetRegexPatternSetResponse) obj;
        return Objects.equals(regexPatternSet(), other.regexPatternSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRegexPatternSetResponse").add("RegexPatternSet", regexPatternSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexPatternSet":
            return Optional.ofNullable(clazz.cast(regexPatternSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegexPatternSet", REGEX_PATTERN_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRegexPatternSetResponse, T> g) {
        return obj -> g.apply((GetRegexPatternSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRegexPatternSetResponse> {
        /**
         * <p>
         * Information about the <a>RegexPatternSet</a> that you specified in the <code>GetRegexPatternSet</code>
         * request, including the identifier of the pattern set and the regular expression patterns you want AWS WAF to
         * search for.
         * </p>
         * 
         * @param regexPatternSet
         *        Information about the <a>RegexPatternSet</a> that you specified in the <code>GetRegexPatternSet</code>
         *        request, including the identifier of the pattern set and the regular expression patterns you want AWS
         *        WAF to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexPatternSet(RegexPatternSet regexPatternSet);

        /**
         * <p>
         * Information about the <a>RegexPatternSet</a> that you specified in the <code>GetRegexPatternSet</code>
         * request, including the identifier of the pattern set and the regular expression patterns you want AWS WAF to
         * search for.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegexPatternSet.Builder} avoiding the
         * need to create one manually via {@link RegexPatternSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegexPatternSet.Builder#build()} is called immediately and its
         * result is passed to {@link #regexPatternSet(RegexPatternSet)}.
         * 
         * @param regexPatternSet
         *        a consumer that will call methods on {@link RegexPatternSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexPatternSet(RegexPatternSet)
         */
        default Builder regexPatternSet(Consumer<RegexPatternSet.Builder> regexPatternSet) {
            return regexPatternSet(RegexPatternSet.builder().applyMutation(regexPatternSet).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private RegexPatternSet regexPatternSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegexPatternSetResponse model) {
            super(model);
            regexPatternSet(model.regexPatternSet);
        }

        public final RegexPatternSet.Builder getRegexPatternSet() {
            return regexPatternSet != null ? regexPatternSet.toBuilder() : null;
        }

        public final void setRegexPatternSet(RegexPatternSet.BuilderImpl regexPatternSet) {
            this.regexPatternSet = regexPatternSet != null ? regexPatternSet.build() : null;
        }

        @Override
        public final Builder regexPatternSet(RegexPatternSet regexPatternSet) {
            this.regexPatternSet = regexPatternSet;
            return this;
        }

        @Override
        public GetRegexPatternSetResponse build() {
            return new GetRegexPatternSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
