/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSampledRequestsRequest extends WafRequest implements
        ToCopyableBuilder<GetSampledRequestsRequest.Builder, GetSampledRequestsRequest> {
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAclId").getter(getter(GetSampledRequestsRequest::webAclId)).setter(setter(Builder::webAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclId").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(GetSampledRequestsRequest::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<TimeWindow> TIME_WINDOW_FIELD = SdkField.<TimeWindow> builder(MarshallingType.SDK_POJO)
            .memberName("TimeWindow").getter(getter(GetSampledRequestsRequest::timeWindow)).setter(setter(Builder::timeWindow))
            .constructor(TimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeWindow").build()).build();

    private static final SdkField<Long> MAX_ITEMS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("MaxItems")
            .getter(getter(GetSampledRequestsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ID_FIELD,
            RULE_ID_FIELD, TIME_WINDOW_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String webAclId;

    private final String ruleId;

    private final TimeWindow timeWindow;

    private final Long maxItems;

    private GetSampledRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.webAclId = builder.webAclId;
        this.ruleId = builder.ruleId;
        this.timeWindow = builder.timeWindow;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The <code>WebACLId</code> of the <code>WebACL</code> for which you want <code>GetSampledRequests</code> to return
     * a sample of requests.
     * </p>
     * 
     * @return The <code>WebACLId</code> of the <code>WebACL</code> for which you want <code>GetSampledRequests</code>
     *         to return a sample of requests.
     */
    public final String webAclId() {
        return webAclId;
    }

    /**
     * <p>
     * <code>RuleId</code> is one of three values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>RuleId</code> of the <code>Rule</code> or the <code>RuleGroupId</code> of the <code>RuleGroup</code>
     * for which you want <code>GetSampledRequests</code> to return a sample of requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Default_Action</code>, which causes <code>GetSampledRequests</code> to return a sample of the requests that
     * didn't match any of the rules in the specified <code>WebACL</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return <code>RuleId</code> is one of three values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>RuleId</code> of the <code>Rule</code> or the <code>RuleGroupId</code> of the
     *         <code>RuleGroup</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Default_Action</code>, which causes <code>GetSampledRequests</code> to return a sample of the
     *         requests that didn't match any of the rules in the specified <code>WebACL</code>.
     *         </p>
     *         </li>
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code>
     * to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format
     * includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify
     * any time range in the previous three hours.
     * </p>
     * 
     * @return The start date and time and the end date and time of the range for which you want
     *         <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated
     *         Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example,
     *         <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.
     */
    public final TimeWindow timeWindow() {
        return timeWindow;
    }

    /**
     * <p>
     * The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource
     * received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>,
     * <code>GetSampledRequests</code> returns information about all of them.
     * </p>
     * 
     * @return The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS
     *         resource received during the time range. If your resource received fewer requests than the value of
     *         <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them.
     */
    public final Long maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webAclId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(timeWindow());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampledRequestsRequest)) {
            return false;
        }
        GetSampledRequestsRequest other = (GetSampledRequestsRequest) obj;
        return Objects.equals(webAclId(), other.webAclId()) && Objects.equals(ruleId(), other.ruleId())
                && Objects.equals(timeWindow(), other.timeWindow()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSampledRequestsRequest").add("WebAclId", webAclId()).add("RuleId", ruleId())
                .add("TimeWindow", timeWindow()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebAclId":
            return Optional.ofNullable(clazz.cast(webAclId()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "TimeWindow":
            return Optional.ofNullable(clazz.cast(timeWindow()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebAclId", WEB_ACL_ID_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("TimeWindow", TIME_WINDOW_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSampledRequestsRequest, T> g) {
        return obj -> g.apply((GetSampledRequestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSampledRequestsRequest> {
        /**
         * <p>
         * The <code>WebACLId</code> of the <code>WebACL</code> for which you want <code>GetSampledRequests</code> to
         * return a sample of requests.
         * </p>
         * 
         * @param webAclId
         *        The <code>WebACLId</code> of the <code>WebACL</code> for which you want
         *        <code>GetSampledRequests</code> to return a sample of requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAclId(String webAclId);

        /**
         * <p>
         * <code>RuleId</code> is one of three values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The <code>RuleId</code> of the <code>Rule</code> or the <code>RuleGroupId</code> of the
         * <code>RuleGroup</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Default_Action</code>, which causes <code>GetSampledRequests</code> to return a sample of the requests
         * that didn't match any of the rules in the specified <code>WebACL</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param ruleId
         *        <code>RuleId</code> is one of three values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The <code>RuleId</code> of the <code>Rule</code> or the <code>RuleGroupId</code> of the
         *        <code>RuleGroup</code> for which you want <code>GetSampledRequests</code> to return a sample of
         *        requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Default_Action</code>, which causes <code>GetSampledRequests</code> to return a sample of the
         *        requests that didn't match any of the rules in the specified <code>WebACL</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The start date and time and the end date and time of the range for which you want
         * <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated
         * Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example,
         * <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.
         * </p>
         * 
         * @param timeWindow
         *        The start date and time and the end date and time of the range for which you want
         *        <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in
         *        Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>.
         *        For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three
         *        hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeWindow(TimeWindow timeWindow);

        /**
         * <p>
         * The start date and time and the end date and time of the range for which you want
         * <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated
         * Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example,
         * <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeWindow.Builder} avoiding the need to
         * create one manually via {@link TimeWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeWindow.Builder#build()} is called immediately and its result
         * is passed to {@link #timeWindow(TimeWindow)}.
         * 
         * @param timeWindow
         *        a consumer that will call methods on {@link TimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeWindow(TimeWindow)
         */
        default Builder timeWindow(Consumer<TimeWindow.Builder> timeWindow) {
            return timeWindow(TimeWindow.builder().applyMutation(timeWindow).build());
        }

        /**
         * <p>
         * The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS
         * resource received during the time range. If your resource received fewer requests than the value of
         * <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them.
         * </p>
         * 
         * @param maxItems
         *        The number of requests that you want AWS WAF to return from among the first 5,000 requests that your
         *        AWS resource received during the time range. If your resource received fewer requests than the value
         *        of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Long maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String webAclId;

        private String ruleId;

        private TimeWindow timeWindow;

        private Long maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampledRequestsRequest model) {
            super(model);
            webAclId(model.webAclId);
            ruleId(model.ruleId);
            timeWindow(model.timeWindow);
            maxItems(model.maxItems);
        }

        public final String getWebAclId() {
            return webAclId;
        }

        public final void setWebAclId(String webAclId) {
            this.webAclId = webAclId;
        }

        @Override
        public final Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return timeWindow != null ? timeWindow.toBuilder() : null;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        @Override
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public final Long getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Long maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Long maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSampledRequestsRequest build() {
            return new GetSampledRequestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
