/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListActivatedRulesInRuleGroupResponse extends WafResponse implements
        ToCopyableBuilder<ListActivatedRulesInRuleGroupResponse.Builder, ListActivatedRulesInRuleGroupResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListActivatedRulesInRuleGroupResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<ActivatedRule>> ACTIVATED_RULES_FIELD = SdkField
            .<List<ActivatedRule>> builder(MarshallingType.LIST)
            .memberName("ActivatedRules")
            .getter(getter(ListActivatedRulesInRuleGroupResponse::activatedRules))
            .setter(setter(Builder::activatedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivatedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActivatedRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActivatedRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            ACTIVATED_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextMarker;

    private final List<ActivatedRule> activatedRules;

    private ListActivatedRulesInRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.activatedRules = builder.activatedRules;
    }

    /**
     * <p>
     * If you have more <code>ActivatedRules</code> than the number that you specified for <code>Limit</code> in the
     * request, the response includes a <code>NextMarker</code> value. To list more <code>ActivatedRules</code>, submit
     * another <code>ListActivatedRulesInRuleGroup</code> request, and specify the <code>NextMarker</code> value from
     * the response in the <code>NextMarker</code> value in the next request.
     * </p>
     * 
     * @return If you have more <code>ActivatedRules</code> than the number that you specified for <code>Limit</code> in
     *         the request, the response includes a <code>NextMarker</code> value. To list more
     *         <code>ActivatedRules</code>, submit another <code>ListActivatedRulesInRuleGroup</code> request, and
     *         specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the
     *         next request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActivatedRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActivatedRules() {
        return activatedRules != null && !(activatedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ActivatedRules</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActivatedRules} method.
     * </p>
     * 
     * @return An array of <code>ActivatedRules</code> objects.
     */
    public final List<ActivatedRule> activatedRules() {
        return activatedRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasActivatedRules() ? activatedRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActivatedRulesInRuleGroupResponse)) {
            return false;
        }
        ListActivatedRulesInRuleGroupResponse other = (ListActivatedRulesInRuleGroupResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasActivatedRules() == other.hasActivatedRules()
                && Objects.equals(activatedRules(), other.activatedRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListActivatedRulesInRuleGroupResponse").add("NextMarker", nextMarker())
                .add("ActivatedRules", hasActivatedRules() ? activatedRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "ActivatedRules":
            return Optional.ofNullable(clazz.cast(activatedRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("ActivatedRules", ACTIVATED_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActivatedRulesInRuleGroupResponse, T> g) {
        return obj -> g.apply((ListActivatedRulesInRuleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WafResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListActivatedRulesInRuleGroupResponse> {
        /**
         * <p>
         * If you have more <code>ActivatedRules</code> than the number that you specified for <code>Limit</code> in the
         * request, the response includes a <code>NextMarker</code> value. To list more <code>ActivatedRules</code>,
         * submit another <code>ListActivatedRulesInRuleGroup</code> request, and specify the <code>NextMarker</code>
         * value from the response in the <code>NextMarker</code> value in the next request.
         * </p>
         * 
         * @param nextMarker
         *        If you have more <code>ActivatedRules</code> than the number that you specified for <code>Limit</code>
         *        in the request, the response includes a <code>NextMarker</code> value. To list more
         *        <code>ActivatedRules</code>, submit another <code>ListActivatedRulesInRuleGroup</code> request, and
         *        specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in
         *        the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of <code>ActivatedRules</code> objects.
         * </p>
         * 
         * @param activatedRules
         *        An array of <code>ActivatedRules</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activatedRules(Collection<ActivatedRule> activatedRules);

        /**
         * <p>
         * An array of <code>ActivatedRules</code> objects.
         * </p>
         * 
         * @param activatedRules
         *        An array of <code>ActivatedRules</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activatedRules(ActivatedRule... activatedRules);

        /**
         * <p>
         * An array of <code>ActivatedRules</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.waf.model.ActivatedRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.waf.model.ActivatedRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.waf.model.ActivatedRule.Builder#build()} is called immediately and its
         * result is passed to {@link #activatedRules(List<ActivatedRule>)}.
         * 
         * @param activatedRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.waf.model.ActivatedRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activatedRules(java.util.Collection<ActivatedRule>)
         */
        Builder activatedRules(Consumer<ActivatedRule.Builder>... activatedRules);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<ActivatedRule> activatedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListActivatedRulesInRuleGroupResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            activatedRules(model.activatedRules);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<ActivatedRule.Builder> getActivatedRules() {
            List<ActivatedRule.Builder> result = ActivatedRulesCopier.copyToBuilder(this.activatedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActivatedRules(Collection<ActivatedRule.BuilderImpl> activatedRules) {
            this.activatedRules = ActivatedRulesCopier.copyFromBuilder(activatedRules);
        }

        @Override
        public final Builder activatedRules(Collection<ActivatedRule> activatedRules) {
            this.activatedRules = ActivatedRulesCopier.copy(activatedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activatedRules(ActivatedRule... activatedRules) {
            activatedRules(Arrays.asList(activatedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activatedRules(Consumer<ActivatedRule.Builder>... activatedRules) {
            activatedRules(Stream.of(activatedRules).map(c -> ActivatedRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListActivatedRulesInRuleGroupResponse build() {
            return new ListActivatedRulesInRuleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
