/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.AssociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityRequest;
import software.amazon.awssdk.services.wafv2.model.CheckCapacityResponse;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.DeletePermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DeleteWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.DisassociateWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.GetIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest;
import software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysResponse;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.GetRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsRequest;
import software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.GetWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.GetWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsRequest;
import software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRegexPatternSetsResponse;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclResponse;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.wafv2.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsRequest;
import software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationRequest;
import software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse;
import software.amazon.awssdk.services.wafv2.model.PutPermissionPolicyRequest;
import software.amazon.awssdk.services.wafv2.model.PutPermissionPolicyResponse;
import software.amazon.awssdk.services.wafv2.model.TagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.TagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.wafv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclRequest;
import software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse;

/**
 * Service client for accessing WAFV2 asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <note>
 * <p>
 * This is the latest version of the <b>AWS WAF</b> API, released in November, 2019. The names of the entities that you
 * use to access this API, like endpoints and namespaces, all have the versioning information added, like "V2" or "v2",
 * to distinguish from the prior version. We recommend migrating your resources to this version, because it has a number
 * of significant improvements.
 * </p>
 * <p>
 * If you used AWS WAF prior to this release, you can't use this AWS WAFV2 API to access any AWS WAF resources that you
 * created before. You can access your old rules, web ACLs, and other AWS WAF resources only through the AWS WAF Classic
 * APIs. The AWS WAF Classic APIs have retained the prior names, endpoints, and namespaces.
 * </p>
 * <p>
 * For information, including how to migrate your AWS WAF resources to this version, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>.
 * </p>
 * </note>
 * <p>
 * AWS WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to Amazon
 * CloudFront, an Amazon API Gateway REST API, an Application Load Balancer, or an AWS AppSync GraphQL API. AWS WAF also
 * lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests
 * originate from or the values of query strings, the API Gateway REST API, CloudFront distribution, the Application
 * Load Balancer, or the AWS AppSync GraphQL API responds to requests either with the requested content or with an HTTP
 * 403 status code (Forbidden). You also can configure CloudFront to return a custom error page when a request is
 * blocked.
 * </p>
 * <p>
 * This API guide is for developers who need detailed information about AWS WAF API actions, data types, and errors. For
 * detailed information about AWS WAF features and an overview of how to use AWS WAF, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.
 * </p>
 * <p>
 * You can make calls using the endpoints listed in <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#waf_region">AWS Service Endpoints for AWS WAF</a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * For regional applications, you can use any of the endpoints in the list. A regional application can be an Application
 * Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
 * </p>
 * </li>
 * <li>
 * <p>
 * For AWS CloudFront applications, you must use the API endpoint listed for US East (N. Virginia): us-east-1.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Alternatively, you can use one of the AWS SDKs to access an API that's tailored to the programming language or
 * platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.
 * </p>
 * <p>
 * We currently provide two versions of the AWS WAF API: this API and the prior versions, the classic AWS WAF APIs. This
 * new API provides the same functionality as the older versions, with the following major improvements:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You use one API for both global and regional applications. Where you need to distinguish the scope, you specify a
 * <code>Scope</code> parameter and set it to <code>CLOUDFRONT</code> or <code>REGIONAL</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * You can define a Web ACL or rule group with a single call, and update it with a single call. You define all rule
 * specifications in JSON format, and pass them to your rule group or Web ACL calls.
 * </p>
 * </li>
 * <li>
 * <p>
 * The limits AWS WAF places on the use of rules more closely reflects the cost of running each type of rule. Rule
 * groups include capacity settings, so you know the maximum cost of a rule group when you use it.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Wafv2AsyncClient extends SdkClient {
    String SERVICE_NAME = "wafv2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "wafv2";

    /**
     * Create a {@link Wafv2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Wafv2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Wafv2AsyncClient}.
     */
    static Wafv2AsyncClientBuilder builder() {
        return new DefaultWafv2AsyncClientBuilder();
    }

    /**
     * <p>
     * Associates a Web ACL with a regional application resource, to protect the resource. A regional application can be
     * an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * For AWS CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate a
     * Web ACL, in the CloudFront call <code>UpdateDistribution</code>, set the web ACL ID to the Amazon Resource Name
     * (ARN) of the Web ACL. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>.
     * </p>
     *
     * @param associateWebAclRequest
     * @return A Java Future containing the result of the AssociateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.AssociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateWebAclResponse> associateWebACL(AssociateWebAclRequest associateWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a Web ACL with a regional application resource, to protect the resource. A regional application can be
     * an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * For AWS CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate a
     * Web ACL, in the CloudFront call <code>UpdateDistribution</code>, set the web ACL ID to the Amazon Resource Name
     * (ARN) of the Web ACL. For information, see <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateWebAclRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateWebAclRequest#builder()}
     * </p>
     *
     * @param associateWebAclRequest
     *        A {@link Consumer} that will call methods on {@link AssociateWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.AssociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/AssociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateWebAclResponse> associateWebACL(
            Consumer<AssociateWebAclRequest.Builder> associateWebAclRequest) {
        return associateWebACL(AssociateWebAclRequest.builder().applyMutation(associateWebAclRequest).build());
    }

    /**
     * <p>
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to
     * check the capacity requirements for the rules you want to use in a <a>RuleGroup</a> or <a>WebACL</a>.
     * </p>
     * <p>
     * AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups,
     * and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each
     * rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power.
     * Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule
     * group. The WCU limit for web ACLs is 1,500.
     * </p>
     *
     * @param checkCapacityRequest
     * @return A Java Future containing the result of the CheckCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException AWS WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CheckCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CheckCapacity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CheckCapacityResponse> checkCapacity(CheckCapacityRequest checkCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to
     * check the capacity requirements for the rules you want to use in a <a>RuleGroup</a> or <a>WebACL</a>.
     * </p>
     * <p>
     * AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups,
     * and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each
     * rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power.
     * Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule
     * group. The WCU limit for web ACLs is 1,500.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckCapacityRequest.Builder} avoiding the need to
     * create one manually via {@link CheckCapacityRequest#builder()}
     * </p>
     *
     * @param checkCapacityRequest
     *        A {@link Consumer} that will call methods on {@link CheckCapacityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CheckCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException AWS WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CheckCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CheckCapacity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CheckCapacityResponse> checkCapacity(Consumer<CheckCapacityRequest.Builder> checkCapacityRequest) {
        return checkCapacity(CheckCapacityRequest.builder().applyMutation(checkCapacityRequest).build());
    }

    /**
     * <p>
     * Creates an <a>IPSet</a>, which you use to identify web requests that originate from specific IP addresses or
     * ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can
     * configure AWS WAF to block them using an IPSet that lists those IP addresses.
     * </p>
     *
     * @param createIpSetRequest
     * @return A Java Future containing the result of the CreateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpSetResponse> createIPSet(CreateIpSetRequest createIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a>IPSet</a>, which you use to identify web requests that originate from specific IP addresses or
     * ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can
     * configure AWS WAF to block them using an IPSet that lists those IP addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpSetRequest#builder()}
     * </p>
     *
     * @param createIpSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateIPSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIpSetResponse> createIPSet(Consumer<CreateIpSetRequest.Builder> createIpSetRequest) {
        return createIPSet(CreateIpSetRequest.builder().applyMutation(createIpSetRequest).build());
    }

    /**
     * <p>
     * Creates a <a>RegexPatternSet</a>, which you reference in a <a>RegexPatternSetReferenceStatement</a>, to have AWS
     * WAF inspect a web request component for the specified patterns.
     * </p>
     *
     * @param createRegexPatternSetRequest
     * @return A Java Future containing the result of the CreateRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRegexPatternSetResponse> createRegexPatternSet(
            CreateRegexPatternSetRequest createRegexPatternSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>RegexPatternSet</a>, which you reference in a <a>RegexPatternSetReferenceStatement</a>, to have AWS
     * WAF inspect a web request component for the specified patterns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param createRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRegexPatternSetResponse> createRegexPatternSet(
            Consumer<CreateRegexPatternSetRequest.Builder> createRegexPatternSetRequest) {
        return createRegexPatternSet(CreateRegexPatternSetRequest.builder().applyMutation(createRegexPatternSetRequest).build());
    }

    /**
     * <p>
     * Creates a <a>RuleGroup</a> per the specifications provided.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     *
     * @param createRuleGroupRequest
     * @return A Java Future containing the result of the CreateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleGroupResponse> createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>RuleGroup</a> per the specifications provided.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRuleGroupRequest#builder()}
     * </p>
     *
     * @param createRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateRuleGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleGroupResponse> createRuleGroup(
            Consumer<CreateRuleGroupRequest.Builder> createRuleGroupRequest) {
        return createRuleGroup(CreateRuleGroupRequest.builder().applyMutation(createRuleGroupRequest).build());
    }

    /**
     * <p>
     * Creates a <a>WebACL</a> per the specifications provided.
     * </p>
     * <p>
     * A Web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the Web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a Web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * Web ACL with one or more AWS resources to protect. The resources can be Amazon CloudFront, an Amazon API Gateway
     * REST API, an Application Load Balancer, or an AWS AppSync GraphQL API.
     * </p>
     *
     * @param createWebAclRequest
     * @return A Java Future containing the result of the CreateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException AWS WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWebAclResponse> createWebACL(CreateWebAclRequest createWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>WebACL</a> per the specifications provided.
     * </p>
     * <p>
     * A Web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the Web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a Web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * Web ACL with one or more AWS resources to protect. The resources can be Amazon CloudFront, an Amazon API Gateway
     * REST API, an Application Load Balancer, or an AWS AppSync GraphQL API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWebAclRequest#builder()}
     * </p>
     *
     * @param createWebAclRequest
     *        A {@link Consumer} that will call methods on {@link CreateWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException AWS WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.CreateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/CreateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWebAclResponse> createWebACL(Consumer<CreateWebAclRequest.Builder> createWebAclRequest) {
        return createWebACL(CreateWebAclRequest.builder().applyMutation(createWebAclRequest).build());
    }

    /**
     * <p>
     * Deletes all rule groups that are managed by AWS Firewall Manager for the specified web ACL.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     *
     * @param deleteFirewallManagerRuleGroupsRequest
     * @return A Java Future containing the result of the DeleteFirewallManagerRuleGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteFirewallManagerRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteFirewallManagerRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallManagerRuleGroupsResponse> deleteFirewallManagerRuleGroups(
            DeleteFirewallManagerRuleGroupsRequest deleteFirewallManagerRuleGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all rule groups that are managed by AWS Firewall Manager for the specified web ACL.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallManagerRuleGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFirewallManagerRuleGroupsRequest#builder()}
     * </p>
     *
     * @param deleteFirewallManagerRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFirewallManagerRuleGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteFirewallManagerRuleGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteFirewallManagerRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteFirewallManagerRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallManagerRuleGroupsResponse> deleteFirewallManagerRuleGroups(
            Consumer<DeleteFirewallManagerRuleGroupsRequest.Builder> deleteFirewallManagerRuleGroupsRequest) {
        return deleteFirewallManagerRuleGroups(DeleteFirewallManagerRuleGroupsRequest.builder()
                .applyMutation(deleteFirewallManagerRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>IPSet</a>.
     * </p>
     *
     * @param deleteIpSetRequest
     * @return A Java Future containing the result of the DeleteIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException AWS WAF couldn’t perform the operation because your resource is being used
     *         by another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpSetResponse> deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>IPSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpSetRequest#builder()}
     * </p>
     *
     * @param deleteIpSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIPSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException AWS WAF couldn’t perform the operation because your resource is being used
     *         by another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIpSetResponse> deleteIPSet(Consumer<DeleteIpSetRequest.Builder> deleteIpSetRequest) {
        return deleteIPSet(DeleteIpSetRequest.builder().applyMutation(deleteIpSetRequest).build());
    }

    /**
     * <p>
     * Deletes the <a>LoggingConfiguration</a> from the specified web ACL.
     * </p>
     *
     * @param deleteLoggingConfigurationRequest
     * @return A Java Future containing the result of the DeleteLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoggingConfigurationResponse> deleteLoggingConfiguration(
            DeleteLoggingConfigurationRequest deleteLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <a>LoggingConfiguration</a> from the specified web ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLoggingConfigurationResponse> deleteLoggingConfiguration(
            Consumer<DeleteLoggingConfigurationRequest.Builder> deleteLoggingConfigurationRequest) {
        return deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.builder()
                .applyMutation(deleteLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Permanently deletes an IAM policy from the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     *
     * @param deletePermissionPolicyRequest
     * @return A Java Future containing the result of the DeletePermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeletePermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeletePermissionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePermissionPolicyResponse> deletePermissionPolicy(
            DeletePermissionPolicyRequest deletePermissionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes an IAM policy from the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePermissionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePermissionPolicyRequest#builder()}
     * </p>
     *
     * @param deletePermissionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePermissionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeletePermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeletePermissionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePermissionPolicyResponse> deletePermissionPolicy(
            Consumer<DeletePermissionPolicyRequest.Builder> deletePermissionPolicyRequest) {
        return deletePermissionPolicy(DeletePermissionPolicyRequest.builder().applyMutation(deletePermissionPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param deleteRegexPatternSetRequest
     * @return A Java Future containing the result of the DeleteRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException AWS WAF couldn’t perform the operation because your resource is being used
     *         by another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRegexPatternSetResponse> deleteRegexPatternSet(
            DeleteRegexPatternSetRequest deleteRegexPatternSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>RegexPatternSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param deleteRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException AWS WAF couldn’t perform the operation because your resource is being used
     *         by another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRegexPatternSetResponse> deleteRegexPatternSet(
            Consumer<DeleteRegexPatternSetRequest.Builder> deleteRegexPatternSetRequest) {
        return deleteRegexPatternSet(DeleteRegexPatternSetRequest.builder().applyMutation(deleteRegexPatternSetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param deleteRuleGroupRequest
     * @return A Java Future containing the result of the DeleteRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException AWS WAF couldn’t perform the operation because your resource is being used
     *         by another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleGroupResponse> deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRuleGroupRequest#builder()}
     * </p>
     *
     * @param deleteRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRuleGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException AWS WAF couldn’t perform the operation because your resource is being used
     *         by another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleGroupResponse> deleteRuleGroup(
            Consumer<DeleteRuleGroupRequest.Builder> deleteRuleGroupRequest) {
        return deleteRuleGroup(DeleteRuleGroupRequest.builder().applyMutation(deleteRuleGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>WebACL</a>.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     *
     * @param deleteWebAclRequest
     * @return A Java Future containing the result of the DeleteWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException AWS WAF couldn’t perform the operation because your resource is being used
     *         by another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWebAclResponse> deleteWebACL(DeleteWebAclRequest deleteWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>WebACL</a>.
     * </p>
     * <p>
     * You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <a>WebACL</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWebAclRequest#builder()}
     * </p>
     *
     * @param deleteWebAclRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafAssociatedItemException AWS WAF couldn’t perform the operation because your resource is being used
     *         by another resource or it’s associated with another resource.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DeleteWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DeleteWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWebAclResponse> deleteWebACL(Consumer<DeleteWebAclRequest.Builder> deleteWebAclRequest) {
        return deleteWebACL(DeleteWebAclRequest.builder().applyMutation(deleteWebAclRequest).build());
    }

    /**
     * <p>
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     * </p>
     *
     * @param describeManagedRuleGroupRequest
     * @return A Java Future containing the result of the DescribeManagedRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidResourceException AWS WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DescribeManagedRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeManagedRuleGroupResponse> describeManagedRuleGroup(
            DescribeManagedRuleGroupRequest describeManagedRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeManagedRuleGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeManagedRuleGroupRequest#builder()}
     * </p>
     *
     * @param describeManagedRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeManagedRuleGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeManagedRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidResourceException AWS WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DescribeManagedRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DescribeManagedRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeManagedRuleGroupResponse> describeManagedRuleGroup(
            Consumer<DescribeManagedRuleGroupRequest.Builder> describeManagedRuleGroupRequest) {
        return describeManagedRuleGroup(DescribeManagedRuleGroupRequest.builder().applyMutation(describeManagedRuleGroupRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates a Web ACL from a regional application resource. A regional application can be an Application Load
     * Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * For AWS CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To disassociate
     * a Web ACL, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For information,
     * see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">
     * UpdateDistribution</a>.
     * </p>
     *
     * @param disassociateWebAclRequest
     * @return A Java Future containing the result of the DisassociateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DisassociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DisassociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateWebAclResponse> disassociateWebACL(DisassociateWebAclRequest disassociateWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Web ACL from a regional application resource. A regional application can be an Application Load
     * Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * For AWS CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To disassociate
     * a Web ACL, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For information,
     * see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">
     * UpdateDistribution</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateWebAclRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateWebAclRequest#builder()}
     * </p>
     *
     * @param disassociateWebAclRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateWebACLRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.DisassociateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/DisassociateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateWebAclResponse> disassociateWebACL(
            Consumer<DisassociateWebAclRequest.Builder> disassociateWebAclRequest) {
        return disassociateWebACL(DisassociateWebAclRequest.builder().applyMutation(disassociateWebAclRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified <a>IPSet</a>.
     * </p>
     *
     * @param getIpSetRequest
     * @return A Java Future containing the result of the GetIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIpSetResponse> getIPSet(GetIpSetRequest getIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified <a>IPSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetIpSetRequest#builder()}
     * </p>
     *
     * @param getIpSetRequest
     *        A {@link Consumer} that will call methods on {@link GetIPSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIpSetResponse> getIPSet(Consumer<GetIpSetRequest.Builder> getIpSetRequest) {
        return getIPSet(GetIpSetRequest.builder().applyMutation(getIpSetRequest).build());
    }

    /**
     * <p>
     * Returns the <a>LoggingConfiguration</a> for the specified web ACL.
     * </p>
     *
     * @param getLoggingConfigurationRequest
     * @return A Java Future containing the result of the GetLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLoggingConfigurationResponse> getLoggingConfiguration(
            GetLoggingConfigurationRequest getLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <a>LoggingConfiguration</a> for the specified web ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param getLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLoggingConfigurationResponse> getLoggingConfiguration(
            Consumer<GetLoggingConfigurationRequest.Builder> getLoggingConfigurationRequest) {
        return getLoggingConfiguration(GetLoggingConfigurationRequest.builder().applyMutation(getLoggingConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Returns the IAM policy that is attached to the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     *
     * @param getPermissionPolicyRequest
     * @return A Java Future containing the result of the GetPermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPermissionPolicyResponse> getPermissionPolicy(
            GetPermissionPolicyRequest getPermissionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the IAM policy that is attached to the specified rule group.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPermissionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetPermissionPolicyRequest#builder()}
     * </p>
     *
     * @param getPermissionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPermissionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPermissionPolicyResponse> getPermissionPolicy(
            Consumer<GetPermissionPolicyRequest.Builder> getPermissionPolicyRequest) {
        return getPermissionPolicy(GetPermissionPolicyRequest.builder().applyMutation(getPermissionPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the keys that are currently blocked by a rate-based rule. The maximum number of managed keys that can
     * be blocked for a single rate-based rule is 10,000. If more than 10,000 addresses exceed the rate limit, those
     * with the highest rates are blocked.
     * </p>
     *
     * @param getRateBasedStatementManagedKeysRequest
     * @return A Java Future containing the result of the GetRateBasedStatementManagedKeys operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRateBasedStatementManagedKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRateBasedStatementManagedKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRateBasedStatementManagedKeysResponse> getRateBasedStatementManagedKeys(
            GetRateBasedStatementManagedKeysRequest getRateBasedStatementManagedKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the keys that are currently blocked by a rate-based rule. The maximum number of managed keys that can
     * be blocked for a single rate-based rule is 10,000. If more than 10,000 addresses exceed the rate limit, those
     * with the highest rates are blocked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRateBasedStatementManagedKeysRequest.Builder}
     * avoiding the need to create one manually via {@link GetRateBasedStatementManagedKeysRequest#builder()}
     * </p>
     *
     * @param getRateBasedStatementManagedKeysRequest
     *        A {@link Consumer} that will call methods on {@link GetRateBasedStatementManagedKeysRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRateBasedStatementManagedKeys operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRateBasedStatementManagedKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRateBasedStatementManagedKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRateBasedStatementManagedKeysResponse> getRateBasedStatementManagedKeys(
            Consumer<GetRateBasedStatementManagedKeysRequest.Builder> getRateBasedStatementManagedKeysRequest) {
        return getRateBasedStatementManagedKeys(GetRateBasedStatementManagedKeysRequest.builder()
                .applyMutation(getRateBasedStatementManagedKeysRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param getRegexPatternSetRequest
     * @return A Java Future containing the result of the GetRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRegexPatternSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegexPatternSetResponse> getRegexPatternSet(GetRegexPatternSetRequest getRegexPatternSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified <a>RegexPatternSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link GetRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param getRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link GetRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRegexPatternSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegexPatternSetResponse> getRegexPatternSet(
            Consumer<GetRegexPatternSetRequest.Builder> getRegexPatternSetRequest) {
        return getRegexPatternSet(GetRegexPatternSetRequest.builder().applyMutation(getRegexPatternSetRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param getRuleGroupRequest
     * @return A Java Future containing the result of the GetRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleGroupResponse> getRuleGroup(GetRuleGroupRequest getRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified <a>RuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuleGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetRuleGroupRequest#builder()}
     * </p>
     *
     * @param getRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetRuleGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleGroupResponse> getRuleGroup(Consumer<GetRuleGroupRequest.Builder> getRuleGroupRequest) {
        return getRuleGroup(GetRuleGroupRequest.builder().applyMutation(getRuleGroupRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about a specified number of requests--a sample--that AWS WAF randomly selects from
     * among the first 5,000 requests that your AWS resource received during a time range that you choose. You can
     * specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     * </p>
     * <p>
     * <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified.
     * However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time
     * range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the
     * actual period during which AWS WAF selected the requests in the sample.
     * </p>
     *
     * @param getSampledRequestsRequest
     * @return A Java Future containing the result of the GetSampledRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetSampledRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSampledRequestsResponse> getSampledRequests(GetSampledRequestsRequest getSampledRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about a specified number of requests--a sample--that AWS WAF randomly selects from
     * among the first 5,000 requests that your AWS resource received during a time range that you choose. You can
     * specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     * </p>
     * <p>
     * <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified.
     * However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time
     * range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the
     * actual period during which AWS WAF selected the requests in the sample.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSampledRequestsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSampledRequestsRequest#builder()}
     * </p>
     *
     * @param getSampledRequestsRequest
     *        A {@link Consumer} that will call methods on {@link GetSampledRequestsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSampledRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetSampledRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetSampledRequests" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSampledRequestsResponse> getSampledRequests(
            Consumer<GetSampledRequestsRequest.Builder> getSampledRequestsRequest) {
        return getSampledRequests(GetSampledRequestsRequest.builder().applyMutation(getSampledRequestsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified <a>WebACL</a>.
     * </p>
     *
     * @param getWebAclRequest
     * @return A Java Future containing the result of the GetWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWebAclResponse> getWebACL(GetWebAclRequest getWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified <a>WebACL</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link GetWebAclRequest#builder()}
     * </p>
     *
     * @param getWebAclRequest
     *        A {@link Consumer} that will call methods on {@link GetWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWebAclResponse> getWebACL(Consumer<GetWebAclRequest.Builder> getWebAclRequest) {
        return getWebACL(GetWebAclRequest.builder().applyMutation(getWebAclRequest).build());
    }

    /**
     * <p>
     * Retrieves the <a>WebACL</a> for the specified resource.
     * </p>
     *
     * @param getWebAclForResourceRequest
     * @return A Java Future containing the result of the GetWebACLForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetWebACLForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWebAclForResourceResponse> getWebACLForResource(
            GetWebAclForResourceRequest getWebAclForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <a>WebACL</a> for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWebAclForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetWebAclForResourceRequest#builder()}
     * </p>
     *
     * @param getWebAclForResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetWebACLForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWebACLForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.GetWebACLForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWebAclForResourceResponse> getWebACLForResource(
            Consumer<GetWebAclForResourceRequest.Builder> getWebAclForResourceRequest) {
        return getWebACLForResource(GetWebAclForResourceRequest.builder().applyMutation(getWebAclForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all AWS Managed
     * Rules rule groups and the AWS Marketplace managed rule groups that you're subscribed to.
     * </p>
     *
     * @param listAvailableManagedRuleGroupsRequest
     * @return A Java Future containing the result of the ListAvailableManagedRuleGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListAvailableManagedRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableManagedRuleGroupsResponse> listAvailableManagedRuleGroups(
            ListAvailableManagedRuleGroupsRequest listAvailableManagedRuleGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all AWS Managed
     * Rules rule groups and the AWS Marketplace managed rule groups that you're subscribed to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableManagedRuleGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableManagedRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listAvailableManagedRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailableManagedRuleGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAvailableManagedRuleGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListAvailableManagedRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListAvailableManagedRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableManagedRuleGroupsResponse> listAvailableManagedRuleGroups(
            Consumer<ListAvailableManagedRuleGroupsRequest.Builder> listAvailableManagedRuleGroupsRequest) {
        return listAvailableManagedRuleGroups(ListAvailableManagedRuleGroupsRequest.builder()
                .applyMutation(listAvailableManagedRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of <a>IPSetSummary</a> objects for the IP sets that you manage.
     * </p>
     *
     * @param listIpSetsRequest
     * @return A Java Future containing the result of the ListIPSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIpSetsResponse> listIPSets(ListIpSetsRequest listIpSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of <a>IPSetSummary</a> objects for the IP sets that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIpSetsRequest#builder()}
     * </p>
     *
     * @param listIpSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListIPSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIPSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListIPSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIpSetsResponse> listIPSets(Consumer<ListIpSetsRequest.Builder> listIpSetsRequest) {
        return listIPSets(ListIpSetsRequest.builder().applyMutation(listIpSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of your <a>LoggingConfiguration</a> objects.
     * </p>
     *
     * @param listLoggingConfigurationsRequest
     * @return A Java Future containing the result of the ListLoggingConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListLoggingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListLoggingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLoggingConfigurationsResponse> listLoggingConfigurations(
            ListLoggingConfigurationsRequest listLoggingConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of your <a>LoggingConfiguration</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLoggingConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLoggingConfigurationsRequest#builder()}
     * </p>
     *
     * @param listLoggingConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListLoggingConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLoggingConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListLoggingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListLoggingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLoggingConfigurationsResponse> listLoggingConfigurations(
            Consumer<ListLoggingConfigurationsRequest.Builder> listLoggingConfigurationsRequest) {
        return listLoggingConfigurations(ListLoggingConfigurationsRequest.builder()
                .applyMutation(listLoggingConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of <a>RegexPatternSetSummary</a> objects for the regex pattern sets that you manage.
     * </p>
     *
     * @param listRegexPatternSetsRequest
     * @return A Java Future containing the result of the ListRegexPatternSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListRegexPatternSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRegexPatternSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRegexPatternSetsResponse> listRegexPatternSets(
            ListRegexPatternSetsRequest listRegexPatternSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of <a>RegexPatternSetSummary</a> objects for the regex pattern sets that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegexPatternSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRegexPatternSetsRequest#builder()}
     * </p>
     *
     * @param listRegexPatternSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListRegexPatternSetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRegexPatternSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListRegexPatternSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRegexPatternSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRegexPatternSetsResponse> listRegexPatternSets(
            Consumer<ListRegexPatternSetsRequest.Builder> listRegexPatternSetsRequest) {
        return listRegexPatternSets(ListRegexPatternSetsRequest.builder().applyMutation(listRegexPatternSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the
     * specified web ACL. If you want the list of AWS CloudFront resources, use the AWS CloudFront call
     * <code>ListDistributionsByWebACLId</code>.
     * </p>
     *
     * @param listResourcesForWebAclRequest
     * @return A Java Future containing the result of the ListResourcesForWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListResourcesForWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListResourcesForWebACL" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListResourcesForWebAclResponse> listResourcesForWebACL(
            ListResourcesForWebAclRequest listResourcesForWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the
     * specified web ACL. If you want the list of AWS CloudFront resources, use the AWS CloudFront call
     * <code>ListDistributionsByWebACLId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesForWebAclRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourcesForWebAclRequest#builder()}
     * </p>
     *
     * @param listResourcesForWebAclRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesForWebACLRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResourcesForWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListResourcesForWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListResourcesForWebACL" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListResourcesForWebAclResponse> listResourcesForWebACL(
            Consumer<ListResourcesForWebAclRequest.Builder> listResourcesForWebAclRequest) {
        return listResourcesForWebACL(ListResourcesForWebAclRequest.builder().applyMutation(listResourcesForWebAclRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves an array of <a>RuleGroupSummary</a> objects for the rule groups that you manage.
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return A Java Future containing the result of the ListRuleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRuleGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRuleGroupsResponse> listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of <a>RuleGroupSummary</a> objects for the rule groups that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListRuleGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRuleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListRuleGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRuleGroupsResponse> listRuleGroups(Consumer<ListRuleGroupsRequest.Builder> listRuleGroupsRequest) {
        return listRuleGroups(ListRuleGroupsRequest.builder().applyMutation(listRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the <a>TagInfoForResource</a> for the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS
     * resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the AWS resources that you manage through AWS WAF: web ACLs, rule groups, IP sets, and regex pattern
     * sets. You can't manage or view tags through the AWS WAF console.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <a>TagInfoForResource</a> for the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS
     * resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the AWS resources that you manage through AWS WAF: web ACLs, rule groups, IP sets, and regex pattern
     * sets. You can't manage or view tags through the AWS WAF console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves an array of <a>WebACLSummary</a> objects for the web ACLs that you manage.
     * </p>
     *
     * @param listWebAcLsRequest
     * @return A Java Future containing the result of the ListWebACLs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListWebACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListWebACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWebAcLsResponse> listWebACLs(ListWebAcLsRequest listWebAcLsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an array of <a>WebACLSummary</a> objects for the web ACLs that you manage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebAcLsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWebAcLsRequest#builder()}
     * </p>
     *
     * @param listWebAcLsRequest
     *        A {@link Consumer} that will call methods on {@link ListWebACLsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWebACLs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.ListWebACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/ListWebACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWebAcLsResponse> listWebACLs(Consumer<ListWebAcLsRequest.Builder> listWebAcLsRequest) {
        return listWebACLs(ListWebAcLsRequest.builder().applyMutation(listWebAcLsRequest).build());
    }

    /**
     * <p>
     * Enables the specified <a>LoggingConfiguration</a>, to start logging from a web ACL, according to the
     * configuration provided.
     * </p>
     * <p>
     * You can access information about all traffic that AWS WAF inspects using the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create an Amazon Kinesis Data Firehose.
     * </p>
     * <p>
     * Create the data firehose with a PUT source and in the Region that you are operating. If you are capturing logs
     * for Amazon CloudFront, always create the firehose in US East (N. Virginia).
     * </p>
     * <p>
     * Give the data firehose a name that starts with the prefix <code>aws-waf-logs-</code>. For example,
     * <code>aws-waf-logs-us-east-2-analytics</code>.
     * </p>
     * <note>
     * <p>
     * Do not create the data firehose using a <code>Kinesis stream</code> as your source.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Associate that firehose to your web ACL using a <code>PutLoggingConfiguration</code> request.
     * </p>
     * </li>
     * </ol>
     * <p>
     * When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, AWS WAF will create a
     * service linked role with the necessary permissions to write logs to the Amazon Kinesis Data Firehose. For more
     * information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL
     * Traffic Information</a> in the <i>AWS WAF Developer Guide</i>.
     * </p>
     *
     * @param putLoggingConfigurationRequest
     * @return A Java Future containing the result of the PutLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafServiceLinkedRoleErrorException AWS WAF is not able to access the service linked role. This can be
     *         caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role
     *         for about 20 seconds. Please try your request again. The service linked role can also be locked by a
     *         previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If
     *         you recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the
     *         request again. If you receive this same exception again, you will have to wait additional time until the
     *         role is unlocked.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingConfigurationResponse> putLoggingConfiguration(
            PutLoggingConfigurationRequest putLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified <a>LoggingConfiguration</a>, to start logging from a web ACL, according to the
     * configuration provided.
     * </p>
     * <p>
     * You can access information about all traffic that AWS WAF inspects using the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Create an Amazon Kinesis Data Firehose.
     * </p>
     * <p>
     * Create the data firehose with a PUT source and in the Region that you are operating. If you are capturing logs
     * for Amazon CloudFront, always create the firehose in US East (N. Virginia).
     * </p>
     * <p>
     * Give the data firehose a name that starts with the prefix <code>aws-waf-logs-</code>. For example,
     * <code>aws-waf-logs-us-east-2-analytics</code>.
     * </p>
     * <note>
     * <p>
     * Do not create the data firehose using a <code>Kinesis stream</code> as your source.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Associate that firehose to your web ACL using a <code>PutLoggingConfiguration</code> request.
     * </p>
     * </li>
     * </ol>
     * <p>
     * When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, AWS WAF will create a
     * service linked role with the necessary permissions to write logs to the Amazon Kinesis Data Firehose. For more
     * information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL
     * Traffic Information</a> in the <i>AWS WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param putLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutLoggingConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafServiceLinkedRoleErrorException AWS WAF is not able to access the service linked role. This can be
     *         caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role
     *         for about 20 seconds. Please try your request again. The service linked role can also be locked by a
     *         previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If
     *         you recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the
     *         request again. If you receive this same exception again, you will have to wait additional time until the
     *         role is unlocked.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutLoggingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutLoggingConfigurationResponse> putLoggingConfiguration(
            Consumer<PutLoggingConfigurationRequest.Builder> putLoggingConfigurationRequest) {
        return putLoggingConfiguration(PutLoggingConfigurationRequest.builder().applyMutation(putLoggingConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     * <p>
     * This action is subject to the following restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can attach only one policy with each <code>PutPermissionPolicy</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN in the request must be a valid WAF <a>RuleGroup</a> ARN and the rule group must exist in the same region.
     * </p>
     * </li>
     * <li>
     * <p>
     * The user making the request must be the owner of the rule group.
     * </p>
     * </li>
     * </ul>
     *
     * @param putPermissionPolicyRequest
     * @return A Java Future containing the result of the PutPermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidPermissionPolicyException The operation failed because the specified policy isn't in the
     *         proper format. </p>
     *         <p>
     *         The policy specifications must conform to the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must include specifications for <code>Effect</code>, <code>Action</code>, and
     *         <code>Principal</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Effect</code> must specify <code>Allow</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and
     *         <code>wafv2:PutFirewallManagerRuleGroups</code>. AWS WAF rejects any extra actions or wildcard actions in
     *         the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must not include a <code>Resource</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPermissionPolicyResponse> putPermissionPolicy(
            PutPermissionPolicyRequest putPermissionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.
     * </p>
     * <p>
     * You must be the owner of the rule group to perform this operation.
     * </p>
     * <p>
     * This action is subject to the following restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can attach only one policy with each <code>PutPermissionPolicy</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN in the request must be a valid WAF <a>RuleGroup</a> ARN and the rule group must exist in the same region.
     * </p>
     * </li>
     * <li>
     * <p>
     * The user making the request must be the owner of the rule group.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPermissionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutPermissionPolicyRequest#builder()}
     * </p>
     *
     * @param putPermissionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutPermissionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutPermissionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafInvalidPermissionPolicyException The operation failed because the specified policy isn't in the
     *         proper format. </p>
     *         <p>
     *         The policy specifications must conform to the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must include specifications for <code>Effect</code>, <code>Action</code>, and
     *         <code>Principal</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Effect</code> must specify <code>Allow</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and
     *         <code>wafv2:PutFirewallManagerRuleGroups</code>. AWS WAF rejects any extra actions or wildcard actions in
     *         the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The policy must not include a <code>Resource</code> parameter.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.PutPermissionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/PutPermissionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutPermissionPolicyResponse> putPermissionPolicy(
            Consumer<PutPermissionPolicyRequest.Builder> putPermissionPolicyRequest) {
        return putPermissionPolicy(PutPermissionPolicyRequest.builder().applyMutation(putPermissionPolicyRequest).build());
    }

    /**
     * <p>
     * Associates tags with the specified AWS resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for
     * a resource.
     * </p>
     * <p>
     * You can tag the AWS resources that you manage through AWS WAF: web ACLs, rule groups, IP sets, and regex pattern
     * sets. You can't manage or view tags through the AWS WAF console.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates tags with the specified AWS resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for
     * a resource.
     * </p>
     * <p>
     * You can tag the AWS resources that you manage through AWS WAF: web ACLs, rule groups, IP sets, and regex pattern
     * sets. You can't manage or view tags through the AWS WAF console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates tags from an AWS resource. Tags are key:value pairs that you can associate with AWS resources. For
     * example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags
     * to add to each container. You can add up to 50 tags to each AWS resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates tags from an AWS resource. Tags are key:value pairs that you can associate with AWS resources. For
     * example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags
     * to add to each container. You can add up to 50 tags to each AWS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafTagOperationException An error occurred during the tagging operation. Retry your request.</li>
     *         <li>WafTagOperationInternalErrorException AWS WAF couldn’t perform your tagging operation because of an
     *         internal error. Retry your request.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified <a>IPSet</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces any IP address specifications that you already have in the IP set with the
     * ones that you provide to this call. If you want to add to or modify the addresses that are already in the IP set,
     * retrieve those by calling <a>GetIPSet</a>, update them, and provide the complete updated array of IP addresses to
     * this call.
     * </p>
     * </note>
     *
     * @param updateIpSetRequest
     * @return A Java Future containing the result of the UpdateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIpSetResponse> updateIPSet(UpdateIpSetRequest updateIpSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified <a>IPSet</a>.
     * </p>
     * <note>
     * <p>
     * This operation completely replaces any IP address specifications that you already have in the IP set with the
     * ones that you provide to this call. If you want to add to or modify the addresses that are already in the IP set,
     * retrieve those by calling <a>GetIPSet</a>, update them, and provide the complete updated array of IP addresses to
     * this call.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIpSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIpSetRequest#builder()}
     * </p>
     *
     * @param updateIpSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIPSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateIPSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateIPSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIpSetResponse> updateIPSet(Consumer<UpdateIpSetRequest.Builder> updateIpSetRequest) {
        return updateIPSet(UpdateIpSetRequest.builder().applyMutation(updateIpSetRequest).build());
    }

    /**
     * <p>
     * Updates the specified <a>RegexPatternSet</a>.
     * </p>
     *
     * @param updateRegexPatternSetRequest
     * @return A Java Future containing the result of the UpdateRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRegexPatternSetResponse> updateRegexPatternSet(
            UpdateRegexPatternSetRequest updateRegexPatternSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified <a>RegexPatternSet</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRegexPatternSetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRegexPatternSetRequest#builder()}
     * </p>
     *
     * @param updateRegexPatternSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRegexPatternSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRegexPatternSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateRegexPatternSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRegexPatternSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRegexPatternSetResponse> updateRegexPatternSet(
            Consumer<UpdateRegexPatternSetRequest.Builder> updateRegexPatternSetRequest) {
        return updateRegexPatternSet(UpdateRegexPatternSetRequest.builder().applyMutation(updateRegexPatternSetRequest).build());
    }

    /**
     * <p>
     * Updates the specified <a>RuleGroup</a>.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     *
     * @param updateRuleGroupRequest
     * @return A Java Future containing the result of the UpdateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRuleGroupResponse> updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified <a>RuleGroup</a>.
     * </p>
     * <p>
     * A rule group defines a collection of rules to inspect and control web requests that you can use in a
     * <a>WebACL</a>. When you create a rule group, you define an immutable capacity limit. If you update a rule group,
     * you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity
     * requirements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRuleGroupRequest#builder()}
     * </p>
     *
     * @param updateRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateRuleGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRuleGroupResponse> updateRuleGroup(
            Consumer<UpdateRuleGroupRequest.Builder> updateRuleGroupRequest) {
        return updateRuleGroup(UpdateRuleGroupRequest.builder().applyMutation(updateRuleGroupRequest).build());
    }

    /**
     * <p>
     * Updates the specified <a>WebACL</a>.
     * </p>
     * <p>
     * A Web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the Web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a Web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * Web ACL with one or more AWS resources to protect. The resources can be Amazon CloudFront, an Amazon API Gateway
     * REST API, an Application Load Balancer, or an AWS AppSync GraphQL API.
     * </p>
     *
     * @param updateWebAclRequest
     * @return A Java Future containing the result of the UpdateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException AWS WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWebAclResponse> updateWebACL(UpdateWebAclRequest updateWebAclRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified <a>WebACL</a>.
     * </p>
     * <p>
     * A Web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action
     * defined (allow, block, or count) for requests that match the statement of the rule. In the Web ACL, you assign a
     * default action to take (allow, block) for any request that does not match any of the rules. The rules in a Web
     * ACL can be a combination of the types <a>Rule</a>, <a>RuleGroup</a>, and managed rule group. You can associate a
     * Web ACL with one or more AWS resources to protect. The resources can be Amazon CloudFront, an Amazon API Gateway
     * REST API, an Application Load Balancer, or an AWS AppSync GraphQL API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWebAclRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWebAclRequest#builder()}
     * </p>
     *
     * @param updateWebAclRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWebACLRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWebACL operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>WafInternalErrorException Your request is valid, but AWS WAF couldn’t perform the operation because
     *         of a system problem. Retry your request.</li>
     *         <li>WafInvalidParameterException The operation failed because AWS WAF didn't recognize a parameter in the
     *         request. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an invalid parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types
     *         available at <a>DefaultAction</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource with which a Web ACL
     *         cannot be associated.
     *         </p>
     *         </li></li>
     *         <li>WafNonexistentItemException AWS WAF couldn’t perform the operation because your resource doesn’t
     *         exist.</li>
     *         <li>WafDuplicateItemException AWS WAF couldn’t perform the operation because the resource that you tried
     *         to save is a duplicate of an existing one.</li>
     *         <li>WafOptimisticLockException AWS WAF couldn’t save your changes because you tried to update or delete a
     *         resource that has changed since you last retrieved it. Get the resource again, make any changes you need
     *         to make to the new copy, and retry your operation.</li>
     *         <li>WafLimitsExceededException AWS WAF couldn’t perform the operation because you exceeded your resource
     *         limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an AWS
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF
     *         Developer Guide</i>.</li>
     *         <li>WafInvalidResourceException AWS WAF couldn’t perform the operation because the resource that you
     *         requested isn’t valid. Check the resource, and try again.</li>
     *         <li>WafUnavailableEntityException AWS WAF couldn’t retrieve the resource that you requested. Retry your
     *         request.</li>
     *         <li>WafSubscriptionNotFoundException You tried to use a managed rule group that's available by
     *         subscription, but you aren't subscribed to it yet.</li>
     *         <li>WafInvalidOperationException The operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Wafv2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Wafv2AsyncClient.UpdateWebACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWebAclResponse> updateWebACL(Consumer<UpdateWebAclRequest.Builder> updateWebAclRequest) {
        return updateWebACL(UpdateWebAclRequest.builder().applyMutation(updateWebAclRequest).build());
    }
}
