/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpSetRequest extends Wafv2Request implements
        ToCopyableBuilder<CreateIpSetRequest.Builder, CreateIpSetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateIpSetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(CreateIpSetRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateIpSetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IP_ADDRESS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IPAddressVersion").getter(getter(CreateIpSetRequest::ipAddressVersionAsString))
            .setter(setter(Builder::ipAddressVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddressVersion").build()).build();

    private static final SdkField<List<String>> ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Addresses")
            .getter(getter(CreateIpSetRequest::addresses))
            .setter(setter(Builder::addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateIpSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCOPE_FIELD,
            DESCRIPTION_FIELD, IP_ADDRESS_VERSION_FIELD, ADDRESSES_FIELD, TAGS_FIELD));

    private final String name;

    private final String scope;

    private final String description;

    private final String ipAddressVersion;

    private final List<String> addresses;

    private final List<Tag> tags;

    private CreateIpSetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scope = builder.scope;
        this.description = builder.description;
        this.ipAddressVersion = builder.ipAddressVersion;
        this.addresses = builder.addresses;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
     * </p>
     * 
     * @return The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL
     *         API. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
     * application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
     *         application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL
     *         API. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * A description of the IP set that helps with identification.
     * </p>
     * 
     * @return A description of the IP set that helps with identification.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specify IPV4 or IPV6.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressVersion}
     * will return {@link IPAddressVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipAddressVersionAsString}.
     * </p>
     * 
     * @return Specify IPV4 or IPV6.
     * @see IPAddressVersion
     */
    public final IPAddressVersion ipAddressVersion() {
        return IPAddressVersion.fromValue(ipAddressVersion);
    }

    /**
     * <p>
     * Specify IPV4 or IPV6.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressVersion}
     * will return {@link IPAddressVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipAddressVersionAsString}.
     * </p>
     * 
     * @return Specify IPV4 or IPV6.
     * @see IPAddressVersion
     */
    public final String ipAddressVersionAsString() {
        return ipAddressVersion;
    }

    /**
     * Returns true if the Addresses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAddresses() {
        return addresses != null && !(addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless
     * Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for /0.
     * </p>
     * <p>
     * Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify
     * <code>192.0.2.44/32</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to
     * 192.0.2.255, specify <code>192.0.2.0/24</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure AWS WAF to allow, block, or count requests that originated from the IP address
     * 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To configure AWS WAF to allow, block, or count requests that originated from IP addresses
     * 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
     * <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about CIDR notation, see the Wikipedia entry <a
     * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless
     *         Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44,
     *         specify <code>192.0.2.44/32</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0
     *         to 192.0.2.255, specify <code>192.0.2.0/24</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure AWS WAF to allow, block, or count requests that originated from the IP address
     *         1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To configure AWS WAF to allow, block, or count requests that originated from IP addresses
     *         1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
     *         <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about CIDR notation, see the Wikipedia entry <a
     *         href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
     */
    public final List<String> addresses() {
        return addresses;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddresses() ? addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpSetRequest)) {
            return false;
        }
        CreateIpSetRequest other = (CreateIpSetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(ipAddressVersionAsString(), other.ipAddressVersionAsString())
                && hasAddresses() == other.hasAddresses() && Objects.equals(addresses(), other.addresses())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpSetRequest").add("Name", name()).add("Scope", scopeAsString())
                .add("Description", description()).add("IPAddressVersion", ipAddressVersionAsString())
                .add("Addresses", hasAddresses() ? addresses() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IPAddressVersion":
            return Optional.ofNullable(clazz.cast(ipAddressVersionAsString()));
        case "Addresses":
            return Optional.ofNullable(clazz.cast(addresses()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpSetRequest, T> g) {
        return obj -> g.apply((CreateIpSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpSetRequest> {
        /**
         * <p>
         * The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
         * </p>
         * 
         * @param name
         *        The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
         *        application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL
         *        API. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
         * application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL API.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for an AWS CloudFront distribution or for a regional application. A regional
         *        application can be an Application Load Balancer (ALB), an API Gateway REST API, or an AppSync GraphQL
         *        API. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * A description of the IP set that helps with identification.
         * </p>
         * 
         * @param description
         *        A description of the IP set that helps with identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specify IPV4 or IPV6.
         * </p>
         * 
         * @param ipAddressVersion
         *        Specify IPV4 or IPV6.
         * @see IPAddressVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressVersion
         */
        Builder ipAddressVersion(String ipAddressVersion);

        /**
         * <p>
         * Specify IPV4 or IPV6.
         * </p>
         * 
         * @param ipAddressVersion
         *        Specify IPV4 or IPV6.
         * @see IPAddressVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressVersion
         */
        Builder ipAddressVersion(IPAddressVersion ipAddressVersion);

        /**
         * <p>
         * Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless
         * Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for /0.
         * </p>
         * <p>
         * Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44,
         * specify <code>192.0.2.44/32</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to
         * 192.0.2.255, specify <code>192.0.2.0/24</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from the IP address
         * 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from IP addresses
         * 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
         * <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a
         * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
         * </p>
         * 
         * @param addresses
         *        Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in
         *        Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except
         *        for /0. </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from the IP address
         *        192.0.2.44, specify <code>192.0.2.44/32</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from IP addresses from
         *        192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from the IP address
         *        1111:0000:0000:0000:0000:0000:0000:0111, specify
         *        <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from IP addresses
         *        1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
         *        <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about CIDR notation, see the Wikipedia entry <a
         *        href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain
         *        Routing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<String> addresses);

        /**
         * <p>
         * Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless
         * Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for /0.
         * </p>
         * <p>
         * Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44,
         * specify <code>192.0.2.44/32</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to
         * 192.0.2.255, specify <code>192.0.2.0/24</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from the IP address
         * 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To configure AWS WAF to allow, block, or count requests that originated from IP addresses
         * 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
         * <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about CIDR notation, see the Wikipedia entry <a
         * href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.
         * </p>
         * 
         * @param addresses
         *        Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in
         *        Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except
         *        for /0. </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from the IP address
         *        192.0.2.44, specify <code>192.0.2.44/32</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from IP addresses from
         *        192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from the IP address
         *        1111:0000:0000:0000:0000:0000:0000:0111, specify
         *        <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To configure AWS WAF to allow, block, or count requests that originated from IP addresses
         *        1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
         *        <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about CIDR notation, see the Wikipedia entry <a
         *        href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain
         *        Routing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(String... addresses);

        /**
         * <p>
         * An array of key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        An array of key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        An array of key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key:value pairs to associate with the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String name;

        private String scope;

        private String description;

        private String ipAddressVersion;

        private List<String> addresses = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpSetRequest model) {
            super(model);
            name(model.name);
            scope(model.scope);
            description(model.description);
            ipAddressVersion(model.ipAddressVersion);
            addresses(model.addresses);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getIpAddressVersion() {
            return ipAddressVersion;
        }

        @Override
        public final Builder ipAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
            return this;
        }

        @Override
        public final Builder ipAddressVersion(IPAddressVersion ipAddressVersion) {
            this.ipAddressVersion(ipAddressVersion == null ? null : ipAddressVersion.toString());
            return this;
        }

        public final void setIpAddressVersion(String ipAddressVersion) {
            this.ipAddressVersion = ipAddressVersion;
        }

        public final Collection<String> getAddresses() {
            if (addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return addresses;
        }

        @Override
        public final Builder addresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(String... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        public final void setAddresses(Collection<String> addresses) {
            this.addresses = IPAddressesCopier.copy(addresses);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpSetRequest build() {
            return new CreateIpSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
