/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In a <a>WebACL</a>, this is the action that you want AWS WAF to perform when a web request doesn't match any of the
 * rules in the <code>WebACL</code>. The default action must be a terminating action, so you can't use count.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultAction implements SdkPojo, Serializable, ToCopyableBuilder<DefaultAction.Builder, DefaultAction> {
    private static final SdkField<BlockAction> BLOCK_FIELD = SdkField.<BlockAction> builder(MarshallingType.SDK_POJO)
            .memberName("Block").getter(getter(DefaultAction::block)).setter(setter(Builder::block))
            .constructor(BlockAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()).build();

    private static final SdkField<AllowAction> ALLOW_FIELD = SdkField.<AllowAction> builder(MarshallingType.SDK_POJO)
            .memberName("Allow").getter(getter(DefaultAction::allow)).setter(setter(Builder::allow))
            .constructor(AllowAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_FIELD, ALLOW_FIELD));

    private static final long serialVersionUID = 1L;

    private final BlockAction block;

    private final AllowAction allow;

    private DefaultAction(BuilderImpl builder) {
        this.block = builder.block;
        this.allow = builder.allow;
    }

    /**
     * <p>
     * Specifies that AWS WAF should block requests by default.
     * </p>
     * 
     * @return Specifies that AWS WAF should block requests by default.
     */
    public final BlockAction block() {
        return block;
    }

    /**
     * <p>
     * Specifies that AWS WAF should allow requests by default.
     * </p>
     * 
     * @return Specifies that AWS WAF should allow requests by default.
     */
    public final AllowAction allow() {
        return allow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(block());
        hashCode = 31 * hashCode + Objects.hashCode(allow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultAction)) {
            return false;
        }
        DefaultAction other = (DefaultAction) obj;
        return Objects.equals(block(), other.block()) && Objects.equals(allow(), other.allow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultAction").add("Block", block()).add("Allow", allow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        case "Allow":
            return Optional.ofNullable(clazz.cast(allow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultAction, T> g) {
        return obj -> g.apply((DefaultAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultAction> {
        /**
         * <p>
         * Specifies that AWS WAF should block requests by default.
         * </p>
         * 
         * @param block
         *        Specifies that AWS WAF should block requests by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(BlockAction block);

        /**
         * <p>
         * Specifies that AWS WAF should block requests by default.
         * </p>
         * This is a convenience that creates an instance of the {@link BlockAction.Builder} avoiding the need to create
         * one manually via {@link BlockAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlockAction.Builder#build()} is called immediately and its result
         * is passed to {@link #block(BlockAction)}.
         * 
         * @param block
         *        a consumer that will call methods on {@link BlockAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #block(BlockAction)
         */
        default Builder block(Consumer<BlockAction.Builder> block) {
            return block(BlockAction.builder().applyMutation(block).build());
        }

        /**
         * <p>
         * Specifies that AWS WAF should allow requests by default.
         * </p>
         * 
         * @param allow
         *        Specifies that AWS WAF should allow requests by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allow(AllowAction allow);

        /**
         * <p>
         * Specifies that AWS WAF should allow requests by default.
         * </p>
         * This is a convenience that creates an instance of the {@link AllowAction.Builder} avoiding the need to create
         * one manually via {@link AllowAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link AllowAction.Builder#build()} is called immediately and its result
         * is passed to {@link #allow(AllowAction)}.
         * 
         * @param allow
         *        a consumer that will call methods on {@link AllowAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allow(AllowAction)
         */
        default Builder allow(Consumer<AllowAction.Builder> allow) {
            return allow(AllowAction.builder().applyMutation(allow).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlockAction block;

        private AllowAction allow;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultAction model) {
            block(model.block);
            allow(model.allow);
        }

        public final BlockAction.Builder getBlock() {
            return block != null ? block.toBuilder() : null;
        }

        @Override
        public final Builder block(BlockAction block) {
            this.block = block;
            return this;
        }

        public final void setBlock(BlockAction.BuilderImpl block) {
            this.block = block != null ? block.build() : null;
        }

        public final AllowAction.Builder getAllow() {
            return allow != null ? allow.toBuilder() : null;
        }

        @Override
        public final Builder allow(AllowAction allow) {
            this.allow = allow;
            return this;
        }

        public final void setAllow(AllowAction.BuilderImpl allow) {
            this.allow = allow != null ? allow.build() : null;
        }

        @Override
        public DefaultAction build() {
            return new DefaultAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
