/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule statement used to identify web requests based on country of origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoMatchStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<GeoMatchStatement.Builder, GeoMatchStatement> {
    private static final SdkField<List<String>> COUNTRY_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CountryCodes")
            .getter(getter(GeoMatchStatement::countryCodesAsStrings))
            .setter(setter(Builder::countryCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ForwardedIPConfig> FORWARDED_IP_CONFIG_FIELD = SdkField
            .<ForwardedIPConfig> builder(MarshallingType.SDK_POJO).memberName("ForwardedIPConfig")
            .getter(getter(GeoMatchStatement::forwardedIPConfig)).setter(setter(Builder::forwardedIPConfig))
            .constructor(ForwardedIPConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedIPConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODES_FIELD,
            FORWARDED_IP_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> countryCodes;

    private final ForwardedIPConfig forwardedIPConfig;

    private GeoMatchStatement(BuilderImpl builder) {
        this.countryCodes = builder.countryCodes;
        this.forwardedIPConfig = builder.forwardedIPConfig;
    }

    /**
     * <p>
     * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country ISO
     * codes of the ISO 3166 international standard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCountryCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
     *         country ISO codes of the ISO 3166 international standard.
     */
    public final List<CountryCode> countryCodes() {
        return CountryCodesCopier.copyStringToEnum(countryCodes);
    }

    /**
     * Returns true if the CountryCodes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCountryCodes() {
        return countryCodes != null && !(countryCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country ISO
     * codes of the ISO 3166 international standard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCountryCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
     *         country ISO codes of the ISO 3166 international standard.
     */
    public final List<String> countryCodesAsStrings() {
        return countryCodes;
    }

    /**
     * <p>
     * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address
     * that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can
     * specify any header name.
     * </p>
     * <note>
     * <p>
     * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
     * </p>
     * </note>
     * 
     * @return The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP
     *         address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header,
     *         but you can specify any header name. </p> <note>
     *         <p>
     *         If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request
     *         at all.
     *         </p>
     */
    public final ForwardedIPConfig forwardedIPConfig() {
        return forwardedIPConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCountryCodes() ? countryCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(forwardedIPConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchStatement)) {
            return false;
        }
        GeoMatchStatement other = (GeoMatchStatement) obj;
        return hasCountryCodes() == other.hasCountryCodes()
                && Objects.equals(countryCodesAsStrings(), other.countryCodesAsStrings())
                && Objects.equals(forwardedIPConfig(), other.forwardedIPConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeoMatchStatement").add("CountryCodes", hasCountryCodes() ? countryCodesAsStrings() : null)
                .add("ForwardedIPConfig", forwardedIPConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountryCodes":
            return Optional.ofNullable(clazz.cast(countryCodesAsStrings()));
        case "ForwardedIPConfig":
            return Optional.ofNullable(clazz.cast(forwardedIPConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchStatement, T> g) {
        return obj -> g.apply((GeoMatchStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoMatchStatement> {
        /**
         * <p>
         * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country
         * ISO codes of the ISO 3166 international standard.
         * </p>
         * 
         * @param countryCodes
         *        An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
         *        country ISO codes of the ISO 3166 international standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCodesWithStrings(Collection<String> countryCodes);

        /**
         * <p>
         * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country
         * ISO codes of the ISO 3166 international standard.
         * </p>
         * 
         * @param countryCodes
         *        An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
         *        country ISO codes of the ISO 3166 international standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCodesWithStrings(String... countryCodes);

        /**
         * <p>
         * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country
         * ISO codes of the ISO 3166 international standard.
         * </p>
         * 
         * @param countryCodes
         *        An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
         *        country ISO codes of the ISO 3166 international standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCodes(Collection<CountryCode> countryCodes);

        /**
         * <p>
         * An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2 country
         * ISO codes of the ISO 3166 international standard.
         * </p>
         * 
         * @param countryCodes
         *        An array of two-character country codes, for example, <code>[ "US", "CN" ]</code>, from the alpha-2
         *        country ISO codes of the ISO 3166 international standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCodes(CountryCode... countryCodes);

        /**
         * <p>
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP
         * address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but
         * you can specify any header name.
         * </p>
         * <note>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at
         * all.
         * </p>
         * </note>
         * 
         * @param forwardedIPConfig
         *        The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the
         *        IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF)
         *        header, but you can specify any header name. </p> <note>
         *        <p>
         *        If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web
         *        request at all.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardedIPConfig(ForwardedIPConfig forwardedIPConfig);

        /**
         * <p>
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP
         * address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but
         * you can specify any header name.
         * </p>
         * <note>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at
         * all.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link ForwardedIPConfig.Builder} avoiding the
         * need to create one manually via {@link ForwardedIPConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ForwardedIPConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #forwardedIPConfig(ForwardedIPConfig)}.
         * 
         * @param forwardedIPConfig
         *        a consumer that will call methods on {@link ForwardedIPConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forwardedIPConfig(ForwardedIPConfig)
         */
        default Builder forwardedIPConfig(Consumer<ForwardedIPConfig.Builder> forwardedIPConfig) {
            return forwardedIPConfig(ForwardedIPConfig.builder().applyMutation(forwardedIPConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> countryCodes = DefaultSdkAutoConstructList.getInstance();

        private ForwardedIPConfig forwardedIPConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchStatement model) {
            countryCodesWithStrings(model.countryCodes);
            forwardedIPConfig(model.forwardedIPConfig);
        }

        public final Collection<String> getCountryCodes() {
            if (countryCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return countryCodes;
        }

        @Override
        public final Builder countryCodesWithStrings(Collection<String> countryCodes) {
            this.countryCodes = CountryCodesCopier.copy(countryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countryCodesWithStrings(String... countryCodes) {
            countryCodesWithStrings(Arrays.asList(countryCodes));
            return this;
        }

        @Override
        public final Builder countryCodes(Collection<CountryCode> countryCodes) {
            this.countryCodes = CountryCodesCopier.copyEnumToString(countryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countryCodes(CountryCode... countryCodes) {
            countryCodes(Arrays.asList(countryCodes));
            return this;
        }

        public final void setCountryCodes(Collection<String> countryCodes) {
            this.countryCodes = CountryCodesCopier.copy(countryCodes);
        }

        public final ForwardedIPConfig.Builder getForwardedIPConfig() {
            return forwardedIPConfig != null ? forwardedIPConfig.toBuilder() : null;
        }

        @Override
        public final Builder forwardedIPConfig(ForwardedIPConfig forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig;
            return this;
        }

        public final void setForwardedIPConfig(ForwardedIPConfig.BuilderImpl forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig != null ? forwardedIPConfig.build() : null;
        }

        @Override
        public GeoMatchStatement build() {
            return new GeoMatchStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
