/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableManagedRuleGroupsResponse extends Wafv2Response implements
        ToCopyableBuilder<ListAvailableManagedRuleGroupsResponse.Builder, ListAvailableManagedRuleGroupsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListAvailableManagedRuleGroupsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<ManagedRuleGroupSummary>> MANAGED_RULE_GROUPS_FIELD = SdkField
            .<List<ManagedRuleGroupSummary>> builder(MarshallingType.LIST)
            .memberName("ManagedRuleGroups")
            .getter(getter(ListAvailableManagedRuleGroupsResponse::managedRuleGroups))
            .setter(setter(Builder::managedRuleGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedRuleGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManagedRuleGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManagedRuleGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            MANAGED_RULE_GROUPS_FIELD));

    private final String nextMarker;

    private final List<ManagedRuleGroupSummary> managedRuleGroups;

    private ListAvailableManagedRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.managedRuleGroups = builder.managedRuleGroups;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
     * available for retrieval exceeds the limit, AWS WAF returns a <code>NextMarker</code> value in the response. To
     * retrieve the next batch of objects, provide the marker from the prior call in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are
     *         still available for retrieval exceeds the limit, AWS WAF returns a <code>NextMarker</code> value in the
     *         response. To retrieve the next batch of objects, provide the marker from the prior call in your next
     *         request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the ManagedRuleGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasManagedRuleGroups() {
        return managedRuleGroups != null && !(managedRuleGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasManagedRuleGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public final List<ManagedRuleGroupSummary> managedRuleGroups() {
        return managedRuleGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedRuleGroups() ? managedRuleGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableManagedRuleGroupsResponse)) {
            return false;
        }
        ListAvailableManagedRuleGroupsResponse other = (ListAvailableManagedRuleGroupsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasManagedRuleGroups() == other.hasManagedRuleGroups()
                && Objects.equals(managedRuleGroups(), other.managedRuleGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAvailableManagedRuleGroupsResponse").add("NextMarker", nextMarker())
                .add("ManagedRuleGroups", hasManagedRuleGroups() ? managedRuleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "ManagedRuleGroups":
            return Optional.ofNullable(clazz.cast(managedRuleGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableManagedRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListAvailableManagedRuleGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAvailableManagedRuleGroupsResponse> {
        /**
         * <p>
         * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
         * available for retrieval exceeds the limit, AWS WAF returns a <code>NextMarker</code> value in the response.
         * To retrieve the next batch of objects, provide the marker from the prior call in your next request.
         * </p>
         * 
         * @param nextMarker
         *        When you request a list of objects with a <code>Limit</code> setting, if the number of objects that
         *        are still available for retrieval exceeds the limit, AWS WAF returns a <code>NextMarker</code> value
         *        in the response. To retrieve the next batch of objects, provide the marker from the prior call in your
         *        next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p/>
         * 
         * @param managedRuleGroups
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRuleGroups(Collection<ManagedRuleGroupSummary> managedRuleGroups);

        /**
         * <p/>
         * 
         * @param managedRuleGroups
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRuleGroups(ManagedRuleGroupSummary... managedRuleGroups);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link List<ManagedRuleGroupSummary>.Builder} avoiding
         * the need to create one manually via {@link List<ManagedRuleGroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ManagedRuleGroupSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #managedRuleGroups(List<ManagedRuleGroupSummary>)}.
         * 
         * @param managedRuleGroups
         *        a consumer that will call methods on {@link List<ManagedRuleGroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedRuleGroups(List<ManagedRuleGroupSummary>)
         */
        Builder managedRuleGroups(Consumer<ManagedRuleGroupSummary.Builder>... managedRuleGroups);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private String nextMarker;

        private List<ManagedRuleGroupSummary> managedRuleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableManagedRuleGroupsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            managedRuleGroups(model.managedRuleGroups);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final List<ManagedRuleGroupSummary.Builder> getManagedRuleGroups() {
            List<ManagedRuleGroupSummary.Builder> result = ManagedRuleGroupSummariesCopier.copyToBuilder(this.managedRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder managedRuleGroups(Collection<ManagedRuleGroupSummary> managedRuleGroups) {
            this.managedRuleGroups = ManagedRuleGroupSummariesCopier.copy(managedRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRuleGroups(ManagedRuleGroupSummary... managedRuleGroups) {
            managedRuleGroups(Arrays.asList(managedRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRuleGroups(Consumer<ManagedRuleGroupSummary.Builder>... managedRuleGroups) {
            managedRuleGroups(Stream.of(managedRuleGroups).map(c -> ManagedRuleGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setManagedRuleGroups(Collection<ManagedRuleGroupSummary.BuilderImpl> managedRuleGroups) {
            this.managedRuleGroups = ManagedRuleGroupSummariesCopier.copyFromBuilder(managedRuleGroups);
        }

        @Override
        public ListAvailableManagedRuleGroupsResponse build() {
            return new ListAvailableManagedRuleGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
