/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single sampled web request. The response from <a>GetSampledRequests</a> includes a
 * <code>SampledHTTPRequests</code> complex type that appears as <code>SampledRequests</code> in the response syntax.
 * <code>SampledHTTPRequests</code> contains an array of <code>SampledHTTPRequest</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SampledHTTPRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SampledHTTPRequest.Builder, SampledHTTPRequest> {
    private static final SdkField<HTTPRequest> REQUEST_FIELD = SdkField.<HTTPRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Request").getter(getter(SampledHTTPRequest::request)).setter(setter(Builder::request))
            .constructor(HTTPRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Request").build()).build();

    private static final SdkField<Long> WEIGHT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Weight")
            .getter(getter(SampledHTTPRequest::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(SampledHTTPRequest::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(SampledHTTPRequest::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> RULE_NAME_WITHIN_RULE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleNameWithinRuleGroup").getter(getter(SampledHTTPRequest::ruleNameWithinRuleGroup))
            .setter(setter(Builder::ruleNameWithinRuleGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNameWithinRuleGroup").build())
            .build();

    private static final SdkField<List<HTTPHeader>> REQUEST_HEADERS_INSERTED_FIELD = SdkField
            .<List<HTTPHeader>> builder(MarshallingType.LIST)
            .memberName("RequestHeadersInserted")
            .getter(getter(SampledHTTPRequest::requestHeadersInserted))
            .setter(setter(Builder::requestHeadersInserted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestHeadersInserted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HTTPHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(HTTPHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RESPONSE_CODE_SENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResponseCodeSent").getter(getter(SampledHTTPRequest::responseCodeSent))
            .setter(setter(Builder::responseCodeSent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCodeSent").build()).build();

    private static final SdkField<List<Label>> LABELS_FIELD = SdkField
            .<List<Label>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(SampledHTTPRequest::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Label> builder(MarshallingType.SDK_POJO)
                                            .constructor(Label::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD, WEIGHT_FIELD,
            TIMESTAMP_FIELD, ACTION_FIELD, RULE_NAME_WITHIN_RULE_GROUP_FIELD, REQUEST_HEADERS_INSERTED_FIELD,
            RESPONSE_CODE_SENT_FIELD, LABELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final HTTPRequest request;

    private final Long weight;

    private final Instant timestamp;

    private final String action;

    private final String ruleNameWithinRuleGroup;

    private final List<HTTPHeader> requestHeadersInserted;

    private final Integer responseCodeSent;

    private final List<Label> labels;

    private SampledHTTPRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.weight = builder.weight;
        this.timestamp = builder.timestamp;
        this.action = builder.action;
        this.ruleNameWithinRuleGroup = builder.ruleNameWithinRuleGroup;
        this.requestHeadersInserted = builder.requestHeadersInserted;
        this.responseCodeSent = builder.responseCodeSent;
        this.labels = builder.labels;
    }

    /**
     * <p>
     * A complex type that contains detailed information about the request.
     * </p>
     * 
     * @return A complex type that contains detailed information about the request.
     */
    public final HTTPRequest request() {
        return request;
    }

    /**
     * <p>
     * A value that indicates how one result in the response relates proportionally to other results in the response.
     * For example, a result that has a weight of <code>2</code> represents roughly twice as many web requests as a
     * result that has a weight of <code>1</code>.
     * </p>
     * 
     * @return A value that indicates how one result in the response relates proportionally to other results in the
     *         response. For example, a result that has a weight of <code>2</code> represents roughly twice as many web
     *         requests as a result that has a weight of <code>1</code>.
     */
    public final Long weight() {
        return weight;
    }

    /**
     * <p>
     * The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).
     * </p>
     * 
     * @return The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or
     * <code>COUNT</code>.
     * </p>
     * 
     * @return The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or
     *         <code>COUNT</code>.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for this name is
     * <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For your own rule groups, the
     * format for this name is <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the rule is not in a rule
     * group, this field is absent.
     * </p>
     * 
     * @return The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for this
     *         name is <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For your own
     *         rule groups, the format for this name is <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the
     *         rule is not in a rule group, this field is absent.
     */
    public final String ruleNameWithinRuleGroup() {
        return ruleNameWithinRuleGroup;
    }

    /**
     * Returns true if the RequestHeadersInserted property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRequestHeadersInserted() {
        return requestHeadersInserted != null && !(requestHeadersInserted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom request headers inserted by AWS WAF into the request, according to the custom request configuration for
     * the matching rule action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequestHeadersInserted()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Custom request headers inserted by AWS WAF into the request, according to the custom request
     *         configuration for the matching rule action.
     */
    public final List<HTTPHeader> requestHeadersInserted() {
        return requestHeadersInserted;
    }

    /**
     * <p>
     * The response code that was sent for the request.
     * </p>
     * 
     * @return The response code that was sent for the request.
     */
    public final Integer responseCodeSent() {
        return responseCodeSent;
    }

    /**
     * Returns true if the Labels property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Labels applied to the web request by matching rules. AWS WAF applies fully qualified labels to matching web
     * requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule
     * group or web ACL defines the label namespace.
     * </p>
     * <p>
     * For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
     * <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Labels applied to the web request by matching rules. AWS WAF applies fully qualified labels to matching
     *         web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The
     *         rule's rule group or web ACL defines the label namespace. </p>
     *         <p>
     *         For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
     *         <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
     */
    public final List<Label> labels() {
        return labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(request());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNameWithinRuleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestHeadersInserted() ? requestHeadersInserted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(responseCodeSent());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampledHTTPRequest)) {
            return false;
        }
        SampledHTTPRequest other = (SampledHTTPRequest) obj;
        return Objects.equals(request(), other.request()) && Objects.equals(weight(), other.weight())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(action(), other.action())
                && Objects.equals(ruleNameWithinRuleGroup(), other.ruleNameWithinRuleGroup())
                && hasRequestHeadersInserted() == other.hasRequestHeadersInserted()
                && Objects.equals(requestHeadersInserted(), other.requestHeadersInserted())
                && Objects.equals(responseCodeSent(), other.responseCodeSent()) && hasLabels() == other.hasLabels()
                && Objects.equals(labels(), other.labels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SampledHTTPRequest").add("Request", request()).add("Weight", weight())
                .add("Timestamp", timestamp()).add("Action", action()).add("RuleNameWithinRuleGroup", ruleNameWithinRuleGroup())
                .add("RequestHeadersInserted", hasRequestHeadersInserted() ? requestHeadersInserted() : null)
                .add("ResponseCodeSent", responseCodeSent()).add("Labels", hasLabels() ? labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Request":
            return Optional.ofNullable(clazz.cast(request()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "RuleNameWithinRuleGroup":
            return Optional.ofNullable(clazz.cast(ruleNameWithinRuleGroup()));
        case "RequestHeadersInserted":
            return Optional.ofNullable(clazz.cast(requestHeadersInserted()));
        case "ResponseCodeSent":
            return Optional.ofNullable(clazz.cast(responseCodeSent()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SampledHTTPRequest, T> g) {
        return obj -> g.apply((SampledHTTPRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SampledHTTPRequest> {
        /**
         * <p>
         * A complex type that contains detailed information about the request.
         * </p>
         * 
         * @param request
         *        A complex type that contains detailed information about the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder request(HTTPRequest request);

        /**
         * <p>
         * A complex type that contains detailed information about the request.
         * </p>
         * This is a convenience that creates an instance of the {@link HTTPRequest.Builder} avoiding the need to create
         * one manually via {@link HTTPRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link HTTPRequest.Builder#build()} is called immediately and its result
         * is passed to {@link #request(HTTPRequest)}.
         * 
         * @param request
         *        a consumer that will call methods on {@link HTTPRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #request(HTTPRequest)
         */
        default Builder request(Consumer<HTTPRequest.Builder> request) {
            return request(HTTPRequest.builder().applyMutation(request).build());
        }

        /**
         * <p>
         * A value that indicates how one result in the response relates proportionally to other results in the
         * response. For example, a result that has a weight of <code>2</code> represents roughly twice as many web
         * requests as a result that has a weight of <code>1</code>.
         * </p>
         * 
         * @param weight
         *        A value that indicates how one result in the response relates proportionally to other results in the
         *        response. For example, a result that has a weight of <code>2</code> represents roughly twice as many
         *        web requests as a result that has a weight of <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Long weight);

        /**
         * <p>
         * The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).
         * </p>
         * 
         * @param timestamp
         *        The time at which AWS WAF received the request from your AWS resource, in Unix time format (in
         *        seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or
         * <code>COUNT</code>.
         * </p>
         * 
         * @param action
         *        The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>,
         *        or <code>COUNT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for this name
         * is <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For your own rule
         * groups, the format for this name is <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the rule is
         * not in a rule group, this field is absent.
         * </p>
         * 
         * @param ruleNameWithinRuleGroup
         *        The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for
         *        this name is <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For
         *        your own rule groups, the format for this name is
         *        <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the rule is not in a rule group, this field
         *        is absent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNameWithinRuleGroup(String ruleNameWithinRuleGroup);

        /**
         * <p>
         * Custom request headers inserted by AWS WAF into the request, according to the custom request configuration
         * for the matching rule action.
         * </p>
         * 
         * @param requestHeadersInserted
         *        Custom request headers inserted by AWS WAF into the request, according to the custom request
         *        configuration for the matching rule action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestHeadersInserted(Collection<HTTPHeader> requestHeadersInserted);

        /**
         * <p>
         * Custom request headers inserted by AWS WAF into the request, according to the custom request configuration
         * for the matching rule action.
         * </p>
         * 
         * @param requestHeadersInserted
         *        Custom request headers inserted by AWS WAF into the request, according to the custom request
         *        configuration for the matching rule action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestHeadersInserted(HTTPHeader... requestHeadersInserted);

        /**
         * <p>
         * Custom request headers inserted by AWS WAF into the request, according to the custom request configuration
         * for the matching rule action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HTTPHeader>.Builder} avoiding the need to
         * create one manually via {@link List<HTTPHeader>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HTTPHeader>.Builder#build()} is called immediately and its
         * result is passed to {@link #requestHeadersInserted(List<HTTPHeader>)}.
         * 
         * @param requestHeadersInserted
         *        a consumer that will call methods on {@link List<HTTPHeader>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestHeadersInserted(List<HTTPHeader>)
         */
        Builder requestHeadersInserted(Consumer<HTTPHeader.Builder>... requestHeadersInserted);

        /**
         * <p>
         * The response code that was sent for the request.
         * </p>
         * 
         * @param responseCodeSent
         *        The response code that was sent for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCodeSent(Integer responseCodeSent);

        /**
         * <p>
         * Labels applied to the web request by matching rules. AWS WAF applies fully qualified labels to matching web
         * requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule
         * group or web ACL defines the label namespace.
         * </p>
         * <p>
         * For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         * <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * </p>
         * 
         * @param labels
         *        Labels applied to the web request by matching rules. AWS WAF applies fully qualified labels to
         *        matching web requests. A fully qualified label is the concatenation of a label namespace and a rule
         *        label. The rule's rule group or web ACL defines the label namespace. </p>
         *        <p>
         *        For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         *        <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<Label> labels);

        /**
         * <p>
         * Labels applied to the web request by matching rules. AWS WAF applies fully qualified labels to matching web
         * requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule
         * group or web ACL defines the label namespace.
         * </p>
         * <p>
         * For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         * <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * </p>
         * 
         * @param labels
         *        Labels applied to the web request by matching rules. AWS WAF applies fully qualified labels to
         *        matching web requests. A fully qualified label is the concatenation of a label namespace and a rule
         *        label. The rule's rule group or web ACL defines the label namespace. </p>
         *        <p>
         *        For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         *        <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Label... labels);

        /**
         * <p>
         * Labels applied to the web request by matching rules. AWS WAF applies fully qualified labels to matching web
         * requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule
         * group or web ACL defines the label namespace.
         * </p>
         * <p>
         * For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         * <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Label>.Builder} avoiding the need to create
         * one manually via {@link List<Label>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Label>.Builder#build()} is called immediately and its result
         * is passed to {@link #labels(List<Label>)}.
         * 
         * @param labels
         *        a consumer that will call methods on {@link List<Label>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(List<Label>)
         */
        Builder labels(Consumer<Label.Builder>... labels);
    }

    static final class BuilderImpl implements Builder {
        private HTTPRequest request;

        private Long weight;

        private Instant timestamp;

        private String action;

        private String ruleNameWithinRuleGroup;

        private List<HTTPHeader> requestHeadersInserted = DefaultSdkAutoConstructList.getInstance();

        private Integer responseCodeSent;

        private List<Label> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SampledHTTPRequest model) {
            request(model.request);
            weight(model.weight);
            timestamp(model.timestamp);
            action(model.action);
            ruleNameWithinRuleGroup(model.ruleNameWithinRuleGroup);
            requestHeadersInserted(model.requestHeadersInserted);
            responseCodeSent(model.responseCodeSent);
            labels(model.labels);
        }

        public final HTTPRequest.Builder getRequest() {
            return request != null ? request.toBuilder() : null;
        }

        @Override
        public final Builder request(HTTPRequest request) {
            this.request = request;
            return this;
        }

        public final void setRequest(HTTPRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        public final Long getWeight() {
            return weight;
        }

        @Override
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getRuleNameWithinRuleGroup() {
            return ruleNameWithinRuleGroup;
        }

        @Override
        public final Builder ruleNameWithinRuleGroup(String ruleNameWithinRuleGroup) {
            this.ruleNameWithinRuleGroup = ruleNameWithinRuleGroup;
            return this;
        }

        public final void setRuleNameWithinRuleGroup(String ruleNameWithinRuleGroup) {
            this.ruleNameWithinRuleGroup = ruleNameWithinRuleGroup;
        }

        public final List<HTTPHeader.Builder> getRequestHeadersInserted() {
            List<HTTPHeader.Builder> result = HTTPHeadersCopier.copyToBuilder(this.requestHeadersInserted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder requestHeadersInserted(Collection<HTTPHeader> requestHeadersInserted) {
            this.requestHeadersInserted = HTTPHeadersCopier.copy(requestHeadersInserted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestHeadersInserted(HTTPHeader... requestHeadersInserted) {
            requestHeadersInserted(Arrays.asList(requestHeadersInserted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestHeadersInserted(Consumer<HTTPHeader.Builder>... requestHeadersInserted) {
            requestHeadersInserted(Stream.of(requestHeadersInserted).map(c -> HTTPHeader.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRequestHeadersInserted(Collection<HTTPHeader.BuilderImpl> requestHeadersInserted) {
            this.requestHeadersInserted = HTTPHeadersCopier.copyFromBuilder(requestHeadersInserted);
        }

        public final Integer getResponseCodeSent() {
            return responseCodeSent;
        }

        @Override
        public final Builder responseCodeSent(Integer responseCodeSent) {
            this.responseCodeSent = responseCodeSent;
            return this;
        }

        public final void setResponseCodeSent(Integer responseCodeSent) {
            this.responseCodeSent = responseCodeSent;
        }

        public final List<Label.Builder> getLabels() {
            List<Label.Builder> result = LabelsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<Label.Builder>... labels) {
            labels(Stream.of(labels).map(c -> Label.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        @Override
        public SampledHTTPRequest build() {
            return new SampledHTTPRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
