/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.Label;
import software.amazon.awssdk.services.wafv2.model.LabelsCopier;
import software.amazon.awssdk.services.wafv2.model.OverrideAction;
import software.amazon.awssdk.services.wafv2.model.RuleAction;
import software.amazon.awssdk.services.wafv2.model.Statement;
import software.amazon.awssdk.services.wafv2.model.VisibilityConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Rule.getter(Rule::name)).setter(Rule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(Rule.getter(Rule::priority)).setter(Rule.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<Statement> STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Statement").getter(Rule.getter(Rule::statement)).setter(Rule.setter(Builder::statement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statement").build()}).build();
    private static final SdkField<RuleAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(Rule.getter(Rule::action)).setter(Rule.setter(Builder::action)).constructor(RuleAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<OverrideAction> OVERRIDE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideAction").getter(Rule.getter(Rule::overrideAction)).setter(Rule.setter(Builder::overrideAction)).constructor(OverrideAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideAction").build()}).build();
    private static final SdkField<List<Label>> RULE_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleLabels").getter(Rule.getter(Rule::ruleLabels)).setter(Rule.setter(Builder::ruleLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Label::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VisibilityConfig> VISIBILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisibilityConfig").getter(Rule.getter(Rule::visibilityConfig)).setter(Rule.setter(Builder::visibilityConfig)).constructor(VisibilityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PRIORITY_FIELD, STATEMENT_FIELD, ACTION_FIELD, OVERRIDE_ACTION_FIELD, RULE_LABELS_FIELD, VISIBILITY_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer priority;
    private final Statement statement;
    private final RuleAction action;
    private final OverrideAction overrideAction;
    private final List<Label> ruleLabels;
    private final VisibilityConfig visibilityConfig;

    private Rule(BuilderImpl builder) {
        this.name = builder.name;
        this.priority = builder.priority;
        this.statement = builder.statement;
        this.action = builder.action;
        this.overrideAction = builder.overrideAction;
        this.ruleLabels = builder.ruleLabels;
        this.visibilityConfig = builder.visibilityConfig;
    }

    public final String name() {
        return this.name;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Statement statement() {
        return this.statement;
    }

    public final RuleAction action() {
        return this.action;
    }

    public final OverrideAction overrideAction() {
        return this.overrideAction;
    }

    public final boolean hasRuleLabels() {
        return this.ruleLabels != null && !(this.ruleLabels instanceof SdkAutoConstructList);
    }

    public final List<Label> ruleLabels() {
        return this.ruleLabels;
    }

    public final VisibilityConfig visibilityConfig() {
        return this.visibilityConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.statement());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleLabels() ? this.ruleLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.statement(), other.statement()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.overrideAction(), other.overrideAction()) && this.hasRuleLabels() == other.hasRuleLabels() && Objects.equals(this.ruleLabels(), other.ruleLabels()) && Objects.equals(this.visibilityConfig(), other.visibilityConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).add("Statement", (Object)this.statement()).add("Action", (Object)this.action()).add("OverrideAction", (Object)this.overrideAction()).add("RuleLabels", this.hasRuleLabels() ? this.ruleLabels() : null).add("VisibilityConfig", (Object)this.visibilityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Statement": {
                return Optional.ofNullable(clazz.cast(this.statement()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "OverrideAction": {
                return Optional.ofNullable(clazz.cast(this.overrideAction()));
            }
            case "RuleLabels": {
                return Optional.ofNullable(clazz.cast(this.ruleLabels()));
            }
            case "VisibilityConfig": {
                return Optional.ofNullable(clazz.cast(this.visibilityConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer priority;
        private Statement statement;
        private RuleAction action;
        private OverrideAction overrideAction;
        private List<Label> ruleLabels = DefaultSdkAutoConstructList.getInstance();
        private VisibilityConfig visibilityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.name(model.name);
            this.priority(model.priority);
            this.statement(model.statement);
            this.action(model.action);
            this.overrideAction(model.overrideAction);
            this.ruleLabels(model.ruleLabels);
            this.visibilityConfig(model.visibilityConfig);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Statement.Builder getStatement() {
            return this.statement != null ? this.statement.toBuilder() : null;
        }

        @Override
        public final Builder statement(Statement statement) {
            this.statement = statement;
            return this;
        }

        public final void setStatement(Statement.BuilderImpl statement) {
            this.statement = statement != null ? statement.build() : null;
        }

        public final RuleAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(RuleAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final OverrideAction.Builder getOverrideAction() {
            return this.overrideAction != null ? this.overrideAction.toBuilder() : null;
        }

        @Override
        public final Builder overrideAction(OverrideAction overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }

        public final void setOverrideAction(OverrideAction.BuilderImpl overrideAction) {
            this.overrideAction = overrideAction != null ? overrideAction.build() : null;
        }

        public final List<Label.Builder> getRuleLabels() {
            List<Label.Builder> result = LabelsCopier.copyToBuilder(this.ruleLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ruleLabels(Collection<Label> ruleLabels) {
            this.ruleLabels = LabelsCopier.copy(ruleLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleLabels(Label ... ruleLabels) {
            this.ruleLabels(Arrays.asList(ruleLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleLabels(Consumer<Label.Builder> ... ruleLabels) {
            this.ruleLabels(Stream.of(ruleLabels).map(c -> (Label)((Label.Builder)Label.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRuleLabels(Collection<Label.BuilderImpl> ruleLabels) {
            this.ruleLabels = LabelsCopier.copyFromBuilder(ruleLabels);
        }

        public final VisibilityConfig.Builder getVisibilityConfig() {
            return this.visibilityConfig != null ? this.visibilityConfig.toBuilder() : null;
        }

        @Override
        public final Builder visibilityConfig(VisibilityConfig visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        public final void setVisibilityConfig(VisibilityConfig.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder name(String var1);

        public Builder priority(Integer var1);

        public Builder statement(Statement var1);

        default public Builder statement(Consumer<Statement.Builder> statement) {
            return this.statement((Statement)((Statement.Builder)Statement.builder().applyMutation(statement)).build());
        }

        public Builder action(RuleAction var1);

        default public Builder action(Consumer<RuleAction.Builder> action) {
            return this.action((RuleAction)((RuleAction.Builder)RuleAction.builder().applyMutation(action)).build());
        }

        public Builder overrideAction(OverrideAction var1);

        default public Builder overrideAction(Consumer<OverrideAction.Builder> overrideAction) {
            return this.overrideAction((OverrideAction)((OverrideAction.Builder)OverrideAction.builder().applyMutation(overrideAction)).build());
        }

        public Builder ruleLabels(Collection<Label> var1);

        public Builder ruleLabels(Label ... var1);

        public Builder ruleLabels(Consumer<Label.Builder> ... var1);

        public Builder visibilityConfig(VisibilityConfig var1);

        default public Builder visibilityConfig(Consumer<VisibilityConfig.Builder> visibilityConfig) {
            return this.visibilityConfig((VisibilityConfig)((VisibilityConfig.Builder)VisibilityConfig.builder().applyMutation(visibilityConfig)).build());
        }
    }
}

