/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ExcludedRule;
import software.amazon.awssdk.services.wafv2.model.ExcludedRulesCopier;
import software.amazon.awssdk.services.wafv2.model.Statement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedRuleGroupStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedRuleGroupStatement> {
    private static final SdkField<String> VENDOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VendorName").getter(ManagedRuleGroupStatement.getter(ManagedRuleGroupStatement::vendorName)).setter(ManagedRuleGroupStatement.setter(Builder::vendorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ManagedRuleGroupStatement.getter(ManagedRuleGroupStatement::name)).setter(ManagedRuleGroupStatement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<ExcludedRule>> EXCLUDED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedRules").getter(ManagedRuleGroupStatement.getter(ManagedRuleGroupStatement::excludedRules)).setter(ManagedRuleGroupStatement.setter(Builder::excludedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExcludedRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Statement> SCOPE_DOWN_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScopeDownStatement").getter(ManagedRuleGroupStatement.getter(ManagedRuleGroupStatement::scopeDownStatement)).setter(ManagedRuleGroupStatement.setter(Builder::scopeDownStatement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeDownStatement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDOR_NAME_FIELD, NAME_FIELD, EXCLUDED_RULES_FIELD, SCOPE_DOWN_STATEMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vendorName;
    private final String name;
    private final List<ExcludedRule> excludedRules;
    private final Statement scopeDownStatement;

    private ManagedRuleGroupStatement(BuilderImpl builder) {
        this.vendorName = builder.vendorName;
        this.name = builder.name;
        this.excludedRules = builder.excludedRules;
        this.scopeDownStatement = builder.scopeDownStatement;
    }

    public final String vendorName() {
        return this.vendorName;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasExcludedRules() {
        return this.excludedRules != null && !(this.excludedRules instanceof SdkAutoConstructList);
    }

    public final List<ExcludedRule> excludedRules() {
        return this.excludedRules;
    }

    public final Statement scopeDownStatement() {
        return this.scopeDownStatement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedRules() ? this.excludedRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeDownStatement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedRuleGroupStatement)) {
            return false;
        }
        ManagedRuleGroupStatement other = (ManagedRuleGroupStatement)obj;
        return Objects.equals(this.vendorName(), other.vendorName()) && Objects.equals(this.name(), other.name()) && this.hasExcludedRules() == other.hasExcludedRules() && Objects.equals(this.excludedRules(), other.excludedRules()) && Objects.equals(this.scopeDownStatement(), other.scopeDownStatement());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedRuleGroupStatement").add("VendorName", (Object)this.vendorName()).add("Name", (Object)this.name()).add("ExcludedRules", this.hasExcludedRules() ? this.excludedRules() : null).add("ScopeDownStatement", (Object)this.scopeDownStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VendorName": {
                return Optional.ofNullable(clazz.cast(this.vendorName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ExcludedRules": {
                return Optional.ofNullable(clazz.cast(this.excludedRules()));
            }
            case "ScopeDownStatement": {
                return Optional.ofNullable(clazz.cast(this.scopeDownStatement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedRuleGroupStatement, T> g) {
        return obj -> g.apply((ManagedRuleGroupStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vendorName;
        private String name;
        private List<ExcludedRule> excludedRules = DefaultSdkAutoConstructList.getInstance();
        private Statement scopeDownStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedRuleGroupStatement model) {
            this.vendorName(model.vendorName);
            this.name(model.name);
            this.excludedRules(model.excludedRules);
            this.scopeDownStatement(model.scopeDownStatement);
        }

        public final String getVendorName() {
            return this.vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<ExcludedRule.Builder> getExcludedRules() {
            List<ExcludedRule.Builder> result = ExcludedRulesCopier.copyToBuilder(this.excludedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder excludedRules(Collection<ExcludedRule> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copy(excludedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(ExcludedRule ... excludedRules) {
            this.excludedRules(Arrays.asList(excludedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(Consumer<ExcludedRule.Builder> ... excludedRules) {
            this.excludedRules(Stream.of(excludedRules).map(c -> (ExcludedRule)((ExcludedRule.Builder)ExcludedRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExcludedRules(Collection<ExcludedRule.BuilderImpl> excludedRules) {
            this.excludedRules = ExcludedRulesCopier.copyFromBuilder(excludedRules);
        }

        public final Statement.Builder getScopeDownStatement() {
            return this.scopeDownStatement != null ? this.scopeDownStatement.toBuilder() : null;
        }

        @Override
        public final Builder scopeDownStatement(Statement scopeDownStatement) {
            this.scopeDownStatement = scopeDownStatement;
            return this;
        }

        public final void setScopeDownStatement(Statement.BuilderImpl scopeDownStatement) {
            this.scopeDownStatement = scopeDownStatement != null ? scopeDownStatement.build() : null;
        }

        public ManagedRuleGroupStatement build() {
            return new ManagedRuleGroupStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedRuleGroupStatement> {
        public Builder vendorName(String var1);

        public Builder name(String var1);

        public Builder excludedRules(Collection<ExcludedRule> var1);

        public Builder excludedRules(ExcludedRule ... var1);

        public Builder excludedRules(Consumer<ExcludedRule.Builder> ... var1);

        public Builder scopeDownStatement(Statement var1);

        default public Builder scopeDownStatement(Consumer<Statement.Builder> scopeDownStatement) {
            return this.scopeDownStatement((Statement)((Statement.Builder)Statement.builder().applyMutation(scopeDownStatement)).build());
        }
    }
}

