/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single logging filter, used in <a>LoggingFilter</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Behavior").getter(getter(Filter::behaviorAsString)).setter(setter(Builder::behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Behavior").build()).build();

    private static final SdkField<String> REQUIREMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Requirement").getter(getter(Filter::requirementAsString)).setter(setter(Builder::requirement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requirement").build()).build();

    private static final SdkField<List<Condition>> CONDITIONS_FIELD = SdkField
            .<List<Condition>> builder(MarshallingType.LIST)
            .memberName("Conditions")
            .getter(getter(Filter::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Condition> builder(MarshallingType.SDK_POJO)
                                            .constructor(Condition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHAVIOR_FIELD,
            REQUIREMENT_FIELD, CONDITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String behavior;

    private final String requirement;

    private final List<Condition> conditions;

    private Filter(BuilderImpl builder) {
        this.behavior = builder.behavior;
        this.requirement = builder.requirement;
        this.conditions = builder.conditions;
    }

    /**
     * <p>
     * How to handle logs that satisfy the filter's conditions and requirement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link FilterBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return How to handle logs that satisfy the filter's conditions and requirement.
     * @see FilterBehavior
     */
    public final FilterBehavior behavior() {
        return FilterBehavior.fromValue(behavior);
    }

    /**
     * <p>
     * How to handle logs that satisfy the filter's conditions and requirement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #behavior} will
     * return {@link FilterBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #behaviorAsString}.
     * </p>
     * 
     * @return How to handle logs that satisfy the filter's conditions and requirement.
     * @see FilterBehavior
     */
    public final String behaviorAsString() {
        return behavior;
    }

    /**
     * <p>
     * Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must
     * match all conditions or must match at least one condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requirement} will
     * return {@link FilterRequirement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requirementAsString}.
     * </p>
     * 
     * @return Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log
     *         must match all conditions or must match at least one condition.
     * @see FilterRequirement
     */
    public final FilterRequirement requirement() {
        return FilterRequirement.fromValue(requirement);
    }

    /**
     * <p>
     * Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must
     * match all conditions or must match at least one condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requirement} will
     * return {@link FilterRequirement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requirementAsString}.
     * </p>
     * 
     * @return Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log
     *         must match all conditions or must match at least one condition.
     * @see FilterRequirement
     */
    public final String requirementAsString() {
        return requirement;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Match conditions for the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return Match conditions for the filter.
     */
    public final List<Condition> conditions() {
        return conditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(behaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requirementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(behaviorAsString(), other.behaviorAsString())
                && Objects.equals(requirementAsString(), other.requirementAsString()) && hasConditions() == other.hasConditions()
                && Objects.equals(conditions(), other.conditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("Behavior", behaviorAsString()).add("Requirement", requirementAsString())
                .add("Conditions", hasConditions() ? conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Behavior":
            return Optional.ofNullable(clazz.cast(behaviorAsString()));
        case "Requirement":
            return Optional.ofNullable(clazz.cast(requirementAsString()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * How to handle logs that satisfy the filter's conditions and requirement.
         * </p>
         * 
         * @param behavior
         *        How to handle logs that satisfy the filter's conditions and requirement.
         * @see FilterBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterBehavior
         */
        Builder behavior(String behavior);

        /**
         * <p>
         * How to handle logs that satisfy the filter's conditions and requirement.
         * </p>
         * 
         * @param behavior
         *        How to handle logs that satisfy the filter's conditions and requirement.
         * @see FilterBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterBehavior
         */
        Builder behavior(FilterBehavior behavior);

        /**
         * <p>
         * Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must
         * match all conditions or must match at least one condition.
         * </p>
         * 
         * @param requirement
         *        Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a
         *        log must match all conditions or must match at least one condition.
         * @see FilterRequirement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterRequirement
         */
        Builder requirement(String requirement);

        /**
         * <p>
         * Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must
         * match all conditions or must match at least one condition.
         * </p>
         * 
         * @param requirement
         *        Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a
         *        log must match all conditions or must match at least one condition.
         * @see FilterRequirement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterRequirement
         */
        Builder requirement(FilterRequirement requirement);

        /**
         * <p>
         * Match conditions for the filter.
         * </p>
         * 
         * @param conditions
         *        Match conditions for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<Condition> conditions);

        /**
         * <p>
         * Match conditions for the filter.
         * </p>
         * 
         * @param conditions
         *        Match conditions for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Condition... conditions);

        /**
         * <p>
         * Match conditions for the filter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Condition>.Builder} avoiding the need to
         * create one manually via {@link List<Condition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Condition>.Builder#build()} is called immediately and its
         * result is passed to {@link #conditions(List<Condition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on {@link List<Condition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(List<Condition>)
         */
        Builder conditions(Consumer<Condition.Builder>... conditions);
    }

    static final class BuilderImpl implements Builder {
        private String behavior;

        private String requirement;

        private List<Condition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            behavior(model.behavior);
            requirement(model.requirement);
            conditions(model.conditions);
        }

        public final String getBehavior() {
            return behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        @Transient
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        @Transient
        public final Builder behavior(FilterBehavior behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final String getRequirement() {
            return requirement;
        }

        public final void setRequirement(String requirement) {
            this.requirement = requirement;
        }

        @Override
        @Transient
        public final Builder requirement(String requirement) {
            this.requirement = requirement;
            return this;
        }

        @Override
        @Transient
        public final Builder requirement(FilterRequirement requirement) {
            this.requirement(requirement == null ? null : requirement.toString());
            return this;
        }

        public final List<Condition.Builder> getConditions() {
            List<Condition.Builder> result = ConditionsCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<Condition.BuilderImpl> conditions) {
            this.conditions = ConditionsCopier.copyFromBuilder(conditions);
        }

        @Override
        @Transient
        public final Builder conditions(Collection<Condition> conditions) {
            this.conditions = ConditionsCopier.copy(conditions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder conditions(Condition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder conditions(Consumer<Condition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> Condition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
