/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateManagedRuleSetVersionExpiryDateResponse extends Wafv2Response implements
        ToCopyableBuilder<UpdateManagedRuleSetVersionExpiryDateResponse.Builder, UpdateManagedRuleSetVersionExpiryDateResponse> {
    private static final SdkField<String> EXPIRING_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpiringVersion").getter(getter(UpdateManagedRuleSetVersionExpiryDateResponse::expiringVersion))
            .setter(setter(Builder::expiringVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiringVersion").build()).build();

    private static final SdkField<Instant> EXPIRY_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiryTimestamp").getter(getter(UpdateManagedRuleSetVersionExpiryDateResponse::expiryTimestamp))
            .setter(setter(Builder::expiryTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryTimestamp").build()).build();

    private static final SdkField<String> NEXT_LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextLockToken").getter(getter(UpdateManagedRuleSetVersionExpiryDateResponse::nextLockToken))
            .setter(setter(Builder::nextLockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextLockToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRING_VERSION_FIELD,
            EXPIRY_TIMESTAMP_FIELD, NEXT_LOCK_TOKEN_FIELD));

    private final String expiringVersion;

    private final Instant expiryTimestamp;

    private final String nextLockToken;

    private UpdateManagedRuleSetVersionExpiryDateResponse(BuilderImpl builder) {
        super(builder);
        this.expiringVersion = builder.expiringVersion;
        this.expiryTimestamp = builder.expiryTimestamp;
        this.nextLockToken = builder.nextLockToken;
    }

    /**
     * <p>
     * The version that is set to expire.
     * </p>
     * 
     * @return The version that is set to expire.
     */
    public final String expiringVersion() {
        return expiringVersion;
    }

    /**
     * <p>
     * The time that the version will expire.
     * </p>
     * <p>
     * Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example,
     * "2016-09-27T14:50Z".
     * </p>
     * 
     * @return The time that the version will expire. </p>
     *         <p>
     *         Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For
     *         example, "2016-09-27T14:50Z".
     */
    public final Instant expiryTimestamp() {
        return expiryTimestamp;
    }

    /**
     * <p>
     * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests,
     * to mark the state of the entity at the time of the request. To make changes to the entity associated with the
     * token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token
     * to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made,
     * the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another
     * <code>get</code>, and use the new token returned by that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
     *         requests, to mark the state of the entity at the time of the request. To make changes to the entity
     *         associated with the token, you provide the token to operations like <code>update</code> and
     *         <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you
     *         last retrieved it. If a change has been made, the update fails with a
     *         <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the
     *         new token returned by that operation.
     */
    public final String nextLockToken() {
        return nextLockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(expiringVersion());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(nextLockToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateManagedRuleSetVersionExpiryDateResponse)) {
            return false;
        }
        UpdateManagedRuleSetVersionExpiryDateResponse other = (UpdateManagedRuleSetVersionExpiryDateResponse) obj;
        return Objects.equals(expiringVersion(), other.expiringVersion())
                && Objects.equals(expiryTimestamp(), other.expiryTimestamp())
                && Objects.equals(nextLockToken(), other.nextLockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateManagedRuleSetVersionExpiryDateResponse").add("ExpiringVersion", expiringVersion())
                .add("ExpiryTimestamp", expiryTimestamp()).add("NextLockToken", nextLockToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExpiringVersion":
            return Optional.ofNullable(clazz.cast(expiringVersion()));
        case "ExpiryTimestamp":
            return Optional.ofNullable(clazz.cast(expiryTimestamp()));
        case "NextLockToken":
            return Optional.ofNullable(clazz.cast(nextLockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateManagedRuleSetVersionExpiryDateResponse, T> g) {
        return obj -> g.apply((UpdateManagedRuleSetVersionExpiryDateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateManagedRuleSetVersionExpiryDateResponse> {
        /**
         * <p>
         * The version that is set to expire.
         * </p>
         * 
         * @param expiringVersion
         *        The version that is set to expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiringVersion(String expiringVersion);

        /**
         * <p>
         * The time that the version will expire.
         * </p>
         * <p>
         * Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For
         * example, "2016-09-27T14:50Z".
         * </p>
         * 
         * @param expiryTimestamp
         *        The time that the version will expire. </p>
         *        <p>
         *        Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z.
         *        For example, "2016-09-27T14:50Z".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTimestamp(Instant expiryTimestamp);

        /**
         * <p>
         * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
         * requests, to mark the state of the entity at the time of the request. To make changes to the entity
         * associated with the token, you provide the token to operations like <code>update</code> and
         * <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last
         * retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If
         * this happens, perform another <code>get</code>, and use the new token returned by that operation.
         * </p>
         * 
         * @param nextLockToken
         *        A token used for optimistic locking. WAF returns a token to your <code>get</code> and
         *        <code>list</code> requests, to mark the state of the entity at the time of the request. To make
         *        changes to the entity associated with the token, you provide the token to operations like
         *        <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been
         *        made to the entity since you last retrieved it. If a change has been made, the update fails with a
         *        <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use
         *        the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextLockToken(String nextLockToken);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private String expiringVersion;

        private Instant expiryTimestamp;

        private String nextLockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateManagedRuleSetVersionExpiryDateResponse model) {
            super(model);
            expiringVersion(model.expiringVersion);
            expiryTimestamp(model.expiryTimestamp);
            nextLockToken(model.nextLockToken);
        }

        public final String getExpiringVersion() {
            return expiringVersion;
        }

        public final void setExpiringVersion(String expiringVersion) {
            this.expiringVersion = expiringVersion;
        }

        @Override
        @Transient
        public final Builder expiringVersion(String expiringVersion) {
            this.expiringVersion = expiringVersion;
            return this;
        }

        public final Instant getExpiryTimestamp() {
            return expiryTimestamp;
        }

        public final void setExpiryTimestamp(Instant expiryTimestamp) {
            this.expiryTimestamp = expiryTimestamp;
        }

        @Override
        @Transient
        public final Builder expiryTimestamp(Instant expiryTimestamp) {
            this.expiryTimestamp = expiryTimestamp;
            return this;
        }

        public final String getNextLockToken() {
            return nextLockToken;
        }

        public final void setNextLockToken(String nextLockToken) {
            this.nextLockToken = nextLockToken;
        }

        @Override
        @Transient
        public final Builder nextLockToken(String nextLockToken) {
            this.nextLockToken = nextLockToken;
            return this;
        }

        @Override
        public UpdateManagedRuleSetVersionExpiryDateResponse build() {
            return new UpdateManagedRuleSetVersionExpiryDateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
