/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.Scope;
import software.amazon.awssdk.services.wafv2.model.Wafv2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRateBasedStatementManagedKeysRequest
extends Wafv2Request
implements ToCopyableBuilder<Builder, GetRateBasedStatementManagedKeysRequest> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(GetRateBasedStatementManagedKeysRequest.getter(GetRateBasedStatementManagedKeysRequest::scopeAsString)).setter(GetRateBasedStatementManagedKeysRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> WEB_ACL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebACLName").getter(GetRateBasedStatementManagedKeysRequest.getter(GetRateBasedStatementManagedKeysRequest::webACLName)).setter(GetRateBasedStatementManagedKeysRequest.setter(Builder::webACLName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLName").build()}).build();
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebACLId").getter(GetRateBasedStatementManagedKeysRequest.getter(GetRateBasedStatementManagedKeysRequest::webACLId)).setter(GetRateBasedStatementManagedKeysRequest.setter(Builder::webACLId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").build()}).build();
    private static final SdkField<String> RULE_GROUP_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupRuleName").getter(GetRateBasedStatementManagedKeysRequest.getter(GetRateBasedStatementManagedKeysRequest::ruleGroupRuleName)).setter(GetRateBasedStatementManagedKeysRequest.setter(Builder::ruleGroupRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupRuleName").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(GetRateBasedStatementManagedKeysRequest.getter(GetRateBasedStatementManagedKeysRequest::ruleName)).setter(GetRateBasedStatementManagedKeysRequest.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, WEB_ACL_NAME_FIELD, WEB_ACL_ID_FIELD, RULE_GROUP_RULE_NAME_FIELD, RULE_NAME_FIELD));
    private final String scope;
    private final String webACLName;
    private final String webACLId;
    private final String ruleGroupRuleName;
    private final String ruleName;

    private GetRateBasedStatementManagedKeysRequest(BuilderImpl builder) {
        super(builder);
        this.scope = builder.scope;
        this.webACLName = builder.webACLName;
        this.webACLId = builder.webACLId;
        this.ruleGroupRuleName = builder.ruleGroupRuleName;
        this.ruleName = builder.ruleName;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String webACLName() {
        return this.webACLName;
    }

    public final String webACLId() {
        return this.webACLId;
    }

    public final String ruleGroupRuleName() {
        return this.ruleGroupRuleName;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLName());
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRateBasedStatementManagedKeysRequest)) {
            return false;
        }
        GetRateBasedStatementManagedKeysRequest other = (GetRateBasedStatementManagedKeysRequest)((Object)obj);
        return Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.webACLName(), other.webACLName()) && Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.ruleGroupRuleName(), other.ruleGroupRuleName()) && Objects.equals(this.ruleName(), other.ruleName());
    }

    public final String toString() {
        return ToString.builder((String)"GetRateBasedStatementManagedKeysRequest").add("Scope", (Object)this.scopeAsString()).add("WebACLName", (Object)this.webACLName()).add("WebACLId", (Object)this.webACLId()).add("RuleGroupRuleName", (Object)this.ruleGroupRuleName()).add("RuleName", (Object)this.ruleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "WebACLName": {
                return Optional.ofNullable(clazz.cast(this.webACLName()));
            }
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
            case "RuleGroupRuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupRuleName()));
            }
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRateBasedStatementManagedKeysRequest, T> g) {
        return obj -> g.apply((GetRateBasedStatementManagedKeysRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Request.BuilderImpl
    implements Builder {
        private String scope;
        private String webACLName;
        private String webACLId;
        private String ruleGroupRuleName;
        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRateBasedStatementManagedKeysRequest model) {
            super(model);
            this.scope(model.scope);
            this.webACLName(model.webACLName);
            this.webACLId(model.webACLId);
            this.ruleGroupRuleName(model.ruleGroupRuleName);
            this.ruleName(model.ruleName);
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        @Transient
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        @Transient
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getWebACLName() {
            return this.webACLName;
        }

        public final void setWebACLName(String webACLName) {
            this.webACLName = webACLName;
        }

        @Override
        @Transient
        public final Builder webACLName(String webACLName) {
            this.webACLName = webACLName;
            return this;
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        @Transient
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getRuleGroupRuleName() {
            return this.ruleGroupRuleName;
        }

        public final void setRuleGroupRuleName(String ruleGroupRuleName) {
            this.ruleGroupRuleName = ruleGroupRuleName;
        }

        @Override
        @Transient
        public final Builder ruleGroupRuleName(String ruleGroupRuleName) {
            this.ruleGroupRuleName = ruleGroupRuleName;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        @Transient
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRateBasedStatementManagedKeysRequest build() {
            return new GetRateBasedStatementManagedKeysRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRateBasedStatementManagedKeysRequest> {
        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder webACLName(String var1);

        public Builder webACLId(String var1);

        public Builder ruleGroupRuleName(String var1);

        public Builder ruleName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

