/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleGroupResponse extends Wafv2Response implements
        ToCopyableBuilder<CreateRuleGroupResponse.Builder, CreateRuleGroupResponse> {
    private static final SdkField<RuleGroupSummary> SUMMARY_FIELD = SdkField.<RuleGroupSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Summary").getter(getter(CreateRuleGroupResponse::summary)).setter(setter(Builder::summary))
            .constructor(RuleGroupSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD));

    private final RuleGroupSummary summary;

    private CreateRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.summary = builder.summary;
    }

    /**
     * <p>
     * High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This provides
     * information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that you
     * provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.
     * </p>
     * 
     * @return High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This
     *         provides information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and
     *         the ARN, that you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a
     *         <a>Rule</a>.
     */
    public final RuleGroupSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleGroupResponse)) {
            return false;
        }
        CreateRuleGroupResponse other = (CreateRuleGroupResponse) obj;
        return Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleGroupResponse").add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleGroupResponse, T> g) {
        return obj -> g.apply((CreateRuleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleGroupResponse> {
        /**
         * <p>
         * High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This provides
         * information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that
         * you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.
         * </p>
         * 
         * @param summary
         *        High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This
         *        provides information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>,
         *        and the ARN, that you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a
         *        <a>Rule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(RuleGroupSummary summary);

        /**
         * <p>
         * High-level information about a <a>RuleGroup</a>, returned by operations like create and list. This provides
         * information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that
         * you provide to the <a>RuleGroupReferenceStatement</a> to use the rule group in a <a>Rule</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleGroupSummary.Builder} avoiding the
         * need to create one manually via {@link RuleGroupSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleGroupSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #summary(RuleGroupSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link RuleGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(RuleGroupSummary)
         */
        default Builder summary(Consumer<RuleGroupSummary.Builder> summary) {
            return summary(RuleGroupSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private RuleGroupSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleGroupResponse model) {
            super(model);
            summary(model.summary);
        }

        public final RuleGroupSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(RuleGroupSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(RuleGroupSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public CreateRuleGroupResponse build() {
            return new CreateRuleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
