/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule group that's defined for an Firewall Manager WAF policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallManagerRuleGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallManagerRuleGroup.Builder, FirewallManagerRuleGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FirewallManagerRuleGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(FirewallManagerRuleGroup::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<FirewallManagerStatement> FIREWALL_MANAGER_STATEMENT_FIELD = SdkField
            .<FirewallManagerStatement> builder(MarshallingType.SDK_POJO).memberName("FirewallManagerStatement")
            .getter(getter(FirewallManagerRuleGroup::firewallManagerStatement)).setter(setter(Builder::firewallManagerStatement))
            .constructor(FirewallManagerStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallManagerStatement").build())
            .build();

    private static final SdkField<OverrideAction> OVERRIDE_ACTION_FIELD = SdkField
            .<OverrideAction> builder(MarshallingType.SDK_POJO).memberName("OverrideAction")
            .getter(getter(FirewallManagerRuleGroup::overrideAction)).setter(setter(Builder::overrideAction))
            .constructor(OverrideAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideAction").build()).build();

    private static final SdkField<VisibilityConfig> VISIBILITY_CONFIG_FIELD = SdkField
            .<VisibilityConfig> builder(MarshallingType.SDK_POJO).memberName("VisibilityConfig")
            .getter(getter(FirewallManagerRuleGroup::visibilityConfig)).setter(setter(Builder::visibilityConfig))
            .constructor(VisibilityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PRIORITY_FIELD,
            FIREWALL_MANAGER_STATEMENT_FIELD, OVERRIDE_ACTION_FIELD, VISIBILITY_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer priority;

    private final FirewallManagerStatement firewallManagerStatement;

    private final OverrideAction overrideAction;

    private final VisibilityConfig visibilityConfig;

    private FirewallManagerRuleGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.priority = builder.priority;
        this.firewallManagerStatement = builder.firewallManagerStatement;
        this.overrideAction = builder.overrideAction;
        this.visibilityConfig = builder.visibilityConfig;
    }

    /**
     * <p>
     * The name of the rule group. You cannot change the name of a rule group after you create it.
     * </p>
     * 
     * @return The name of the rule group. You cannot change the name of a rule group after you create it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * If you define more than one rule group in the first or last Firewall Manager rule groups, WAF evaluates each
     * request against the rule groups in order, starting from the lowest priority setting. The priorities don't need to
     * be consecutive, but they must all be different.
     * </p>
     * 
     * @return If you define more than one rule group in the first or last Firewall Manager rule groups, WAF evaluates
     *         each request against the rule groups in order, starting from the lowest priority setting. The priorities
     *         don't need to be consecutive, but they must all be different.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but it can
     * only contain a rule group reference.
     * </p>
     * 
     * @return The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but
     *         it can only contain a rule group reference.
     */
    public final FirewallManagerStatement firewallManagerStatement() {
        return firewallManagerStatement;
    }

    /**
     * <p>
     * The action to use in the place of the action that results from the rule group evaluation. Set the override action
     * to none to leave the result of the rule group alone. Set it to count to override the result to count only.
     * </p>
     * <p>
     * You can only use this for rule statements that reference a rule group, like
     * <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>.
     * </p>
     * <note>
     * <p>
     * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want
     * the rules in the rule group to only count matches, do not use this and instead exclude those rules in your rule
     * group reference statement settings.
     * </p>
     * </note>
     * 
     * @return The action to use in the place of the action that results from the rule group evaluation. Set the
     *         override action to none to leave the result of the rule group alone. Set it to count to override the
     *         result to count only. </p>
     *         <p>
     *         You can only use this for rule statements that reference a rule group, like
     *         <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>.
     *         </p>
     *         <note>
     *         <p>
     *         This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If
     *         you want the rules in the rule group to only count matches, do not use this and instead exclude those
     *         rules in your rule group reference statement settings.
     *         </p>
     */
    public final OverrideAction overrideAction() {
        return overrideAction;
    }

    /**
     * <p>
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     * </p>
     * 
     * @return Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public final VisibilityConfig visibilityConfig() {
        return visibilityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(firewallManagerStatement());
        hashCode = 31 * hashCode + Objects.hashCode(overrideAction());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallManagerRuleGroup)) {
            return false;
        }
        FirewallManagerRuleGroup other = (FirewallManagerRuleGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(priority(), other.priority())
                && Objects.equals(firewallManagerStatement(), other.firewallManagerStatement())
                && Objects.equals(overrideAction(), other.overrideAction())
                && Objects.equals(visibilityConfig(), other.visibilityConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallManagerRuleGroup").add("Name", name()).add("Priority", priority())
                .add("FirewallManagerStatement", firewallManagerStatement()).add("OverrideAction", overrideAction())
                .add("VisibilityConfig", visibilityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "FirewallManagerStatement":
            return Optional.ofNullable(clazz.cast(firewallManagerStatement()));
        case "OverrideAction":
            return Optional.ofNullable(clazz.cast(overrideAction()));
        case "VisibilityConfig":
            return Optional.ofNullable(clazz.cast(visibilityConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallManagerRuleGroup, T> g) {
        return obj -> g.apply((FirewallManagerRuleGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallManagerRuleGroup> {
        /**
         * <p>
         * The name of the rule group. You cannot change the name of a rule group after you create it.
         * </p>
         * 
         * @param name
         *        The name of the rule group. You cannot change the name of a rule group after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If you define more than one rule group in the first or last Firewall Manager rule groups, WAF evaluates each
         * request against the rule groups in order, starting from the lowest priority setting. The priorities don't
         * need to be consecutive, but they must all be different.
         * </p>
         * 
         * @param priority
         *        If you define more than one rule group in the first or last Firewall Manager rule groups, WAF
         *        evaluates each request against the rule groups in order, starting from the lowest priority setting.
         *        The priorities don't need to be consecutive, but they must all be different.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but it
         * can only contain a rule group reference.
         * </p>
         * 
         * @param firewallManagerStatement
         *        The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>,
         *        but it can only contain a rule group reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallManagerStatement(FirewallManagerStatement firewallManagerStatement);

        /**
         * <p>
         * The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but it
         * can only contain a rule group reference.
         * </p>
         * This is a convenience method that creates an instance of the {@link FirewallManagerStatement.Builder}
         * avoiding the need to create one manually via {@link FirewallManagerStatement#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallManagerStatement.Builder#build()} is called immediately
         * and its result is passed to {@link #firewallManagerStatement(FirewallManagerStatement)}.
         * 
         * @param firewallManagerStatement
         *        a consumer that will call methods on {@link FirewallManagerStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallManagerStatement(FirewallManagerStatement)
         */
        default Builder firewallManagerStatement(Consumer<FirewallManagerStatement.Builder> firewallManagerStatement) {
            return firewallManagerStatement(FirewallManagerStatement.builder().applyMutation(firewallManagerStatement).build());
        }

        /**
         * <p>
         * The action to use in the place of the action that results from the rule group evaluation. Set the override
         * action to none to leave the result of the rule group alone. Set it to count to override the result to count
         * only.
         * </p>
         * <p>
         * You can only use this for rule statements that reference a rule group, like
         * <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>.
         * </p>
         * <note>
         * <p>
         * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you
         * want the rules in the rule group to only count matches, do not use this and instead exclude those rules in
         * your rule group reference statement settings.
         * </p>
         * </note>
         * 
         * @param overrideAction
         *        The action to use in the place of the action that results from the rule group evaluation. Set the
         *        override action to none to leave the result of the rule group alone. Set it to count to override the
         *        result to count only. </p>
         *        <p>
         *        You can only use this for rule statements that reference a rule group, like
         *        <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>.
         *        </p>
         *        <note>
         *        <p>
         *        This option is usually set to none. It does not affect how the rules in the rule group are evaluated.
         *        If you want the rules in the rule group to only count matches, do not use this and instead exclude
         *        those rules in your rule group reference statement settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideAction(OverrideAction overrideAction);

        /**
         * <p>
         * The action to use in the place of the action that results from the rule group evaluation. Set the override
         * action to none to leave the result of the rule group alone. Set it to count to override the result to count
         * only.
         * </p>
         * <p>
         * You can only use this for rule statements that reference a rule group, like
         * <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code>.
         * </p>
         * <note>
         * <p>
         * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you
         * want the rules in the rule group to only count matches, do not use this and instead exclude those rules in
         * your rule group reference statement settings.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link OverrideAction.Builder} avoiding
         * the need to create one manually via {@link OverrideAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link OverrideAction.Builder#build()} is called immediately and its
         * result is passed to {@link #overrideAction(OverrideAction)}.
         * 
         * @param overrideAction
         *        a consumer that will call methods on {@link OverrideAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideAction(OverrideAction)
         */
        default Builder overrideAction(Consumer<OverrideAction.Builder> overrideAction) {
            return overrideAction(OverrideAction.builder().applyMutation(overrideAction).build());
        }

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * 
         * @param visibilityConfig
         *        Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityConfig(VisibilityConfig visibilityConfig);

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisibilityConfig.Builder} avoiding the
         * need to create one manually via {@link VisibilityConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VisibilityConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #visibilityConfig(VisibilityConfig)}.
         * 
         * @param visibilityConfig
         *        a consumer that will call methods on {@link VisibilityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibilityConfig(VisibilityConfig)
         */
        default Builder visibilityConfig(Consumer<VisibilityConfig.Builder> visibilityConfig) {
            return visibilityConfig(VisibilityConfig.builder().applyMutation(visibilityConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer priority;

        private FirewallManagerStatement firewallManagerStatement;

        private OverrideAction overrideAction;

        private VisibilityConfig visibilityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallManagerRuleGroup model) {
            name(model.name);
            priority(model.priority);
            firewallManagerStatement(model.firewallManagerStatement);
            overrideAction(model.overrideAction);
            visibilityConfig(model.visibilityConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final FirewallManagerStatement.Builder getFirewallManagerStatement() {
            return firewallManagerStatement != null ? firewallManagerStatement.toBuilder() : null;
        }

        public final void setFirewallManagerStatement(FirewallManagerStatement.BuilderImpl firewallManagerStatement) {
            this.firewallManagerStatement = firewallManagerStatement != null ? firewallManagerStatement.build() : null;
        }

        @Override
        public final Builder firewallManagerStatement(FirewallManagerStatement firewallManagerStatement) {
            this.firewallManagerStatement = firewallManagerStatement;
            return this;
        }

        public final OverrideAction.Builder getOverrideAction() {
            return overrideAction != null ? overrideAction.toBuilder() : null;
        }

        public final void setOverrideAction(OverrideAction.BuilderImpl overrideAction) {
            this.overrideAction = overrideAction != null ? overrideAction.build() : null;
        }

        @Override
        public final Builder overrideAction(OverrideAction overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }

        public final VisibilityConfig.Builder getVisibilityConfig() {
            return visibilityConfig != null ? visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(VisibilityConfig.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        public final Builder visibilityConfig(VisibilityConfig visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        @Override
        public FirewallManagerRuleGroup build() {
            return new FirewallManagerRuleGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
