/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMobileSdkReleaseResponse extends Wafv2Response implements
        ToCopyableBuilder<GetMobileSdkReleaseResponse.Builder, GetMobileSdkReleaseResponse> {
    private static final SdkField<MobileSdkRelease> MOBILE_SDK_RELEASE_FIELD = SdkField
            .<MobileSdkRelease> builder(MarshallingType.SDK_POJO).memberName("MobileSdkRelease")
            .getter(getter(GetMobileSdkReleaseResponse::mobileSdkRelease)).setter(setter(Builder::mobileSdkRelease))
            .constructor(MobileSdkRelease::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobileSdkRelease").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOBILE_SDK_RELEASE_FIELD));

    private final MobileSdkRelease mobileSdkRelease;

    private GetMobileSdkReleaseResponse(BuilderImpl builder) {
        super(builder);
        this.mobileSdkRelease = builder.mobileSdkRelease;
    }

    /**
     * <p>
     * Information for a specified SDK release, including release notes and tags.
     * </p>
     * 
     * @return Information for a specified SDK release, including release notes and tags.
     */
    public final MobileSdkRelease mobileSdkRelease() {
        return mobileSdkRelease;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mobileSdkRelease());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMobileSdkReleaseResponse)) {
            return false;
        }
        GetMobileSdkReleaseResponse other = (GetMobileSdkReleaseResponse) obj;
        return Objects.equals(mobileSdkRelease(), other.mobileSdkRelease());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMobileSdkReleaseResponse").add("MobileSdkRelease", mobileSdkRelease()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MobileSdkRelease":
            return Optional.ofNullable(clazz.cast(mobileSdkRelease()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMobileSdkReleaseResponse, T> g) {
        return obj -> g.apply((GetMobileSdkReleaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetMobileSdkReleaseResponse> {
        /**
         * <p>
         * Information for a specified SDK release, including release notes and tags.
         * </p>
         * 
         * @param mobileSdkRelease
         *        Information for a specified SDK release, including release notes and tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobileSdkRelease(MobileSdkRelease mobileSdkRelease);

        /**
         * <p>
         * Information for a specified SDK release, including release notes and tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link MobileSdkRelease.Builder} avoiding the
         * need to create one manually via {@link MobileSdkRelease#builder()}.
         *
         * When the {@link Consumer} completes, {@link MobileSdkRelease.Builder#build()} is called immediately and its
         * result is passed to {@link #mobileSdkRelease(MobileSdkRelease)}.
         * 
         * @param mobileSdkRelease
         *        a consumer that will call methods on {@link MobileSdkRelease.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mobileSdkRelease(MobileSdkRelease)
         */
        default Builder mobileSdkRelease(Consumer<MobileSdkRelease.Builder> mobileSdkRelease) {
            return mobileSdkRelease(MobileSdkRelease.builder().applyMutation(mobileSdkRelease).build());
        }
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private MobileSdkRelease mobileSdkRelease;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMobileSdkReleaseResponse model) {
            super(model);
            mobileSdkRelease(model.mobileSdkRelease);
        }

        public final MobileSdkRelease.Builder getMobileSdkRelease() {
            return mobileSdkRelease != null ? mobileSdkRelease.toBuilder() : null;
        }

        public final void setMobileSdkRelease(MobileSdkRelease.BuilderImpl mobileSdkRelease) {
            this.mobileSdkRelease = mobileSdkRelease != null ? mobileSdkRelease.build() : null;
        }

        @Override
        public final Builder mobileSdkRelease(MobileSdkRelease mobileSdkRelease) {
            this.mobileSdkRelease = mobileSdkRelease;
            return this;
        }

        @Override
        public GetMobileSdkReleaseResponse build() {
            return new GetMobileSdkReleaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
